/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.json.JSONObject;
import org.kie.server.router.Configuration;
import org.kie.server.router.proxy.KieServerProxyClient;
import org.kie.server.router.proxy.aggragate.JSONResponseAggregator;
import org.kie.server.router.proxy.aggragate.JaxbXMLResponseAggregator;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;
import org.kie.server.router.proxy.aggragate.XstreamXMLResponseAggregator;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.repository.FileRepository;

public class AdminHttpHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(AdminHttpHandler.class);
    private KieServerProxyClient proxyClient;
    private Configuration configuration = new Configuration();
    private List<ResponseAggregator> aggregators = new ArrayList<ResponseAggregator>();
    private FileRepository repository = null;
    private ConfigurationMarshaller marshaller = new ConfigurationMarshaller();

    public AdminHttpHandler(KieServerProxyClient proxyClient, FileRepository repository) {
        this.proxyClient = proxyClient;
        this.repository = repository;
        Configuration loaded = repository.load();
        if (loaded != null) {
            this.configuration = loaded;
            Map<String, Set<String>> perContainer = this.configuration.getHostsPerContainer();
            for (Map.Entry<String, Set<String>> entry : perContainer.entrySet()) {
                String containerId = entry.getKey();
                entry.getValue().forEach(url -> proxyClient.addContainer(containerId, URI.create(url)));
            }
        }
        this.aggregators.add(new JSONResponseAggregator());
        this.aggregators.add(new XstreamXMLResponseAggregator());
        this.aggregators.add(new JaxbXMLResponseAggregator());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        if (path.startsWith("/list")) {
            String jsonConfig = this.marshaller.marshall(this.configuration);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, jsonConfig.getBytes("UTF-8").length);
            exchange.getResponseSender().send(jsonConfig);
            return;
        }
        exchange.getRequestReceiver().receiveFullString((ex, data) -> {
            block10: {
                try {
                    JSONObject jsonData = new JSONObject(data);
                    String containerId = jsonData.getString("containerId");
                    String serverId = jsonData.getString("serverId");
                    String serverUrl = jsonData.getString("serverUrl");
                    if (path.startsWith("/add")) {
                        this.proxyClient.addContainer(containerId, URI.create(serverUrl));
                        log.infof("Added %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                        Configuration configuration = this.configuration;
                        synchronized (configuration) {
                            this.configuration.addContainerHost(containerId, serverUrl);
                            this.configuration.addServerHost(serverId, serverUrl);
                            this.repository.persist(this.configuration);
                        }
                        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                        break block10;
                    }
                    if (path.startsWith("/remove")) {
                        this.proxyClient.removeContainer(containerId, URI.create(serverUrl));
                        log.infof("Removed %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                        Configuration configuration = this.configuration;
                        synchronized (configuration) {
                            this.configuration.removeContainerHost(containerId, serverUrl);
                            this.configuration.removeServerHost(serverId, serverUrl);
                            this.repository.persist(this.configuration);
                        }
                        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                        break block10;
                    }
                    exchange.getResponseHeaders().put(Headers.STATUS, "");
                    ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
                }
                catch (Exception e) {
                    log.error((Object)"Error while performing admin operation", e);
                }
            }
        });
    }

    public Map<String, Set<String>> getHostsPerServer() {
        return this.configuration.getHostsPerServer();
    }

    public List<ResponseAggregator> getAggregators() {
        return Collections.unmodifiableList(this.aggregators);
    }
}

