/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KieServerProxyClient
implements ProxyClient {
    private static final String NOT_FOUND = "NOT_FOUND";
    private Pattern p = Pattern.compile(".*/containers/([^/]+).*");
    private Pattern p2 = Pattern.compile(".*/containers/instances/([^/]+).*");
    private Map<String, LoadBalancingProxyClient> containerClients = new ConcurrentHashMap<String, LoadBalancingProxyClient>();

    public synchronized void addContainer(String containerId, URI serverURI) {
        LoadBalancingProxyClient client = this.containerClients.get(containerId);
        if (client == null) {
            client = new LoadBalancingProxyClient();
            this.containerClients.put(containerId, client);
        }
        client.addHost(serverURI);
    }

    public synchronized void removeContainer(String containerId, URI serverURI) {
        LoadBalancingProxyClient client = this.containerClients.get(containerId);
        if (client == null) {
            return;
        }
        client.removeHost(serverURI);
    }

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        String containerId = this.resolveContainerId(exchange);
        LoadBalancingProxyClient client = this.containerClients.get(containerId);
        if (client == null) {
            return null;
        }
        return client.findTarget(exchange);
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        String containerId = this.resolveContainerId(exchange);
        LoadBalancingProxyClient client = this.containerClients.get(containerId);
        client.getConnection(target, exchange, callback, timeout, timeUnit);
    }

    protected String resolveContainerId(HttpServerExchange exchange) {
        String containerId;
        String relativePath = exchange.getRelativePath();
        Matcher matcher = this.p.matcher(relativePath);
        if (matcher.find() && this.containerClients.containsKey(containerId = matcher.group(1))) {
            return containerId;
        }
        matcher = this.p2.matcher(relativePath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return NOT_FOUND;
    }
}

