/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggragate;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;
import org.kie.server.router.utils.Helper;

public class JSONResponseAggregator
implements ResponseAggregator {
    private static final String JSON_TYPE = "application/json";
    private static final Properties sortByMapping = Helper.readProperties(JSONResponseAggregator.class.getResourceAsStream("/sort-json.mapping"));

    @Override
    public String aggregate(List<String> data) {
        return this.aggregate(data, null, true, 0, 10);
    }

    @Override
    public String aggregate(List<String> data, String sortBy, boolean ascending, Integer page, Integer pageSize) {
        JSONObject json = data.stream().map(s -> this.newJson((String)s)).reduce((source, target) -> {
            this.deepMerge((JSONObject)source, (JSONObject)target);
            return target;
        }).get();
        String response = this.sort(sortBy, ascending, page, pageSize, json);
        return response;
    }

    protected String sort(String fieldName, final boolean ascending, Integer page, Integer pageSize, JSONObject source) {
        try {
            for (String key : JSONObject.getNames(source)) {
                List tmp;
                Object value = source.get(key);
                if (!(value instanceof JSONArray)) continue;
                JSONArray array = (JSONArray)value;
                Field f = array.getClass().getDeclaredField("myArrayList");
                f.setAccessible(true);
                List jsonList = (List)f.get(array);
                if (fieldName != null && !fieldName.isEmpty()) {
                    final String sortBy = sortByMapping.getProperty(fieldName, fieldName);
                    Collections.sort(jsonList, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                                try {
                                    Comparable v1 = (Comparable)((JSONObject)o1).get(sortBy);
                                    Comparable v2 = (Comparable)((JSONObject)o2).get(sortBy);
                                    if (ascending) {
                                        return v1.compareTo(v2);
                                    }
                                    return v2.compareTo(v1);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return 0;
                        }
                    });
                }
                int start = page * pageSize;
                int end = start + pageSize;
                if (jsonList.size() < start) {
                    jsonList.clear();
                    continue;
                }
                if (jsonList.size() >= end) {
                    tmp = jsonList.subList(start, end);
                    jsonList.retainAll(tmp);
                    continue;
                }
                if (jsonList.size() >= end) continue;
                tmp = jsonList.subList(start, jsonList.size());
                jsonList.retainAll(tmp);
            }
            return source.toString(2);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while sorting and paging of json", e);
        }
    }

    protected JSONObject deepMerge(JSONObject source, JSONObject target) {
        try {
            for (String key : JSONObject.getNames(source)) {
                Object value = source.get(key);
                if (!target.has(key)) {
                    target.put(key, value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    JSONObject valueJson = (JSONObject)value;
                    this.deepMerge(valueJson, target.getJSONObject(key));
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)value;
                    int size = jsonArray.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject objectInArray = jsonArray.getJSONObject(i);
                        ((JSONArray)target.get(key)).put(objectInArray);
                    }
                    continue;
                }
                target.put(key, value);
            }
            return target;
        }
        catch (JSONException e) {
            return null;
        }
    }

    protected JSONObject newJson(String data) {
        try {
            return new JSONObject(data);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public boolean supports(Object ... acceptTypes) {
        for (Object acceptType : acceptTypes) {
            boolean found;
            if (acceptType == null || !(found = acceptType.toString().toLowerCase().contains(JSON_TYPE))) continue;
            return true;
        }
        return false;
    }
}

