/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.regex.Pattern;
import org.wildfly.common.Assert;

public final class HostName {
    private static final Object lock = new Object();
    private static volatile String hostName;
    private static volatile String qualifiedHostName;
    private static volatile String nodeName;

    private HostName() {
    }

    static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            addr = InetAddress.getByName(null);
        }
        return addr;
    }

    public static String getHostName() {
        return hostName;
    }

    public static String getQualifiedHostName() {
        return qualifiedHostName;
    }

    public static String getNodeName() {
        return nodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setQualifiedHostName(String qualifiedHostName) {
        Assert.checkNotNullParam("qualifiedHostName", qualifiedHostName);
        Object object = lock;
        synchronized (object) {
            HostName.qualifiedHostName = qualifiedHostName;
            int idx = qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
        }
    }

    public static void setNodeName(String nodeName) {
        Assert.checkNotNullParam("nodeName", nodeName);
        HostName.nodeName = nodeName;
    }

    static {
        String[] names = AccessController.doPrivileged(() -> {
            String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
            String providedHostName = System.getProperty("jboss.host.name");
            String providedNodeName = System.getProperty("jboss.node.name");
            if (qualifiedHostName == null) {
                qualifiedHostName = providedHostName;
                if (qualifiedHostName == null) {
                    qualifiedHostName = System.getenv("HOSTNAME");
                }
                if (qualifiedHostName == null) {
                    qualifiedHostName = System.getenv("COMPUTERNAME");
                }
                if (qualifiedHostName == null) {
                    try {
                        qualifiedHostName = HostName.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        qualifiedHostName = null;
                    }
                }
                if (qualifiedHostName != null && Pattern.compile("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:").matcher(qualifiedHostName).find()) {
                    qualifiedHostName = null;
                }
                qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
            }
            if (providedHostName == null) {
                int idx = qualifiedHostName.indexOf(46);
                String string = providedHostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
            }
            if (providedNodeName == null) {
                providedNodeName = providedHostName;
            }
            return new String[]{providedHostName, qualifiedHostName, providedNodeName};
        });
        hostName = names[0];
        qualifiedHostName = names[1];
        nodeName = names[2];
    }
}

