/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.util.HttpString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.router.proxy.DefaultRestrictionPolicy;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultRestrictionPolicyTest {
    @Mock
    private ServerConnection serverConnection;
    private DefaultRestrictionPolicy restrictionPolicy;

    @Before
    public void setup() {
        this.restrictionPolicy = new DefaultRestrictionPolicy();
    }

    @Test
    public void testRestrictedEndpointWhenEndpointIsNotRestricted() {
        HttpServerExchange exchange = this.makeHttpServerExchange("/containers/containerId", "GET");
        String containerId = "containerId";
        boolean isRestricted = this.restrictionPolicy.restrictedEndpoint(exchange, "containerId");
        Assert.assertFalse((boolean)isRestricted);
    }

    @Test
    public void testRestrictedEndpointWhenRequestMethodIsNotGET() {
        HttpServerExchange exchange = this.makeHttpServerExchange("/containers/containerId", "POST");
        String containerId = "containerId";
        boolean isRestricted = this.restrictionPolicy.restrictedEndpoint(exchange, "containerId");
        Assert.assertTrue((boolean)isRestricted);
    }

    @Test
    public void testRestrictedEndpointWhenRelativePathEndsWithContainerId() {
        HttpServerExchange exchange = this.makeHttpServerExchange("/scanner", "POST");
        String containerId = "containerId";
        boolean isRestricted = this.restrictionPolicy.restrictedEndpoint(exchange, "containerId");
        Assert.assertTrue((boolean)isRestricted);
    }

    @Test
    public void testRestrictedEndpointWhenRelativePathEndsWithReleaseId() {
        HttpServerExchange exchange = this.makeHttpServerExchange("/release-id", "POST");
        String containerId = "containerId";
        boolean isRestricted = this.restrictionPolicy.restrictedEndpoint(exchange, "containerId");
        Assert.assertTrue((boolean)isRestricted);
    }

    private HttpServerExchange makeHttpServerExchange(String relativePath, String requestMethod) {
        HttpServerExchange exchange = new HttpServerExchange(this.serverConnection);
        exchange.setRelativePath(relativePath);
        exchange.setRequestMethod(HttpString.tryFromString((String)requestMethod));
        return exchange;
    }
}

