/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyHeadersParser;
import io.undertow.protocols.spdy.SpdyStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class SpdyStreamStreamSourceChannel
extends SpdyStreamSourceChannel {
    private boolean rst = false;
    private final HeaderMap headers;
    private final int streamId;
    private HeaderMap newHeaders = null;
    private int flowControlWindow;
    private ChannelListener<SpdyStreamStreamSourceChannel> completionListener;

    SpdyStreamStreamSourceChannel(SpdyChannel framedChannel, PooledByteBuffer data, long frameDataRemaining, HeaderMap headers, int streamId) {
        super(framedChannel, data, frameDataRemaining);
        this.headers = headers;
        this.streamId = streamId;
        this.flowControlWindow = framedChannel.getInitialWindowSize();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.handleNewHeaders();
        int read = super.read(dst);
        this.updateFlowControlWindow(read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts, offset, length);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel streamSinkChannel) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(count, throughBuffer, streamSinkChannel);
        this.updateFlowControlWindow((int)read + throughBuffer.remaining());
        return read;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(position, count, target);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    protected void handleHeaderData(FrameHeaderData headerData) {
        super.handleHeaderData(headerData);
        SpdyChannel.SpdyFrameParser data = (SpdyChannel.SpdyFrameParser)headerData;
        if (data.parser instanceof SpdyHeadersParser) {
            this.addNewHeaders(((SpdyHeadersParser)data.parser).getHeaderMap());
        }
    }

    private synchronized void handleNewHeaders() {
        if (this.newHeaders != null) {
            for (HeaderValues header : this.newHeaders) {
                this.headers.addAll(header.getHeaderName(), header);
            }
            this.newHeaders = null;
        }
    }

    synchronized void addNewHeaders(HeaderMap headers) {
        if (this.newHeaders != null) {
            this.newHeaders = headers;
        } else {
            for (HeaderValues header : headers) {
                this.newHeaders.addAll(header.getHeaderName(), header);
            }
        }
    }

    private void updateFlowControlWindow(int read) {
        if (read <= 0) {
            return;
        }
        this.flowControlWindow -= read;
        SpdyChannel spdyChannel = this.getSpdyChannel();
        spdyChannel.updateReceiveFlowControlWindow(read);
        int initialWindowSize = spdyChannel.getInitialWindowSize();
        if (this.flowControlWindow < initialWindowSize / 2) {
            int delta = initialWindowSize - this.flowControlWindow;
            this.flowControlWindow += delta;
            spdyChannel.sendUpdateWindowSize(this.streamId, delta);
        }
    }

    @Override
    protected void complete() throws IOException {
        super.complete();
        if (this.completionListener != null) {
            ChannelListeners.invokeChannelListener(this, this.completionListener);
        }
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public ChannelListener<SpdyStreamStreamSourceChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<SpdyStreamStreamSourceChannel> completionListener) {
        this.completionListener = completionListener;
    }

    @Override
    void rstStream() {
        if (this.rst) {
            return;
        }
        this.rst = true;
        this.markStreamBroken();
        this.getSpdyChannel().sendRstStream(this.streamId, 5);
    }

    @Override
    protected void channelForciblyClosed() {
        if (this.completionListener != null) {
            this.completionListener.handleEvent(this);
        }
        this.rstStream();
    }

    public int getStreamId() {
        return this.streamId;
    }
}

