/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.json.JSONObject;
import org.kie.server.router.Configuration;
import org.kie.server.router.ContainerInfo;
import org.kie.server.router.proxy.aggragate.JSONResponseAggregator;
import org.kie.server.router.proxy.aggragate.JaxbXMLResponseAggregator;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;
import org.kie.server.router.proxy.aggragate.XstreamXMLResponseAggregator;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.HttpUtils;

public class AdminHttpHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(AdminHttpHandler.class);
    private static final String CONTROLLER = System.getProperty("org.kie.server.controller");
    private Configuration configuration = new Configuration();
    private List<ResponseAggregator> aggregators = new ArrayList<ResponseAggregator>();
    private ConfigRepository repository = null;
    private ConfigurationMarshaller marshaller = new ConfigurationMarshaller();
    private Set<String> controllerContainers = new HashSet<String>();
    private static final String CONTAINER_SPEC_JSON = "{\n    \"container-id\" : \"#1@\",\n    \"container-name\" : \"#2@\",\n    \"server-template-key\" : {\n      \"server-id\" : \"kie-server-router\",\n      \"server-name\" : \"KIE Server Router\"\n    },\n    \"release-id\" : {\n      \"group-id\" : \"#3@\",\n      \"artifact-id\" : \"#4@\",\n      \"version\" : \"#5@\"\n    },\n    \"configuration\" : { },\n    \"status\" : \"STARTED\"\n  }";

    public AdminHttpHandler(Configuration configuration, ConfigRepository repository) {
        this.configuration = configuration;
        this.repository = repository;
        this.aggregators.add(new JSONResponseAggregator());
        this.aggregators.add(new XstreamXMLResponseAggregator());
        this.aggregators.add(new JaxbXMLResponseAggregator());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        if (path.startsWith("/list")) {
            String jsonConfig = this.marshaller.marshall(this.configuration);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, jsonConfig.getBytes("UTF-8").length);
            exchange.getResponseSender().send(jsonConfig);
            return;
        }
        exchange.getRequestReceiver().receiveFullString((ex, data) -> {
            block16: {
                try {
                    JSONObject jsonData = new JSONObject(data);
                    String containerId = jsonData.getString("containerId");
                    String alias = jsonData.getString("alias");
                    String serverId = jsonData.getString("serverId");
                    String serverUrl = jsonData.getString("serverUrl");
                    String releaseId = jsonData.getString("releaseId");
                    ContainerInfo containerInfo = new ContainerInfo(containerId, alias, releaseId);
                    if (path.startsWith("/add")) {
                        log.infof("Added %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                        Configuration configuration = this.configuration;
                        synchronized (configuration) {
                            this.configuration.addContainerHost(containerId, serverUrl);
                            this.configuration.addContainerHost(alias, serverUrl);
                            this.configuration.addServerHost(serverId, serverUrl);
                            this.configuration.addContainerInfo(containerInfo);
                            this.repository.persist(this.configuration);
                        }
                        if (CONTROLLER != null && releaseId != null && !this.controllerContainers.contains(containerId)) {
                            try {
                                String[] gav = releaseId.split(":");
                                String jsonPayload = CONTAINER_SPEC_JSON.replaceFirst("#1@", containerId).replaceFirst("#2@", alias).replaceFirst("#3@", gav[0]).replaceFirst("#4@", gav[1]).replaceFirst("#5@", gav[2]);
                                HttpUtils.putHttpCall(CONTROLLER + "/management/servers/kie-server-router/containers/" + containerId, jsonPayload);
                                this.controllerContainers.add(containerId);
                                log.infof("Added %s container into controller at %s ", (Object)containerId, (Object)CONTROLLER);
                            }
                            catch (Exception e) {
                                log.warn((Object)("Exception when notifying controller about new container " + e.getMessage()), e);
                            }
                        }
                        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                        break block16;
                    }
                    if (path.startsWith("/remove")) {
                        Set<String> hostsPerContainer;
                        log.infof("Removed %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                        Configuration e = this.configuration;
                        synchronized (e) {
                            this.configuration.removeContainerHost(containerId, serverUrl);
                            this.configuration.removeContainerHost(alias, serverUrl);
                            this.configuration.removeServerHost(serverId, serverUrl);
                            this.configuration.removeContainerInfo(containerInfo.getContainerId(), containerInfo.getAlias());
                            this.repository.persist(this.configuration);
                        }
                        if (CONTROLLER != null && this.controllerContainers.contains(containerId) && (hostsPerContainer = this.configuration.getHostsPerContainer().getOrDefault(containerId, Collections.EMPTY_SET)).isEmpty()) {
                            try {
                                HttpUtils.deleteHttpCall(CONTROLLER + "/management/servers/kie-server-router/containers/" + containerId);
                                this.controllerContainers.remove(containerId);
                                log.infof("Removed %s container from controller at %s ", (Object)containerId, (Object)CONTROLLER);
                            }
                            catch (Exception e2) {
                                log.warn((Object)("Exception when notifying controller about deleted containers " + e2.getMessage()), e2);
                            }
                        }
                        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                        break block16;
                    }
                    exchange.getResponseHeaders().put(Headers.STATUS, "");
                    ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
                }
                catch (Exception e) {
                    log.error((Object)"Error while performing admin operation", e);
                }
            }
        });
    }

    public Map<String, Set<String>> getHostsPerServer() {
        return this.configuration.getHostsPerServer();
    }

    public List<ResponseAggregator> getAggregators() {
        return Collections.unmodifiableList(this.aggregators);
    }

    public void addControllerContainers(List<String> containers) {
        this.controllerContainers.addAll(containers);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnavailableServer(String url) {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            this.configuration.removeUnavailableServer(url);
            this.repository.persist(this.configuration);
        }
    }
}

