/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import org.jboss.logging.Logger;

public class HttpUtils {
    private static final Logger log = Logger.getLogger(HttpUtils.class);
    private static final String USER_NAME = System.getProperty("org.kie.server.controller.user", "kieserver");
    private static final String PASSWORD = System.getProperty("org.kie.server.controller.pwd", "kieserver1!");
    private static final String TOKEN = System.getProperty("org.kie.server.controller.token");

    public static void deleteHttpCall(String url) throws Exception {
        URL controllerURL = new URL(url);
        HttpURLConnection con = (HttpURLConnection)controllerURL.openConnection();
        con.setRequestMethod("DELETE");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", HttpUtils.getAuthorization());
        con.setDoOutput(true);
        log.debugf("Sending 'POST' request to URL : %s", (Object)controllerURL);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
    }

    public static String putHttpCall(String url, String body) throws Exception {
        String inputLine;
        URL controllerURL = new URL(url);
        HttpURLConnection con = (HttpURLConnection)controllerURL.openConnection();
        con.setRequestMethod("PUT");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", HttpUtils.getAuthorization());
        con.setDoOutput(true);
        if (body != null) {
            con.getOutputStream().write(body.getBytes("UTF-8"));
        }
        log.debugf("Sending 'POST' request to URL : %s", (Object)controllerURL);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    protected static String getAuthorization() throws Exception {
        if (TOKEN != null) {
            return "Bearer " + TOKEN;
        }
        return "Basic " + Base64.getEncoder().encodeToString((USER_NAME + ":" + PASSWORD).getBytes("UTF-8"));
    }
}

