/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.utils;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kie.server.router.utils.SSLContextBuilder;

public class SSLContextBuilderTest {
    private static final String KEYSTORE_PASSWORD = "jboss@01";
    private static final String KEYSTORE_ALIAS_ONE = "jboss";
    private static final String KEYSTORE_ALIAS_TWO = "jason";
    private static final String KEYSTORE_PATH = SSLContextBuilder.class.getClassLoader().getResource("keystores/router.keystore").getFile();
    private static final String TRUSTSTORE_PATH = SSLContextBuilder.class.getClassLoader().getResource("keystores/router.truststore").getFile();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testFirstAlias() {
        try {
            SSLContextBuilder.builder().setKeyStorePath(KEYSTORE_PATH).setKeyStorePassword(KEYSTORE_PASSWORD).setKeyAlias(KEYSTORE_ALIAS_ONE).build();
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSecondAlias() {
        try {
            SSLContextBuilder.builder().setKeyStorePath(KEYSTORE_PATH).setKeyStorePassword(KEYSTORE_PASSWORD).setKeyAlias(KEYSTORE_ALIAS_TWO).build();
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNonExistingAlias() {
        try {
            SSLContextBuilder.builder().setKeyStorePath(KEYSTORE_PATH).setKeyStorePassword(KEYSTORE_PASSWORD).setKeyAlias("bla").build();
            Assert.fail((String)"Exception not thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testIncorrectPassword() {
        try {
            SSLContextBuilder.builder().setKeyStorePath(KEYSTORE_PATH).setKeyStorePassword("bla").setKeyAlias(KEYSTORE_ALIAS_ONE).build();
            Assert.fail((String)"Exception not thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    public void testBuildTruststore() {
        try {
            SSLContextBuilder.builder().setKeyStorePath(TRUSTSTORE_PATH).setKeyStorePassword("mykeystorepass").buildTrustore();
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBuildTruststoreWithIncorrectPassword() {
        try {
            SSLContextBuilder.builder().setKeyStorePath(TRUSTSTORE_PATH).setKeyStorePassword("space_invaders").buildTrustore();
            Assert.fail((String)"Exception not thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }
}

