/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.Configuration;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.ContainerInfo;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.repository.FileRepository;

public class FileRepositoryTest {
    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.router.config.watcher.enabled");
        System.clearProperty("org.kie.server.router.config.watcher.interval");
    }

    @Test
    public void testStoreAndLoad() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        FileRepository repo = new FileRepository(new File("target"));
        repo.persist(config);
        Configuration loaded = repo.load();
        Assert.assertNotNull((Object)loaded);
        Assert.assertNotNull((Object)loaded.getHostsPerContainer());
        Assert.assertNotNull((Object)loaded.getHostsPerServer());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)loaded.getHostsPerContainer().get("container1")).iterator().next());
        Assert.assertEquals((Object)"http://localhost:8180/server", ((List)loaded.getHostsPerContainer().get("container2")).iterator().next());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerServer().get("server2")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)loaded.getHostsPerServer().get("server1")).iterator().next());
        Assert.assertEquals((Object)"http://localhost:8180/server", ((List)loaded.getHostsPerServer().get("server2")).iterator().next());
        Assert.assertEquals((long)1L, (long)((List)loaded.getContainerInfosPerContainer().get("test")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getContainerInfosPerContainer().get("test1.0")).size());
        ContainerInfo loadedCI = (ContainerInfo)((List)loaded.getContainerInfosPerContainer().get("test")).iterator().next();
        Assert.assertEquals((Object)containerInfo, (Object)loadedCI);
        loadedCI = (ContainerInfo)((List)loaded.getContainerInfosPerContainer().get("test1.0")).iterator().next();
        Assert.assertEquals((Object)containerInfo, (Object)loadedCI);
        repo.clean();
    }

    @Test
    public void testWatchServiceOnConfigFile() throws Exception {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        File repositoryDirectory = new File("target" + File.separator + UUID.randomUUID().toString());
        repositoryDirectory.mkdirs();
        FileRepository repo = new FileRepository(repositoryDirectory);
        repo.persist(config);
        System.setProperty("org.kie.server.router.config.watcher.enabled", "true");
        System.setProperty("org.kie.server.router.config.watcher.interval", "1000");
        FileRepository repoWithWatcher = new FileRepository(repositoryDirectory);
        Configuration loaded = repoWithWatcher.load();
        final CountDownLatch latch = new CountDownLatch(1);
        loaded.addListener(new ConfigurationListener(){

            public void onConfigurationReloaded() {
                latch.countDown();
            }
        });
        Assert.assertNotNull((Object)loaded);
        Assert.assertNotNull((Object)loaded.getHostsPerContainer());
        Assert.assertNotNull((Object)loaded.getHostsPerServer());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        config.removeContainerHost("container2", "http://localhost:8180/server");
        config.removeServerHost("server2", "http://localhost:8180/server");
        Thread.sleep(3000L);
        repo.persist(config);
        boolean reloaded = latch.await(20L, TimeUnit.SECONDS);
        if (reloaded) {
            Assert.assertNotNull((Object)loaded);
            Assert.assertNotNull((Object)loaded.getHostsPerContainer());
            Assert.assertNotNull((Object)loaded.getHostsPerServer());
            Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
            Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
            Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
            Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
            Assert.assertEquals((long)0L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        }
        repoWithWatcher.close();
        repoWithWatcher.clean();
    }

    @Test
    public void testWatchServiceOnLatelyCreatedConfigFile() throws Exception {
        File repositoryDirectory = new File("target" + File.separator + UUID.randomUUID().toString());
        repositoryDirectory.mkdirs();
        System.setProperty("org.kie.server.router.config.watcher.enabled", "true");
        System.setProperty("org.kie.server.router.config.watcher.interval", "1000");
        FileRepository repoWithWatcher = new FileRepository(repositoryDirectory);
        Configuration loaded = repoWithWatcher.load();
        final CountDownLatch latch = new CountDownLatch(1);
        loaded.addListener(new ConfigurationListener(){

            public void onConfigurationReloaded() {
                latch.countDown();
            }
        });
        Thread.sleep(3000L);
        System.setProperty("org.kie.server.router.config.watcher.enabled", "false");
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        FileRepository repo = new FileRepository(repositoryDirectory);
        repo.persist(config);
        latch.await(20L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)loaded);
        Assert.assertNotNull((Object)loaded.getHostsPerContainer());
        Assert.assertNotNull((Object)loaded.getHostsPerServer());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        repoWithWatcher.close();
        repoWithWatcher.clean();
    }

    @Test
    public void testFileCreation() throws Exception {
        ConfigurationMarshaller marshaller = new ConfigurationMarshaller();
        Configuration configuration = new Configuration();
        File repositoryDirectory = new File("target" + File.separator + UUID.randomUUID().toString());
        repositoryDirectory.mkdirs();
        System.setProperty("org.kie.server.router.config.watcher.enabled", "true");
        System.setProperty("org.kie.server.router.config.watcher.interval", "1000");
        FileRepository repoWithWatcher = new FileRepository(repositoryDirectory);
        Configuration loaded = repoWithWatcher.load();
        final CountDownLatch latch = new CountDownLatch(1);
        loaded.addListener(new ConfigurationListener(){

            public void onConfigurationReloaded() {
                latch.countDown();
            }
        });
        Thread.sleep(3000L);
        System.setProperty("org.kie.server.router.config.watcher.enabled", "false");
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        FileRepository repo = new FileRepository(repositoryDirectory);
        repo.persist(config);
        latch.await(20L, TimeUnit.SECONDS);
        File serverStateFile = new File(repositoryDirectory, "kie-server-router.json");
        Assert.assertTrue((boolean)serverStateFile.exists());
        if (serverStateFile.exists()) {
            try (FileReader reader = new FileReader(serverStateFile);){
                configuration = marshaller.unmarshall((Reader)reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((Object)loaded.toString().trim(), (Object)configuration.toString().trim());
        repoWithWatcher.close();
        repoWithWatcher.clean();
    }
}

