/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.spec.WebConnectionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;

public class ServletUpgradeListener<T extends HttpUpgradeHandler>
implements HttpUpgradeListener {
    private final HttpServerExchange exchange;
    private final ThreadSetupHandler.Action<Void, StreamConnection> initAction;
    private final ThreadSetupHandler.Action<Void, Object> destroyAction;

    public ServletUpgradeListener(final InstanceHandle<T> instance, Deployment deployment, HttpServerExchange exchange) {
        this.exchange = exchange;
        this.initAction = deployment.createThreadSetupAction(new ThreadSetupHandler.Action<Void, StreamConnection>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call(HttpServerExchange exchange, StreamConnection context) {
                DelayedExecutor executor = new DelayedExecutor(exchange.getIoThread());
                try {
                    ((HttpUpgradeHandler)instance.getInstance()).init((WebConnection)new WebConnectionImpl(context, ServletUpgradeListener.this.exchange.getConnection().getByteBufferPool(), executor));
                }
                finally {
                    executor.openGate();
                }
                return null;
            }
        });
        this.destroyAction = new ThreadSetupHandler.Action<Void, Object>(){

            @Override
            public Void call(HttpServerExchange exchange, Object context) throws Exception {
                try {
                    ((HttpUpgradeHandler)instance.getInstance()).destroy();
                }
                finally {
                    instance.release();
                }
                return null;
            }
        };
    }

    @Override
    public void handleUpgrade(final StreamConnection channel, final HttpServerExchange exchange) {
        channel.getCloseSetter().set((ChannelListener<? extends StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection channel) {
                try {
                    ServletUpgradeListener.this.destroyAction.call(null, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.exchange.getConnection().getWorker().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletUpgradeListener.this.initAction.call(exchange, channel);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static final class DelayedExecutor
    implements Executor {
        private final Executor delegate;
        private volatile boolean queue = true;
        private final List<Runnable> tasks = new ArrayList<Runnable>();

        private DelayedExecutor(Executor delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            if (!this.queue) {
                this.delegate.execute(command);
            } else {
                DelayedExecutor delayedExecutor = this;
                synchronized (delayedExecutor) {
                    if (!this.queue) {
                        this.delegate.execute(command);
                    } else {
                        this.tasks.add(command);
                    }
                }
            }
        }

        synchronized void openGate() {
            this.queue = false;
            for (Runnable task : this.tasks) {
                this.delegate.execute(task);
            }
        }
    }
}

