/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggregate;

import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.Configuration;
import org.kie.server.router.KieServerRouterEnvironment;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.proxy.CaptureHostLoadBalancingProxyClient;
import org.kie.server.router.proxy.KieServerProxyClient;
import org.kie.server.router.repository.FileRepository;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.TrustStoreHelper;
import org.xnio.ssl.XnioSsl;

public class KieServerProxyClientTest {
    private static final String TRUSTSTORE_PATH = KieServerProxyClientTest.class.getClassLoader().getResource(TrustStoreHelper.getCurrentTrustStore()).getFile();
    private static final String TRUSTSTORE_PASSWORD = "mykeystorepass";
    private ConfigRepository repository = new FileRepository(new KieServerRouterEnvironment());
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @After
    public void cleanProps() {
        System.clearProperty("javax.net.ssl.trustStore");
        System.clearProperty("javax.net.ssl.trustStorePassword");
    }

    @Test
    public void testAddHost() throws URISyntaxException, NoSuchFieldException, IllegalAccessException {
        Configuration configuration = this.repository.load();
        AdminHttpHandler adminHandler = new AdminHttpHandler(new KieServerRouterEnvironment(), configuration, this.repository, this.executorService);
        KieServerProxyClient proxyClient = new KieServerProxyClient(configuration, adminHandler);
        String containerId = "my-container";
        URI uri = new URI("http://localhost:8080");
        Field containerClientsField = proxyClient.getClass().getDeclaredField("containerClients");
        containerClientsField.setAccessible(true);
        Map containerClients = (Map)containerClientsField.get(proxyClient);
        containerClients.put(containerId, new CaptureHostLoadBalancingProxyClientStub());
        proxyClient.addContainer(containerId, uri);
        Assert.assertEquals((long)1L, (long)containerClients.size());
        Assert.assertEquals((Object)true, (Object)containerClients.containsKey(containerId));
        Assert.assertNotNull(containerClients.get(containerId));
        CaptureHostLoadBalancingProxyClientStub client = (CaptureHostLoadBalancingProxyClientStub)((Object)containerClients.get(containerId));
        Assert.assertEquals((Object)uri, (Object)client.getHost());
        Assert.assertEquals(null, (Object)client.getSsl());
    }

    @Test
    public void testAddHostWithSSL() throws URISyntaxException, NoSuchFieldException, IllegalAccessException {
        System.setProperty("javax.net.ssl.trustStore", TRUSTSTORE_PATH);
        System.setProperty("javax.net.ssl.trustStorePassword", TRUSTSTORE_PASSWORD);
        Configuration configuration = this.repository.load();
        AdminHttpHandler adminHandler = new AdminHttpHandler(new KieServerRouterEnvironment(), configuration, this.repository, this.executorService);
        KieServerProxyClient proxyClient = new KieServerProxyClient(configuration, adminHandler);
        String containerId = "my-container-ssl";
        URI uri = new URI("https://localhost:9443");
        Field containerClientsField = proxyClient.getClass().getDeclaredField("containerClients");
        containerClientsField.setAccessible(true);
        Map containerClients = (Map)containerClientsField.get(proxyClient);
        containerClients.put(containerId, new CaptureHostLoadBalancingProxyClientStub());
        proxyClient.addContainer(containerId, uri);
        Assert.assertEquals((long)1L, (long)containerClients.size());
        Assert.assertEquals((Object)true, (Object)containerClients.containsKey(containerId));
        Assert.assertNotNull(containerClients.get(containerId));
        CaptureHostLoadBalancingProxyClientStub client = (CaptureHostLoadBalancingProxyClientStub)((Object)containerClients.get(containerId));
        Assert.assertEquals((Object)uri, (Object)client.getHost());
        Assert.assertSame(UndertowXnioSsl.class, client.getSsl().getClass());
    }

    private class CaptureHostLoadBalancingProxyClientStub
    extends CaptureHostLoadBalancingProxyClient {
        URI host;
        XnioSsl ssl;

        private CaptureHostLoadBalancingProxyClientStub() {
        }

        public synchronized LoadBalancingProxyClient addHost(URI host, XnioSsl ssl) {
            this.host = host;
            this.ssl = ssl;
            return this;
        }

        public synchronized LoadBalancingProxyClient addHost(URI host) {
            this.host = host;
            return this;
        }

        public URI getHost() {
            return this.host;
        }

        public XnioSsl getSsl() {
            return this.ssl;
        }
    }
}

