/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;
import org.kie.server.router.utils.MediaTypeUtil;

public abstract class AbstractAggregateHttpHandler
implements HttpHandler {
    protected static final Logger log = Logger.getLogger(AbstractAggregateHttpHandler.class);
    protected static final String REPLACE_PAGE = "page=[^&]*";
    protected static final String REPLACE_PAGE_SIZE = "pageSize=[^&]*";
    protected static final String DEFAULT_ACCEPT = "application/xml";
    protected HttpHandler httpHandler;
    protected AdminHttpHandler adminHandler;
    private RoundRobinHostSelector selector = new RoundRobinHostSelector();

    public AbstractAggregateHttpHandler(HttpHandler httpHandler, AdminHttpHandler adminHandler) {
        this.httpHandler = httpHandler;
        this.adminHandler = adminHandler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Deque<String> originalSortOrder;
        Deque<String> originalPageSize;
        if (exchange.getRequestMethod().equals(HttpString.tryFromString("OPTIONS"))) {
            this.handleOptions(exchange);
            return;
        }
        if (!exchange.getRequestMethod().equals(HttpString.tryFromString("GET"))) {
            this.httpHandler.handleRequest(exchange);
            return;
        }
        Map<String, Deque<String>> queryParams = exchange.getQueryParameters();
        Integer page = 0;
        Integer pageSize = 10;
        Deque<String> originalPage = queryParams.get("page");
        if (originalPage != null && !originalPage.isEmpty()) {
            page = Integer.parseInt(originalPage.getFirst());
        }
        if ((originalPageSize = queryParams.remove("pageSize")) != null && !originalPageSize.isEmpty()) {
            pageSize = Integer.parseInt(originalPageSize.getFirst());
        }
        String routerPage = "0";
        String routerPageSize = String.valueOf((1 + page) * pageSize);
        String sortBy = null;
        boolean sortOder = true;
        Deque<String> originalSortBy = queryParams.get("sort");
        if (originalSortBy != null && !originalSortBy.isEmpty()) {
            sortBy = originalSortBy.getFirst();
        }
        if ((originalSortOrder = queryParams.get("sortOrder")) != null && !originalSortOrder.isEmpty()) {
            sortOder = Boolean.parseBoolean(originalSortOrder.getFirst());
        }
        ConcurrentHashMap<String, List<String>> responseHeaders = new ConcurrentHashMap<String, List<String>>();
        List<Object> returnResponses = this.getServerHosts().parallelStream().map(url -> {
            String response = null;
            try {
                response = this.sendRequest((String)url, exchange, (Map<String, List<String>>)responseHeaders, "0", routerPageSize);
            }
            catch (Exception e) {
                log.error((Object)"Error when forwarding request to server", e);
                this.removeHostOnException((String)url, e);
            }
            return response;
        }).filter(msg -> msg != null && !msg.trim().isEmpty()).collect(Collectors.toList());
        if (returnResponses.isEmpty()) {
            ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
            return;
        }
        HeaderValues accept = exchange.getRequestHeaders().get(Headers.ACCEPT);
        HeaderValues kieContentType = exchange.getRequestHeaders().get("X-KIE-ContentType");
        ResponseAggregator responseAggregator = this.adminHandler.getAggregators().stream().filter(a -> a.supports(kieContentType, accept, DEFAULT_ACCEPT)).findFirst().orElseThrow(() -> new RuntimeException("not possible to find response aggregator for " + responseHeaders.get(Headers.ACCEPT)));
        boolean aggregatable = this.isAggregatable(responseHeaders);
        if (!aggregatable) {
            returnResponses = Collections.singletonList((String)returnResponses.get(0));
        }
        responseHeaders.forEach((name, value) -> exchange.getResponseHeaders().putAll(HttpString.tryFromString(name), (Collection<String>)value));
        String response = null;
        response = this.supportAdvancedAggregate() ? responseAggregator.aggregate(returnResponses, sortBy, sortOder, page, pageSize) : responseAggregator.aggregate(returnResponses);
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, response.getBytes("UTF-8").length);
        exchange.getResponseSender().send(response);
    }

    private boolean isAggregatable(Map<String, List<String>> responseHeaders) {
        List<String> type = responseHeaders.get("Content-Type");
        if (type == null || type.isEmpty()) {
            return true;
        }
        Map<String, String> parameters = MediaTypeUtil.extractParameterFromMediaTypeString(type.get(0));
        if (parameters.containsKey("aggregatable")) {
            Boolean aggregate = Boolean.parseBoolean(parameters.get("aggregatable"));
            return aggregate != null && aggregate != false;
        }
        return true;
    }

    protected String sendRequest(String url, HttpServerExchange exchange, Map<String, List<String>> responseHeaders, String page, String pageSize) throws Exception {
        String inputLine;
        URL obj = new URL(url + exchange.getRequestPath() + "?" + exchange.getQueryString().replaceAll(REPLACE_PAGE, "page=" + page).replaceAll(REPLACE_PAGE_SIZE, "pageSize=" + pageSize));
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        exchange.getRequestHeaders().forEach(h -> con.setRequestProperty(h.getHeaderName().toString(), h.getFirst()));
        log.debugf("Sending 'GET' request to URL : %s", (Object)obj);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        Map<String, List<String>> headers = con.getHeaderFields();
        headers.forEach((k, v) -> {
            if (k != null) {
                responseHeaders.put((String)k, (List<String>)v);
            }
        });
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    protected String sendOptionsRequest(String url, HttpServerExchange exchange, Map<String, List<String>> responseHeaders) throws Exception {
        String inputLine;
        URL obj = new URL(url + exchange.getRequestPath() + "?" + exchange.getQueryString());
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("OPTIONS");
        exchange.getRequestHeaders().forEach(h -> con.setRequestProperty(h.getHeaderName().toString(), h.getFirst()));
        log.debugf("Sending 'OPTIONS' request to URL : %s", (Object)obj);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        Map<String, List<String>> headers = con.getHeaderFields();
        headers.forEach((k, v) -> {
            if (k != null) {
                responseHeaders.put((String)k, (List<String>)v);
            }
        });
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    protected Set<String> getServerHosts() {
        return this.adminHandler.getHostsPerServer().values().stream().map(hosts -> {
            LinkedHashSet uniqueHosts = new LinkedHashSet(hosts);
            return this.selector.selectHost(uniqueHosts.toArray(new String[uniqueHosts.size()]));
        }).filter(host -> host != null).collect(Collectors.toSet());
    }

    protected void removeHostOnException(String url, Exception e) {
        if (e instanceof SocketException || e instanceof UnknownHostException) {
            this.adminHandler.removeUnavailableServer(url);
            log.warn("Removed host '" + url + "' due to its unavailability (cause " + e.getMessage() + ")");
        }
    }

    protected boolean supportAdvancedAggregate() {
        return true;
    }

    protected void handleOptions(HttpServerExchange exchange) throws Exception {
        ConcurrentHashMap<String, List> responseHeaders = new ConcurrentHashMap<String, List>();
        String returnResponse = this.getServerHosts().stream().findFirst().map(url -> {
            String response = null;
            try {
                response = this.sendOptionsRequest((String)url, exchange, (Map<String, List<String>>)responseHeaders);
            }
            catch (Exception e) {
                log.error((Object)"Error when forwarding request to server", e);
                this.removeHostOnException((String)url, e);
            }
            return response;
        }).filter(msg -> msg != null && !msg.trim().isEmpty()).orElse(null);
        if (returnResponse == null) {
            ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
            return;
        }
        responseHeaders.forEach((name, value) -> exchange.getResponseHeaders().putAll(HttpString.tryFromString(name), (Collection<String>)value));
        exchange.getResponseHeaders().put(Headers.ALLOW, returnResponse);
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, returnResponse.getBytes("UTF-8").length);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain;charset=UTF-8");
        exchange.getResponseSender().send(returnResponse);
    }

    static class RoundRobinHostSelector {
        private final AtomicInteger currentHost = new AtomicInteger(0);

        RoundRobinHostSelector() {
        }

        public String selectHost(String[] availableHosts) {
            if (availableHosts.length == 0) {
                return null;
            }
            int hostIndex = this.currentHost.incrementAndGet() % availableHosts.length;
            return availableHosts[hostIndex];
        }
    }
}

