/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.identity;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.kie.server.router.identity.HashUtil;
import org.kie.server.router.identity.IdentityService;
import org.kie.server.router.identity.KieServerInstanceAccount;

public class FileStoredIdentityManager
implements IdentityService {
    protected static final Logger log = Logger.getLogger(FileStoredIdentityManager.class);
    private static final String IDENTITY_FILE = System.getProperty("org.kie.server.router.identity.file", "users.properties");
    private File userFile = new File(IDENTITY_FILE);

    public FileStoredIdentityManager() {
        log.infof("Using <%1$s> as user repository", (Object)this.userFile.getAbsolutePath());
    }

    @Override
    public Account verify(Account account) {
        return account;
    }

    @Override
    public Account verify(Credential credential) {
        return null;
    }

    @Override
    public Account verify(String id, Credential credential) {
        if (!(credential instanceof PasswordCredential)) {
            return null;
        }
        PasswordCredential passwordCredential = (PasswordCredential)credential;
        KieServerInstanceAccount account = this.getAccount(id);
        String challenge = HashUtil.hash(id, new String(passwordCredential.getPassword()));
        if (account != null && challenge.equals(account.getHash())) {
            log.infof("Authentication succesfully for %1$s", (Object)id);
            return account;
        }
        log.infof("Authentication failed for %1$s", (Object)id);
        return null;
    }

    private KieServerInstanceAccount getAccount(String id) {
        Properties file = this.loadKieServerInstanceData();
        if (!file.containsKey(id)) {
            return null;
        }
        return new KieServerInstanceAccount(id, file.getProperty(id));
    }

    @Override
    public void addKieServerInstance(String kieServerInstanceId, String password) {
        Properties data = this.loadKieServerInstanceData();
        data.put(kieServerInstanceId, HashUtil.hash(kieServerInstanceId, password));
        this.saveKieServerInstanceData(data);
    }

    @Override
    public void removeKieServerInstance(String kieServerInstanceId) {
        Properties data = this.loadKieServerInstanceData();
        data.remove(kieServerInstanceId);
        this.saveKieServerInstanceData(data);
    }

    private Properties loadKieServerInstanceData() {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(this.userFile);){
            properties.load(is);
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "An error ocurred. File <%1$s> is a directory, it does not exist or it cannot be opened", (Object)this.userFile);
        }
        return properties;
    }

    private void saveKieServerInstanceData(Properties data) {
        try (FileOutputStream out = new FileOutputStream(this.userFile);){
            data.store(out, "Kie Server Router");
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "An error ocurred. File <%1$s> is a directory, it cannot be created or it cannot be opened", (Object)this.userFile);
        }
    }

    @Override
    public String id() {
        return "default";
    }
}

