/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.kie.server.router.ConfigurationManager;
import org.kie.server.router.KieServerRouterEnvironment;

public class ConfigFileWatcher
implements Runnable {
    private static final Logger log = Logger.getLogger(ConfigFileWatcher.class);
    private Path toWatch;
    private AtomicBoolean active = new AtomicBoolean(true);
    private ConfigurationManager configurationManager;
    private long lastUpdate = -1L;
    private KieServerRouterEnvironment env;

    public ConfigFileWatcher(KieServerRouterEnvironment env, ConfigurationManager configuration) {
        this.env = env;
        this.configurationManager = configuration;
        this.toWatch = Paths.get(env.getRepositoryDir(), new String[0]);
        if (!Files.isDirectory(this.toWatch, new LinkOption[0])) {
            this.toWatch = Paths.get(env.getRepositoryDir(), new String[0]).getParent();
        }
        this.toWatch = Paths.get(this.toWatch.toString(), "kie-server-router.json");
        try {
            if (this.toWatch.toFile().exists()) {
                this.lastUpdate = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]).toMillis();
            } else {
                log.warnv("configuration file does not exist {0} , creating...", (Object)this.toWatch);
                configuration.persist();
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to read last modified date of routers config file", e);
        }
        catch (Exception e) {
            log.error((Object)"Unable to writer config file", e);
        }
    }

    private KieServerRouterEnvironment environment() {
        return this.env;
    }

    public void stop() {
        this.active.set(false);
    }

    @Override
    public void run() {
        try {
            while (this.active.get()) {
                try {
                    if (!this.toWatch.toFile().exists()) {
                        log.warnv("configuration file does not exist {0} ", (Object)this.toWatch);
                        Thread.sleep(this.environment().getConfigFileWatcherInterval());
                        continue;
                    }
                    FileTime lastModified = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]);
                    log.debug("Config file " + this.toWatch + " last modified " + lastModified);
                    if (lastModified.toMillis() > this.lastUpdate) {
                        log.debug("Config file updated, reloading...");
                        this.configurationManager.syncPersistent();
                        this.lastUpdate = lastModified.toMillis();
                    }
                }
                catch (IOException ioe) {
                    log.warn((Object)"Unexpected exception while watching config file, maybe file does not exist? ", ioe);
                }
                Thread.sleep(this.environment().getConfigFileWatcherInterval());
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted exception received...");
        }
    }
}

