/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.identity;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class HashUtil {
    private static final String HASH_ALGORITHM = "SHA-512";
    private static final byte COLON = 58;

    private HashUtil() {
    }

    public static byte[] toBytes(String user, String password) {
        return (user + 58 + password).getBytes(StandardCharsets.UTF_8);
    }

    public static String hash(String user, String password) {
        return HashUtil.hash(user, password, HASH_ALGORITHM);
    }

    public static String hash(String user, String password, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] bytes = md.digest(HashUtil.toBytes(user, password));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

