/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jboss.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kie.server.router.Configuration;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.ConfigurationManager;
import org.kie.server.router.KieServerRouterEnvironment;
import org.kie.server.router.KieServerRouterResponsesUtil;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.handlers.ContainersHttpHandler;
import org.kie.server.router.handlers.DocumentsHttpHandler;
import org.kie.server.router.handlers.JobsHttpHandler;
import org.kie.server.router.handlers.KieServerInfoHandler;
import org.kie.server.router.handlers.OptionsHttpHandler;
import org.kie.server.router.handlers.QueriesDataHttpHandler;
import org.kie.server.router.handlers.QueriesHttpHandler;
import org.kie.server.router.identity.IdentityService;
import org.kie.server.router.proxy.KieServerProxyClient;
import org.kie.server.router.repository.FileRepository;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.HttpUtils;
import org.kie.server.router.utils.SSLContextBuilder;

public class KieServerRouter {
    public static final String CMD_ADD_USER = "addUser";
    public static final String CMD_REMOVE_USER = "removeUser";
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private ServiceLoader<ConfigRepository> configRepositoryServiceLoader = ServiceLoader.load(ConfigRepository.class);
    private Undertow server;
    private ConfigRepository repository;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(8);
    private ScheduledFuture<?> controllerConnectionAttempts;
    private KieServerRouterEnvironment env;
    private ConfigurationManager configurationManager;

    public KieServerRouter() {
        this(new KieServerRouterEnvironment());
    }

    public KieServerRouter(KieServerRouterEnvironment env) {
        this.configRepositoryServiceLoader.forEach(repo -> {
            this.repository = repo;
        });
        this.env = env;
        this.repository = new FileRepository(env);
        log.info("KIE Server router repository implementation is " + this.repository);
    }

    private KieServerRouterEnvironment environment() {
        return this.env;
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        Option addInstanceOption = Option.builder(CMD_ADD_USER).desc("addUser <user> <password>").hasArg(true).numberOfArgs(2).build();
        options.addOption(addInstanceOption);
        Option removeInstanceOption = Option.builder(CMD_REMOVE_USER).desc("removeUser <user>").hasArg(true).build();
        options.addOption(removeInstanceOption);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        final KieServerRouter router = new KieServerRouter();
        if (cmd.hasOption(CMD_ADD_USER)) {
            String[] values = cmd.getOptionValues(CMD_ADD_USER);
            router.getIdentityService().addKieServerInstance(values[0], values[1]);
            log.infof("User <%1$s> added", (Object)values[0]);
            return;
        }
        if (cmd.hasOption(CMD_REMOVE_USER)) {
            String value = cmd.getOptionValue(CMD_REMOVE_USER);
            router.getIdentityService().removeKieServerInstance(value);
            log.infof("User <%1$s> removed", (Object)value);
            return;
        }
        router.start(new ConfigurationListener[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                router.stop();
            }
        });
    }

    public void start(String host, Integer port, ConfigurationListener ... listeners) {
        this.start(host, port, 9443, listeners);
    }

    public void start(ConfigurationListener ... listeners) {
        this.start(this.environment().getRouterHost(), (Integer)this.environment().getPort(), this.environment().getSslPort(), listeners);
    }

    public void start(String host, Integer port, Integer portTls, ConfigurationListener ... listeners) {
        System.setProperty("org.kie.server.router.host", host);
        System.setProperty("org.kie.server.router.port", port.toString());
        System.setProperty("org.kie.server.router.tls.port", portTls.toString());
        boolean isHttpEnabled = this.environment().isHttpEnabled();
        this.configurationManager = new ConfigurationManager(this.environment(), this.repository, this.executorService);
        Configuration configuration = this.configurationManager.getConfiguration();
        for (ConfigurationListener listener : listeners) {
            this.configurationManager.getConfiguration().addListener(listener);
        }
        if (this.environment().isConfigFileWatcherEnabled()) {
            this.configurationManager.startWatcher();
        }
        AdminHttpHandler adminHandler = new AdminHttpHandler(this.configurationManager);
        KieServerProxyClient proxyClient = new KieServerProxyClient(this.configurationManager);
        Map<String, List<String>> perContainer = configuration.getHostsPerContainer();
        for (Map.Entry entry : perContainer.entrySet()) {
            LinkedHashSet uniqueUrls = new LinkedHashSet((Collection)entry.getValue());
            uniqueUrls.forEach(url -> proxyClient.addContainer((String)entry.getKey(), URI.create(url)));
        }
        ResponseCodeHandler notFoundHandler = ResponseCodeHandler.HANDLE_404;
        ProxyHandler proxyHandler = ProxyHandler.builder().setProxyClient(proxyClient).setMaxRequestTime(-1).setRewriteHostHeader(true).setReuseXForwarded(false).setNext(new OptionsHttpHandler(notFoundHandler, this.configurationManager)).build();
        PathHandler pathHandler = Handlers.path(proxyHandler);
        pathHandler.addPrefixPath("/queries/definitions", new QueriesDataHttpHandler(notFoundHandler, this.configurationManager));
        pathHandler.addPrefixPath("/queries", new QueriesHttpHandler(notFoundHandler, this.configurationManager));
        pathHandler.addPrefixPath("/jobs", new JobsHttpHandler(proxyHandler, this.configurationManager));
        pathHandler.addPrefixPath("/documents", new DocumentsHttpHandler(notFoundHandler, this.configurationManager));
        pathHandler.addExactPath("/containers", new ContainersHttpHandler(notFoundHandler, this.configurationManager));
        if (this.environment().isManagementSecured()) {
            IdentityService idm = this.getIdentityService();
            AuthenticationCallHandler authenticationCallHandler = new AuthenticationCallHandler(adminHandler);
            AuthenticationConstraintHandler authenticationConstraintHandler = new AuthenticationConstraintHandler(authenticationCallHandler);
            List<AuthenticationMechanism> mechanisms = Collections.singletonList(new BasicAuthenticationMechanism("KieServerRouterRealm"));
            AuthenticationMechanismsHandler authenticationMechanismsHandler = new AuthenticationMechanismsHandler(authenticationConstraintHandler, mechanisms);
            SecurityInitialHandler securityInitialHandler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, idm, authenticationMechanismsHandler);
            pathHandler.addPrefixPath("/mgmt", securityInitialHandler);
        } else {
            pathHandler.addPrefixPath("/mgmt", adminHandler);
        }
        pathHandler.addExactPath("/", new KieServerInfoHandler(this.environment()));
        BlockingHandler blockingHandler = new BlockingHandler(pathHandler);
        Undertow.Builder undertowBuilder = Undertow.builder();
        if (isHttpEnabled) {
            undertowBuilder.addHttpListener(port, host);
        }
        if (this.environment().isTlsEnabled()) {
            SSLContext sslContext = SSLContextBuilder.builder().setKeyStorePath(this.environment().getKeystorePath()).setKeyStorePassword(this.environment().getKeystorePassword()).setKeyAlias(this.environment().getKeystoreKey()).build();
            undertowBuilder = undertowBuilder.addHttpsListener(portTls, host, sslContext);
        }
        if (!isHttpEnabled && !this.environment().isTlsEnabled()) {
            throw new IllegalStateException("HTTP listener was disabled (by setting HTTP port to 0 or lower ) and TLS wasn't configured, no listener is available to handle requests");
        }
        this.server = undertowBuilder.setHandler(blockingHandler).build();
        this.server.start();
        if (log.isInfoEnabled()) {
            this.logServerInfo("KieServerRouter started on: ", host, port, portTls);
        }
        this.connectToController(this.configurationManager);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean clean) {
        this.configurationManager.close();
        this.executorService.shutdownNow();
        this.disconnectToController();
        if (this.server != null) {
            this.server.stop();
            this.repository.close();
            if (clean) {
                this.repository.clean();
            }
            if (log.isInfoEnabled()) {
                this.logServerInfo("KieServerRouter stopped on: ", System.getProperty("org.kie.server.router.host"), Integer.getInteger("org.kie.server.router.port"), Integer.getInteger("org.kie.server.router.tls.port"));
            }
        } else {
            log.error("KieServerRouter was not started");
        }
    }

    private void logServerInfo(String prefix, String host, int port, int portTls) {
        StringBuilder sb = new StringBuilder(prefix);
        if (this.environment().isHttpEnabled()) {
            sb.append(host).append(':').append(port);
        }
        if (this.environment().isTlsEnabled()) {
            sb.append(" (TLS) ").append(host).append(':').append(portTls);
        }
        log.info(sb);
    }

    protected void connectToController(ConfigurationManager configurationManager) {
        if (!this.environment().hasKieControllerUrl()) {
            return;
        }
        try {
            String jsonResponse = HttpUtils.putHttpCall(this.environment(), this.environment().getKieControllerUrl() + "/server/" + this.environment().getRouterId(), KieServerRouterResponsesUtil.buildServerInfo(this.environment()));
            log.debugf("Controller response :: ", (Object)jsonResponse);
            this.boostrapFromControllerResponse(configurationManager, jsonResponse);
            log.infof("KieServerRouter connected to controller at " + this.environment().getKieControllerUrl(), new Object[0]);
        }
        catch (Exception e) {
            log.error("Error when connecting to controller at " + this.environment().getKieControllerUrl() + " due to " + e.getMessage());
            log.debug(e);
            this.controllerConnectionAttempts = this.executorService.scheduleAtFixedRate(() -> this.tryToConnectToController(configurationManager), this.environment().getKieControllerAttemptInterval(), this.environment().getKieControllerAttemptInterval(), TimeUnit.SECONDS);
        }
    }

    private void tryToConnectToController(ConfigurationManager configurationManager) {
        try {
            String jsonResponse = HttpUtils.putHttpCall(this.environment(), this.environment().getKieControllerUrl() + "/server/" + this.environment().getRouterId(), KieServerRouterResponsesUtil.buildServerInfo(this.environment()));
            log.debugf("Controller response :: ", (Object)jsonResponse);
            this.boostrapFromControllerResponse(configurationManager, jsonResponse);
            this.controllerConnectionAttempts.cancel(false);
            log.infof("KieServerRouter connected to controller at " + this.environment().getKieControllerUrl(), new Object[0]);
        }
        catch (Exception ex) {
            log.error("Error when connecting to controller at " + this.environment().getKieControllerUrl() + " next attempt in " + this.environment().getKieControllerAttemptInterval() + " " + TimeUnit.SECONDS.toString());
            log.debug(ex);
        }
    }

    protected void disconnectToController() {
        if (!this.environment().hasKieControllerUrl()) {
            return;
        }
        try {
            HttpUtils.deleteHttpCall(this.environment(), this.environment().getKieControllerUrl() + "/server/" + this.environment().getRouterId() + "/?location=" + URLEncoder.encode(this.environment().getRouterExternalUrl(), "UTF-8"));
            log.infof("KieServerRouter disconnected from controller at " + this.environment().getKieControllerUrl(), new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error when disconnecting from controller at " + this.environment().getKieControllerUrl()), e);
        }
    }

    protected void boostrapFromControllerResponse(ConfigurationManager configurationManager, String jsonResponse) throws JSONException {
        ArrayList<String> containers = new ArrayList<String>();
        JSONObject serverConfig = new JSONObject(jsonResponse);
        try {
            JSONArray sourceList = serverConfig.getJSONArray("containers");
            for (int i = 0; i < sourceList.length(); ++i) {
                JSONObject container = sourceList.getJSONObject(i);
                containers.add(container.getString("container-id"));
            }
        }
        catch (JSONException e) {
            log.debug((Object)("Error when getting list of containers:: " + e.getMessage()), e);
        }
        configurationManager.addControllerContainers(containers);
    }

    public IdentityService getIdentityService() {
        ServiceLoader<IdentityService> services = ServiceLoader.load(IdentityService.class, Thread.currentThread().getContextClassLoader());
        for (IdentityService identityService : services) {
            if (!this.env.getIdentityProvider().contentEquals(identityService.id())) continue;
            return identityService;
        }
        throw new IdentityServiceNotFound("Identity Provider " + this.env.getIdentityProvider() + " not found !");
    }

    private static class IdentityServiceNotFound
    extends RuntimeException {
        private static final long serialVersionUID = 7156962325493936307L;

        public IdentityServiceNotFound(String msg) {
            super(msg);
        }
    }
}

