/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggragate;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.kie.server.router.proxy.aggragate.XMLResponseAggregator;
import org.kie.server.router.utils.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxbXMLResponseAggregator
extends XMLResponseAggregator {
    private static final String XML_TYPE = "application/xml";
    private static final Properties sortByMapping = Helper.readProperties(JaxbXMLResponseAggregator.class.getResourceAsStream("/sort-jaxb.mapping"));
    protected List<String> nodes = Arrays.asList("processes", "fragments", "comments", "definitions", "instances", "milestones", "role-assignments", "stages", "migration-report-instance", "process-node", "task-notification", "task-reassignment", "timer-instance", "queries", "task", "document-instances", "error-info-instance", "node-instance", "process-instance", "request-info-instance", "task-attachment", "task-comment", "task-event-instance", "task-instance", "task-summary", "variable-instance", "work-item-instance", "kie-container");

    @Override
    public boolean supports(Object ... acceptTypes) {
        return this.supports(XML_TYPE, acceptTypes);
    }

    @Override
    protected void copyNodes(NodeList children, Document target, Node targetNode) {
        for (int j = 0; j < children.getLength(); ++j) {
            Node imported;
            Node existing = children.item(j);
            if (existing.getNodeName().equals("items") && existing.hasChildNodes() && this.hasType(existing)) {
                imported = target.importNode(existing, true);
                targetNode.appendChild(imported);
                continue;
            }
            if (!this.nodes.contains(existing.getNodeName()) || !existing.hasChildNodes()) continue;
            imported = target.importNode(existing, true);
            targetNode.appendChild(imported);
        }
    }

    @Override
    protected List<String> knownNames() {
        return this.nodes;
    }

    @Override
    protected String getElementLevel(String rootNode) {
        if ("list-type".equals(rootNode)) {
            return "2";
        }
        return "1";
    }

    @Override
    protected String getRootNode(String rootNode) {
        return "/" + rootNode;
    }

    @Override
    protected String sortBy(String fieldName) {
        return sortByMapping.getProperty(fieldName, fieldName);
    }

    protected boolean hasType(Node node) {
        String value;
        return node instanceof Element && (value = ((Element)node).getAttribute("xsi:type")) != null && value.equals("jaxbList");
    }
}

