/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.json.JSONObject;
import org.kie.server.router.Configuration;
import org.kie.server.router.ContainerInfo;
import org.kie.server.router.handlers.KieServerInfoHandler;
import org.kie.server.router.proxy.aggragate.JSONResponseAggregator;
import org.kie.server.router.proxy.aggragate.JaxbXMLResponseAggregator;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;
import org.kie.server.router.proxy.aggragate.XstreamXMLResponseAggregator;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.FailedHostInfo;
import org.kie.server.router.utils.HttpUtils;

public class AdminHttpHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(AdminHttpHandler.class);
    private String CONTROLLER = System.getProperty("org.kie.server.controller");
    private int interval = Integer.parseInt(System.getProperty("org.kie.server.controller.retry.interval", "5"));
    private int attemptsLimit = Integer.parseInt(System.getProperty("org.kie.server.recovery.retry.limit", "100"));
    private Configuration configuration = new Configuration();
    private List<ResponseAggregator> aggregators = new ArrayList<ResponseAggregator>();
    private ConfigRepository repository = null;
    private ConfigurationMarshaller marshaller = new ConfigurationMarshaller();
    private Set<String> controllerContainers = new HashSet<String>();
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> failedHostsReconnects;
    private ScheduledFuture<?> addToControllerAttempts;
    private ScheduledFuture<?> removeFromControllerAttempts;
    private CopyOnWriteArrayList<FailedHostInfo> failedHosts = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ContainerInfo> containersToAddToController = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<String> containersToRemoveFromController = new CopyOnWriteArrayList();
    private static final String CONTAINER_SPEC_JSON = "{\n    \"container-id\" : \"#1@\",\n    \"container-name\" : \"#2@\",\n    \"server-template-key\" : {\n      \"server-id\" : \"kie-server-router\",\n      \"server-name\" : \"KIE Server Router\"\n    },\n    \"release-id\" : {\n      \"group-id\" : \"#3@\",\n      \"artifact-id\" : \"#4@\",\n      \"version\" : \"#5@\"\n    },\n    \"configuration\" : { },\n    \"status\" : \"STARTED\"\n  }";

    public AdminHttpHandler(Configuration configuration, ConfigRepository repository, ScheduledExecutorService executorService) {
        this.configuration = configuration;
        this.repository = repository;
        this.executorService = executorService;
        this.aggregators.add(new JSONResponseAggregator());
        this.aggregators.add(new XstreamXMLResponseAggregator());
        this.aggregators.add(new JaxbXMLResponseAggregator());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        if (path.startsWith("/list")) {
            String jsonConfig = this.marshaller.marshall(this.configuration);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, jsonConfig.getBytes("UTF-8").length);
            exchange.getResponseSender().send(jsonConfig);
            return;
        }
        exchange.getRequestReceiver().receiveFullString((ex, data) -> {
            block10: {
                try {
                    JSONObject jsonData = new JSONObject(data);
                    String containerId = jsonData.getString("containerId");
                    String alias = jsonData.getString("alias");
                    String serverId = jsonData.getString("serverId");
                    String serverUrl = jsonData.getString("serverUrl");
                    String releaseId = jsonData.getString("releaseId");
                    ContainerInfo containerInfo = new ContainerInfo(containerId, alias, releaseId);
                    if (path.startsWith("/add")) {
                        log.infof("Added %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                        Configuration configuration = this.configuration;
                        synchronized (configuration) {
                            this.configuration.addContainerHost(containerId, serverUrl);
                            this.configuration.addContainerHost(alias, serverUrl);
                            this.configuration.addServerHost(serverId, serverUrl);
                            this.configuration.addContainerInfo(containerInfo);
                            this.repository.persist(this.configuration);
                        }
                        this.updateControllerOnAdd(containerId, releaseId, alias, containerInfo);
                        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                        break block10;
                    }
                    if (path.startsWith("/remove")) {
                        log.infof("Removed %s as server location for container %s ", (Object)serverUrl, (Object)containerId);
                        Configuration configuration = this.configuration;
                        synchronized (configuration) {
                            this.configuration.removeContainerHost(containerId, serverUrl);
                            this.configuration.removeContainerHost(alias, serverUrl);
                            this.configuration.removeServerHost(serverId, serverUrl);
                            this.configuration.removeContainerInfo(containerInfo);
                            this.repository.persist(this.configuration);
                        }
                        this.updateControllerOnRemove(containerId);
                        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
                        break block10;
                    }
                    exchange.getResponseHeaders().put(Headers.STATUS, "");
                    ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
                }
                catch (Exception e) {
                    log.error((Object)"Error while performing admin operation", e);
                }
            }
        });
    }

    public Map<String, List<String>> getHostsPerServer() {
        return this.configuration.getHostsPerServer();
    }

    public List<ResponseAggregator> getAggregators() {
        return Collections.unmodifiableList(this.aggregators);
    }

    public void addControllerContainers(List<String> containers) {
        this.controllerContainers.addAll(containers);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnavailableServer(String url) {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            FailedHostInfo failedHost = this.configuration.removeUnavailableServer(url);
            this.repository.persist(this.configuration);
            this.failedHosts.add(failedHost);
            log.debug("Scheduling host checks...");
            this.failedHostsReconnects = this.executorService.scheduleAtFixedRate(() -> {
                if (this.failedHosts.isEmpty()) {
                    return;
                }
                Iterator<FailedHostInfo> it = this.failedHosts.iterator();
                while (it.hasNext()) {
                    FailedHostInfo fHost = it.next();
                    if (this.attemptsLimit == fHost.getAttempts()) {
                        it.remove();
                        log.info("Host " + fHost.getServerUrl() + " has reached reconnect attempts limit " + this.attemptsLimit + " quiting");
                        continue;
                    }
                    try {
                        HttpUtils.getHttpCall(fHost.getServerUrl());
                        log.info("Server at " + fHost.getServerUrl() + " is back online");
                        this.failedHostsReconnects.cancel(false);
                        Configuration configuration = this.configuration;
                        synchronized (configuration) {
                            for (String containerId : fHost.getContainers()) {
                                this.configuration.addContainerHost(containerId, fHost.getServerUrl());
                            }
                            this.configuration.addServerHost(fHost.getServerId(), fHost.getServerUrl());
                            this.repository.persist(this.configuration);
                        }
                    }
                    catch (Exception e) {
                        log.debug("Host " + fHost.getServerUrl() + " is still not available, attempting to reconnect in " + this.interval + " seconds, error " + e.getMessage());
                    }
                    finally {
                        fHost.attempted();
                    }
                }
            }, this.interval, this.interval, TimeUnit.SECONDS);
        }
    }

    protected void pushToController(String releaseId, String containerId, String alias) throws Exception {
        String[] gav = releaseId.split(":");
        String jsonPayload = CONTAINER_SPEC_JSON.replaceFirst("#1@", containerId).replaceFirst("#2@", alias).replaceFirst("#3@", gav[0]).replaceFirst("#4@", gav[1]).replaceFirst("#5@", gav[2]);
        HttpUtils.putHttpCall(this.CONTROLLER + "/management/servers/" + KieServerInfoHandler.getRouterId() + "/containers/" + containerId, jsonPayload);
        log.infof("Added %s container into controller at %s ", (Object)containerId, (Object)this.CONTROLLER);
    }

    protected void dropFromController(String containerId) throws Exception {
        HttpUtils.deleteHttpCall(this.CONTROLLER + "/management/servers/" + KieServerInfoHandler.getRouterId() + "/containers/" + containerId);
        log.infof("Removed %s container from controller at %s ", (Object)containerId, (Object)this.CONTROLLER);
    }

    protected void updateControllerOnRemove(String containerId) {
        List hostsPerContainer;
        if (this.CONTROLLER != null && this.controllerContainers.contains(containerId) && (hostsPerContainer = this.configuration.getHostsPerContainer().getOrDefault(containerId, Collections.emptyList())).isEmpty()) {
            this.controllerContainers.remove(containerId);
            this.containersToRemoveFromController.add(containerId);
            if (this.removeFromControllerAttempts == null) {
                this.removeFromControllerAttempts = this.executorService.scheduleAtFixedRate(() -> {
                    try {
                        ArrayList<String> sent = new ArrayList<String>();
                        for (String container : this.containersToRemoveFromController) {
                            if (this.controllerContainers.contains(container)) {
                                sent.add(container);
                                continue;
                            }
                            this.dropFromController(container);
                            sent.add(container);
                        }
                        this.containersToRemoveFromController.removeAll(sent);
                        if (this.containersToRemoveFromController.isEmpty()) {
                            this.removeFromControllerAttempts.cancel(false);
                            this.removeFromControllerAttempts = null;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception when notifying controller about deleted containers " + e.getMessage() + " next attempt in " + this.interval + " seconds");
                        log.debug(e);
                    }
                }, this.interval, this.interval, TimeUnit.SECONDS);
            }
        }
    }

    protected void updateControllerOnAdd(String containerId, String releaseId, String alias, ContainerInfo containerInfo) {
        if (this.CONTROLLER != null && releaseId != null && !this.controllerContainers.contains(containerId)) {
            this.controllerContainers.add(containerId);
            this.containersToAddToController.add(containerInfo);
            if (this.addToControllerAttempts == null) {
                this.addToControllerAttempts = this.executorService.scheduleAtFixedRate(() -> {
                    try {
                        ArrayList<ContainerInfo> sent = new ArrayList<ContainerInfo>();
                        for (ContainerInfo container : this.containersToAddToController) {
                            if (!this.controllerContainers.contains(container.getContainerId())) {
                                sent.add(container);
                                continue;
                            }
                            this.pushToController(container.getReleaseId(), container.getContainerId(), container.getAlias());
                            sent.add(container);
                        }
                        this.containersToAddToController.removeAll(sent);
                        if (this.containersToAddToController.isEmpty()) {
                            this.addToControllerAttempts.cancel(false);
                            this.addToControllerAttempts = null;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception when notifying controller about deleted containers " + e.getMessage() + " next attempt in " + this.interval + " seconds");
                        log.debug((Object)"Stacktrace", e);
                    }
                }, this.interval, this.interval, TimeUnit.SECONDS);
            }
        }
    }
}

