/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import org.jboss.logging.Logger;
import org.kie.server.router.Configuration;
import org.kie.server.router.KieServerRouterEnvironment;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.spi.ConfigRepository;

public class FileRepository
implements ConfigRepository {
    private static final Logger log = Logger.getLogger(FileRepository.class);
    private final File repositoryDir;
    private ConfigurationMarshaller marshaller = new ConfigurationMarshaller();

    public FileRepository(KieServerRouterEnvironment env) {
        this.repositoryDir = new File(env.getRepositoryDir());
    }

    @Override
    public void persist(Configuration configuration) {
        File configFile = new File(this.repositoryDir, "kie-server-router.json");
        try (FileOutputStream fos = new FileOutputStream(configFile);){
            String config = this.marshaller.marshall(configuration);
            try (PrintWriter writer = new PrintWriter(fos);){
                writer.write(config);
            }
            configFile.setLastModified(System.currentTimeMillis());
        }
        catch (Exception ex) {
            log.error("Could not persist configuration {0}", configFile, (Throwable)ex);
        }
    }

    @Override
    public Configuration load() {
        Configuration configuration = new Configuration();
        File serverStateFile = new File(this.repositoryDir, "kie-server-router.json");
        if (serverStateFile.exists()) {
            try (FileReader reader = new FileReader(serverStateFile);){
                configuration = this.marshaller.unmarshall(reader);
            }
            catch (Exception e) {
                log.error("configuration file could not be read {0}", serverStateFile, (Throwable)e);
            }
        }
        return configuration;
    }

    @Override
    public void clean() {
        this.persist(new Configuration());
    }
}

