/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.Configuration;
import org.kie.server.router.ContainerInfo;

public class ConfigurationTest {
    @Test
    public void testRemoveServerWhenUnavailable() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server2")).size());
        config.removeUnavailableServer("http://localhost:8180/server");
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)0L, (long)((List)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)0L, (long)((List)config.getHostsPerServer().get("server2")).size());
    }

    @Test
    public void testRemoveServerWhenUnavailableRequestURL() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server2")).size());
        config.removeUnavailableServer("http://localhost:8180/server/containers/instances/1");
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)0L, (long)((List)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)0L, (long)((List)config.getHostsPerServer().get("server2")).size());
    }

    @Test
    public void testMultipleServersWithSameUrl() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container", "http://localhost:8080/server");
        config.addContainerHost("container", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        ContainerInfo containerInfo2 = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo2);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)2L, (long)((List)config.getHostsPerServer().get("server1")).size());
        config.removeContainerHost("container1", "http://localhost:8080/server");
        config.removeContainerHost("container", "http://localhost:8080/server");
        config.removeServerHost("server1", "http://localhost:8080/server");
        config.removeContainerInfo(containerInfo);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
    }

    @Test
    public void testReloadFromConfigurationAddedServersAndContainers() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)1L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Configuration updated = new Configuration();
        updated.addContainerHost("container1", "http://localhost:8080/server");
        updated.addServerHost("server1", "http://localhost:8080/server");
        updated.addContainerHost("container2", "http://localhost:8081/server");
        updated.addServerHost("server2", "http://localhost:8081/server");
        ContainerInfo updatedContainerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        updated.addContainerInfo(updatedContainerInfo);
        config.syncFromRepository(updated);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server2")).size());
    }

    @Test
    public void testReloadFromConfigurationReplacedServersAndContainers() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)1L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Configuration updated = new Configuration();
        updated.addContainerHost("container2", "http://localhost:8081/server");
        updated.addServerHost("server2", "http://localhost:8081/server");
        ContainerInfo updatedContainerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        updated.addContainerInfo(updatedContainerInfo);
        config.syncFromRepository(updated);
        Assert.assertEquals((long)1L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertNull(config.getHostsPerContainer().get("container1"));
        Assert.assertNull(config.getHostsPerServer().get("server1"));
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server2")).size());
    }

    @Test
    public void testReloadFromConfigurationUpdatedUrls() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)1L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)config.getHostsPerContainer().get("container1")).get(0));
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)config.getHostsPerServer().get("server1")).get(0));
        Configuration updated = new Configuration();
        updated.addContainerHost("container1", "http://localhost:8081/server");
        updated.addServerHost("server1", "http://localhost:8081/server");
        ContainerInfo updatedContainerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        updated.addContainerInfo(updatedContainerInfo);
        config.syncFromRepository(updated);
        Assert.assertEquals((long)1L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((Object)"http://localhost:8081/server", ((List)config.getHostsPerContainer().get("container1")).get(0));
        Assert.assertEquals((Object)"http://localhost:8081/server", ((List)config.getHostsPerServer().get("server1")).get(0));
    }

    @Test
    public void testReloadFromConfigurationUpdatedAndAddedUrls() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)1L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)config.getHostsPerContainer().get("container1")).get(0));
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)config.getHostsPerServer().get("server1")).get(0));
        Configuration updated = new Configuration();
        updated.addContainerHost("container1", "http://localhost:8081/server");
        updated.addServerHost("server1", "http://localhost:8081/server");
        updated.addContainerHost("container1", "http://localhost:8080/server");
        updated.addServerHost("server1", "http://localhost:8080/server");
        ContainerInfo updatedContainerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        updated.addContainerInfo(updatedContainerInfo);
        config.syncFromRepository(updated);
        Assert.assertEquals((long)1L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)1L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)2L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)config.getHostsPerContainer().get("container1")).get(0));
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)config.getHostsPerServer().get("server1")).get(0));
        Assert.assertEquals((Object)"http://localhost:8081/server", ((List)config.getHostsPerContainer().get("container1")).get(1));
        Assert.assertEquals((Object)"http://localhost:8081/server", ((List)config.getHostsPerServer().get("server1")).get(1));
    }

    @Test
    public void testRemoveNotExistingContainerInfo() {
        Configuration config = new Configuration();
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)2L, (long)config.getContainerInfosPerContainer().size());
        ContainerInfo notExistingContainerInfo = new ContainerInfo("not-existing-test1.0", "not-existing-test", "org.kie:test:1.0");
        config.removeContainerInfo(notExistingContainerInfo);
        Assert.assertEquals((long)2L, (long)config.getContainerInfosPerContainer().size());
    }

    @Test
    public void testReloadFromRepository() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((List)config.getHostsPerServer().get("server2")).size());
        config.syncFromRepository(new Configuration());
        Assert.assertEquals((long)0L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)0L, (long)config.getHostsPerServer().size());
    }

    @Test
    public void testReloadFromMultipleServersWithSameUrl() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container", "http://localhost:8080/server");
        config.addContainerHost("container", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        ContainerInfo containerInfo2 = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo2);
        Configuration updated = new Configuration();
        updated.addContainerHost("container1", "http://localhost:8080/server");
        updated.addServerHost("server1", "http://localhost:8080/server");
        containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        updated.addContainerInfo(containerInfo);
        config.syncFromRepository(updated);
        Assertions.assertThat((Map)config.getHostsPerContainer()).hasSize(1);
        Assertions.assertThat((Map)config.getHostsPerServer()).hasSize(1);
        Assertions.assertThat((List)((List)config.getHostsPerContainer().get("container1"))).hasSize(1);
        Assertions.assertThat((List)((List)config.getHostsPerServer().get("server1"))).hasSize(1);
    }

    @Test
    public void testAliasEqualsContainerId() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)1L, (long)((List)config.getContainerInfosPerContainer().get("test")).size());
    }
}

