/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.router.KieServerRouterEnvironment;

public class KieServerRouterEnvironmentFromPropsTest {
    private static final String PROPERTIES_PATH = KieServerRouterEnvironment.class.getClassLoader().getResource("properties/custom.properties").getFile();

    @Before
    public void setUp() {
        System.setProperty("org.kie.server.router.config.file", PROPERTIES_PATH);
        System.setProperty("org.kie.server.router.url.external", "https://my-domain:8900/");
    }

    @After
    public void tearDown() {
        System.clearProperty("org.kie.server.router.url.external");
        System.clearProperty("org.kie.server.router.config.file");
    }

    @Test
    public void testRouterEnvironmentFromProperties() {
        KieServerRouterEnvironment env = new KieServerRouterEnvironment();
        Assert.assertEquals((Object)"my-id", (Object)env.getRouterId());
        Assert.assertEquals((Object)"my-name", (Object)env.getRouterName());
        Assert.assertEquals((Object)"my-host", (Object)env.getRouterHost());
        Assert.assertEquals((long)9019L, (long)env.getPort());
        Assert.assertEquals((long)19019L, (long)env.getSslPort());
        Assert.assertEquals((Object)"https://my-external-host:9111", (Object)env.getRouterExternalUrl());
        Assert.assertEquals((Object)"my-keystore-path", (Object)env.getKeystorePath());
        Assert.assertEquals((Object)"my-password", (Object)env.getKeystorePassword());
        Assert.assertEquals((Object)"my-keyalias", (Object)env.getKeystoreKey());
        Assert.assertTrue((boolean)env.isTlsEnabled());
        Assert.assertEquals((Object)"my-repo", (Object)env.getRepositoryDir());
        Assert.assertEquals((Object)"my-idp", (Object)env.getIdentityProvider());
        Assert.assertEquals((Object)"my-controller-url", (Object)env.getKieControllerUrl());
        Assert.assertEquals((Object)"my-controller-user", (Object)env.getKieControllerUser());
        Assert.assertEquals((Object)"my-controller-pwd", (Object)env.getKieControllerPwd());
        Assert.assertEquals((Object)"my-controller-token", (Object)env.getKieControllerToken());
        Assert.assertTrue((boolean)env.isConfigFileWatcherEnabled());
        Assert.assertEquals((long)9000L, (long)env.getConfigFileWatcherInterval());
        Assert.assertEquals((long)9900L, (long)env.getKieControllerAttemptInterval());
        Assert.assertEquals((long)9L, (long)env.getKieControllerRecoveryAttemptLimit());
        Assert.assertTrue((boolean)env.isManagementSecured());
    }
}

