/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy;

import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.jboss.logging.Logger;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.ConfigurationManager;
import org.kie.server.router.proxy.CaptureHostLoadBalancingProxyClient;
import org.kie.server.router.proxy.DefaultContainerResolver;
import org.kie.server.router.proxy.DefaultRestrictionPolicy;
import org.kie.server.router.spi.ContainerResolver;
import org.kie.server.router.spi.RestrictionPolicy;
import org.kie.server.router.utils.SSLContextBuilder;

public class KieServerProxyClient
implements ProxyClient,
ConfigurationListener {
    private static final Logger log = Logger.getLogger(KieServerProxyClient.class);
    private ServiceLoader<ContainerResolver> containerResolverServiceLoader = ServiceLoader.load(ContainerResolver.class);
    private ServiceLoader<RestrictionPolicy> restrictionPolicyServiceLoader = ServiceLoader.load(RestrictionPolicy.class);
    private ContainerResolver containerResolver = new DefaultContainerResolver();
    private RestrictionPolicy restrictionPolicy = new DefaultRestrictionPolicy();
    private Map<String, CaptureHostLoadBalancingProxyClient> containerClients = new ConcurrentHashMap<String, CaptureHostLoadBalancingProxyClient>();
    private ConfigurationManager configurationManager;
    private String userProvidedTruststore = System.getProperty("javax.net.ssl.trustStore", "");
    private String userProvidedTruststorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");

    public KieServerProxyClient(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.configurationManager.getConfiguration().addListener(this);
        ArrayList foundResolvers = new ArrayList();
        this.containerResolverServiceLoader.forEach(cr -> foundResolvers.add(cr));
        ArrayList foundPolicies = new ArrayList();
        this.restrictionPolicyServiceLoader.forEach(p -> foundPolicies.add(p));
        if (foundPolicies.size() > 1 || foundResolvers.size() > 1) {
            throw new IllegalStateException("Found more than one RestrictionPolicy " + foundPolicies + " or ContainerResolver " + foundResolvers);
        }
        if (!foundResolvers.isEmpty()) {
            this.containerResolver = (ContainerResolver)foundResolvers.get(0);
        }
        if (!foundPolicies.isEmpty()) {
            this.restrictionPolicy = (RestrictionPolicy)foundPolicies.get(0);
        }
        log.infof("Using '%s' container resolver and restriction policy '%s'", (Object)this.containerResolver, (Object)this.restrictionPolicy);
    }

    public synchronized void addContainer(String containerId, URI serverURI) {
        CaptureHostLoadBalancingProxyClient client = this.containerClients.get(containerId);
        if (client == null) {
            client = new CaptureHostLoadBalancingProxyClient();
            this.containerClients.put(containerId, client);
        }
        if (!this.userProvidedTruststore.isEmpty() && !this.userProvidedTruststorePassword.isEmpty()) {
            try {
                SSLContext context = SSLContextBuilder.builder().setKeyStorePath(this.userProvidedTruststore).setKeyStorePassword(this.userProvidedTruststorePassword).buildTrustore();
                UndertowXnioSsl ssl = new UndertowXnioSsl(null, null, context);
                client.addHost(serverURI, ssl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            client.addHost(serverURI);
        }
    }

    public synchronized void removeContainer(String containerId, URI serverURI) {
        LoadBalancingProxyClient client = this.containerClients.get(containerId);
        if (client == null) {
            log.debugf("No backend server found for %s and server URI %s", (Object)containerId, (Object)serverURI);
            return;
        }
        client.removeHost(serverURI);
    }

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        String containerId = this.containerResolver.resolveContainerId(exchange, this.configurationManager.getConfiguration().getContainerInfosPerContainer());
        if (this.restrictionPolicy.restrictedEndpoint(exchange, containerId)) {
            log.debugf("URL %s is restricted according to policy %s", (Object)exchange.getRelativePath(), (Object)this.restrictionPolicy.toString());
            return null;
        }
        LoadBalancingProxyClient client = this.containerClients.get(containerId);
        if (client == null) {
            return null;
        }
        return client.findTarget(exchange);
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, final HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        String containerId = this.containerResolver.resolveContainerId(exchange, this.configurationManager.getConfiguration().getContainerInfosPerContainer());
        final CaptureHostLoadBalancingProxyClient client = this.containerClients.get(containerId);
        try {
            client.getConnection(target, exchange, new ProxyCallback<ProxyConnection>(){

                @Override
                public void completed(HttpServerExchange exchange2, ProxyConnection result) {
                    callback.completed(exchange2, result);
                }

                @Override
                public void failed(HttpServerExchange httpServerExchange) {
                    try {
                        KieServerProxyClient.this.configurationManager.disconnectFailedHost(client.getUri());
                    }
                    finally {
                        callback.failed(exchange);
                        client.clear();
                    }
                }

                @Override
                public void couldNotResolveBackend(HttpServerExchange exchange2) {
                    callback.couldNotResolveBackend(exchange2);
                }

                @Override
                public void queuedRequestFailed(HttpServerExchange exchange2) {
                    callback.queuedRequestFailed(exchange2);
                }
            }, timeout, timeUnit);
        }
        catch (Exception e) {
            if (e instanceof SocketException || e instanceof UnknownHostException || e instanceof UnresolvedAddressException || e instanceof IllegalArgumentException) {
                this.configurationManager.disconnectFailedHost(client.getUri());
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onContainerAdded(String container, String serverUrl) {
        this.addContainer(container, URI.create(serverUrl));
    }

    @Override
    public void onContainerRemoved(String container, String serverUrl) {
        this.removeContainer(container, URI.create(serverUrl));
    }
}

