/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import io.undertow.util.FileUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.router.Configuration;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.ConfigurationManager;
import org.kie.server.router.ContainerInfo;
import org.kie.server.router.KieServerRouterEnvironment;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.repository.FileRepository;
import org.kie.server.router.spi.ConfigRepository;

public class FileRepositoryTest {
    @Before
    public void init() {
        System.setProperty("org.kie.server.router.repo", "target");
    }

    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.router.config.watcher.enabled");
        System.clearProperty("org.kie.server.router.config.watcher.interval");
        System.clearProperty("org.kie.server.router.repo");
    }

    @Test
    public void testStoreAndLoad() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        FileRepository repo = new FileRepository(new KieServerRouterEnvironment());
        repo.persist(config);
        Configuration loaded = repo.load();
        Assert.assertNotNull((Object)loaded);
        Assert.assertNotNull((Object)loaded.getHostsPerContainer());
        Assert.assertNotNull((Object)loaded.getHostsPerServer());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)loaded.getHostsPerContainer().get("container1")).iterator().next());
        Assert.assertEquals((Object)"http://localhost:8180/server", ((List)loaded.getHostsPerContainer().get("container2")).iterator().next());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerServer().get("server2")).size());
        Assert.assertEquals((Object)"http://localhost:8080/server", ((List)loaded.getHostsPerServer().get("server1")).iterator().next());
        Assert.assertEquals((Object)"http://localhost:8180/server", ((List)loaded.getHostsPerServer().get("server2")).iterator().next());
        Assert.assertEquals((long)1L, (long)((List)loaded.getContainerInfosPerContainer().get("test")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getContainerInfosPerContainer().get("test1.0")).size());
        ContainerInfo loadedCI = (ContainerInfo)((List)loaded.getContainerInfosPerContainer().get("test")).iterator().next();
        Assert.assertEquals((Object)containerInfo, (Object)loadedCI);
        loadedCI = (ContainerInfo)((List)loaded.getContainerInfosPerContainer().get("test1.0")).iterator().next();
        Assert.assertEquals((Object)containerInfo, (Object)loadedCI);
        repo.clean();
    }

    @Test
    public void testWatchServiceOnConfigFile() throws Exception {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(8);
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        File repositoryDirectory = new File("target" + File.separator + UUID.randomUUID().toString());
        repositoryDirectory.mkdirs();
        System.setProperty("org.kie.server.router.config.watcher.enabled", "true");
        System.setProperty("org.kie.server.router.config.watcher.interval", "1000");
        KieServerRouterEnvironment kieServerRouterEnvironment = new KieServerRouterEnvironment();
        FileRepository repo = new FileRepository(kieServerRouterEnvironment);
        repo.persist(config);
        ConfigurationManager manager = new ConfigurationManager(kieServerRouterEnvironment, (ConfigRepository)repo, executorService);
        Configuration loaded = manager.getConfiguration();
        final CountDownLatch latch = new CountDownLatch(1);
        loaded.addListener(new ConfigurationListener(){

            public void onConfigurationReloaded() {
                latch.countDown();
            }
        });
        manager.startWatcher();
        Assert.assertNotNull((Object)loaded);
        Assert.assertNotNull((Object)loaded.getHostsPerContainer());
        Assert.assertNotNull((Object)loaded.getHostsPerServer());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        config.removeContainerHost("container2", "http://localhost:8180/server");
        config.removeServerHost("server2", "http://localhost:8180/server");
        Thread.sleep(3000L);
        repo.persist(config);
        boolean reloaded = latch.await(20L, TimeUnit.SECONDS);
        if (reloaded) {
            Assert.assertNotNull((Object)loaded);
            Assert.assertNotNull((Object)loaded.getHostsPerContainer());
            Assert.assertNotNull((Object)loaded.getHostsPerServer());
            Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
            Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
            Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
            Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
            Assert.assertEquals((long)0L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        }
        manager.close();
        executorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchServiceOnLatelyCreatedConfigFile() throws Exception {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(8);
        String fileDir = "target" + File.separator + UUID.randomUUID().toString();
        System.setProperty("org.kie.server.router.repo", fileDir);
        File repositoryDirectory = new File(fileDir);
        repositoryDirectory.mkdirs();
        System.setProperty("org.kie.server.router.config.watcher.enabled", "true");
        System.setProperty("org.kie.server.router.config.watcher.interval", "1000");
        KieServerRouterEnvironment environment = new KieServerRouterEnvironment();
        FileRepository repoWithWatcher = new FileRepository(environment);
        ConfigurationManager configurationManager = new ConfigurationManager(environment, (ConfigRepository)repoWithWatcher, executorService);
        Configuration loaded = configurationManager.getConfiguration();
        final CountDownLatch latch = new CountDownLatch(1);
        loaded.addListener(new ConfigurationListener(){

            public void onConfigurationReloaded() {
                latch.countDown();
            }
        });
        configurationManager.startWatcher();
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        ConfigurationManager configurationManager2 = configurationManager;
        synchronized (configurationManager2) {
            repoWithWatcher.persist(config);
        }
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)loaded);
        Assert.assertNotNull((Object)loaded.getHostsPerContainer());
        Assert.assertNotNull((Object)loaded.getHostsPerServer());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)loaded.getHostsPerServer().size());
        Assert.assertEquals((long)2L, (long)loaded.getContainerInfosPerContainer().size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container2")).size());
        configurationManager.close();
        executorService.shutdownNow();
        repoWithWatcher.close();
        repoWithWatcher.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreation() throws Exception {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(8);
        ConfigurationMarshaller marshaller = new ConfigurationMarshaller();
        Configuration configuration = new Configuration();
        String fileDir = "target" + File.separator + UUID.randomUUID().toString();
        System.setProperty("org.kie.server.router.repo", fileDir);
        File repositoryDirectory = new File(fileDir);
        repositoryDirectory.mkdirs();
        System.setProperty("org.kie.server.router.config.watcher.enabled", "true");
        System.setProperty("org.kie.server.router.config.watcher.interval", "1000");
        KieServerRouterEnvironment environment = new KieServerRouterEnvironment();
        FileRepository repoWithWatcher = new FileRepository(environment);
        ConfigurationManager configurationManager = new ConfigurationManager(environment, (ConfigRepository)repoWithWatcher, executorService);
        Configuration loaded = configurationManager.getConfiguration();
        final CountDownLatch latch = new CountDownLatch(1);
        loaded.addListener(new ConfigurationListener(){

            public void onConfigurationReloaded() {
                latch.countDown();
            }
        });
        configurationManager.startWatcher();
        latch.await(20L, TimeUnit.SECONDS);
        configurationManager.stopWatcher();
        Assert.assertEquals((Object)loaded.toString().trim(), (Object)configuration.toString().trim());
        System.setProperty("org.kie.server.router.config.watcher.enabled", "false");
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        ConfigurationManager configurationManager2 = configurationManager;
        synchronized (configurationManager2) {
            repoWithWatcher.persist(config);
        }
        File serverStateFile = new File(repositoryDirectory, "kie-server-router.json");
        Assert.assertTrue((boolean)serverStateFile.exists());
        if (serverStateFile.exists()) {
            try (FileReader reader = new FileReader(serverStateFile);){
                configuration = marshaller.unmarshall((Reader)reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((Object)config.toString().trim(), (Object)configuration.toString().trim());
        configurationManager.close();
        executorService.shutdownNow();
        repoWithWatcher.close();
        repoWithWatcher.clean();
    }

    @Test
    public void testConfigurationFileStartStop() throws Exception {
        String fileDir = "target" + File.separator + UUID.randomUUID().toString();
        File repositoryDirectory = new File(fileDir);
        repositoryDirectory.mkdirs();
        System.setProperty("org.kie.server.router.repo", fileDir);
        System.setProperty("org.kie.server.router.config.watcher.enabled", "true");
        System.setProperty("org.kie.server.router.config.watcher.interval", "1000");
        KieServerRouterEnvironment env = new KieServerRouterEnvironment();
        FileRepository repoWithWatcher = new FileRepository(env);
        Configuration loaded = repoWithWatcher.load();
        String containerId = "container1";
        String serverId = "server1";
        String releaseId = "1.0";
        String serverUrl = "http://localhost:8080/server";
        ContainerInfo containerInfo = new ContainerInfo(containerId, containerId, releaseId);
        loaded.addContainerHost(containerId, serverUrl);
        loaded.addServerHost(serverId, serverUrl);
        loaded.addContainerInfo(containerInfo);
        containerId = "container2";
        containerInfo = new ContainerInfo(containerId, containerId, releaseId);
        loaded.addContainerHost(containerId, serverUrl);
        loaded.addServerHost(serverId, serverUrl);
        loaded.addContainerInfo(containerInfo);
        containerId = "container1";
        serverId = "server2";
        serverUrl = "http://localhost:8083/server";
        containerInfo = new ContainerInfo(containerId, containerId, releaseId);
        loaded.addContainerHost(containerId, serverUrl);
        loaded.addServerHost(serverId, serverUrl);
        loaded.addContainerInfo(containerInfo);
        containerId = "container2";
        containerInfo = new ContainerInfo(containerId, containerId, releaseId);
        loaded.addContainerHost(containerId, serverUrl);
        loaded.addServerHost(serverId, serverUrl);
        loaded.addContainerInfo(containerInfo);
        repoWithWatcher.persist(loaded);
        loaded.removeContainerHost(containerId, serverUrl);
        loaded.removeServerHost(serverId, serverUrl);
        loaded.removeContainerInfo(containerInfo);
        containerId = "container1";
        loaded.removeContainerHost(containerId, serverUrl);
        loaded.removeServerHost(serverId, serverUrl);
        loaded.removeContainerInfo(containerInfo);
        repoWithWatcher.persist(loaded);
        Assert.assertEquals((long)1L, (long)((List)loaded.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)0L, (long)((List)loaded.getHostsPerServer().get("server2")).size());
        repoWithWatcher.close();
        repoWithWatcher.clean();
        FileUtils.deleteRecursive((Path)repositoryDirectory.toPath());
    }
}

