/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.sse;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathTemplateHandler;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.server.handlers.sse.ServerSentEventHandler;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.sse.ServerSentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={ServerSentEvent.class})
public class ServerSentEventSCI
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (c == null || c.isEmpty()) {
            return;
        }
        try {
            final HashMap<String, ServerSentEventConnectionCallback> callbacks = new HashMap<String, ServerSentEventConnectionCallback>();
            ServletContextImpl servletContext = (ServletContextImpl)ctx;
            final ArrayList handles = new ArrayList();
            for (Class<?> clazz : c) {
                ServerSentEvent annotation = clazz.getAnnotation(ServerSentEvent.class);
                if (annotation == null) continue;
                String path = annotation.value();
                InstanceHandle<?> instance = servletContext.getDeployment().getDeploymentInfo().getClassIntrospecter().createInstanceFactory(clazz).createInstance();
                handles.add(instance);
                callbacks.put(path, (ServerSentEventConnectionCallback)instance.getInstance());
            }
            if (callbacks.isEmpty()) {
                return;
            }
            servletContext.getDeployment().getDeploymentInfo().addInnerHandlerChainWrapper(new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    PathTemplateHandler pathTemplateHandler = new PathTemplateHandler(handler, false);
                    for (Map.Entry e : callbacks.entrySet()) {
                        pathTemplateHandler.add((String)e.getKey(), new ServerSentEventHandler((ServerSentEventConnectionCallback)e.getValue()));
                    }
                    return pathTemplateHandler;
                }
            });
            servletContext.addListener(new ServletContextListener(){

                public void contextInitialized(ServletContextEvent sce) {
                }

                public void contextDestroyed(ServletContextEvent sce) {
                    for (InstanceHandle h : handles) {
                        h.release();
                    }
                }
            });
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

