/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.dmn;

import java.util.List;
import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNResultKS;
import org.kie.server.api.model.type.JaxbList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelEvaluatorServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(ModelEvaluatorServiceBase.class);
    private KieServerRegistry context;
    private MarshallerHelper marshallerHelper;

    public ModelEvaluatorServiceBase(KieServerRegistry context) {
        this.context = context;
        this.marshallerHelper = new MarshallerHelper(context);
    }

    public ServiceResponse<JaxbList> getModels(String containerId) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId);
            KieSession kieSession = kContainer.getKieContainer().newKieSession();
            DMNRuntime kieRuntime = (DMNRuntime)kieSession.getKieRuntime(DMNRuntime.class);
            List result = kieRuntime.getModels();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "OK models successfully retrieved from container '" + containerId + "'", (Object)new JaxbList(result));
        }
        catch (Exception e) {
            LOG.error("Error retrieving models from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving models from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public ServiceResponse<DMNResultKS> evaluateAllDecisions(String containerId, String contextPayload, String marshallingType) {
        try {
            DMNModel model;
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId);
            KieSession kieSession = kContainer.getKieContainer().newKieSession();
            DMNRuntime dmnRuntime = (DMNRuntime)kieSession.getKieRuntime(DMNRuntime.class);
            LOG.debug("Will deserialize payload: {}", (Object)contextPayload);
            DMNContextKS evalCtx = (DMNContextKS)this.marshallerHelper.unmarshal(containerId, contextPayload, marshallingType, DMNContextKS.class);
            if (evalCtx.getModelName() == null) {
                if (dmnRuntime.getModels().size() > 1) {
                    throw new RuntimeException("more than one (default) model");
                }
                model = (DMNModel)dmnRuntime.getModels().get(0);
            } else {
                model = dmnRuntime.getModel(evalCtx.getNamespace(), evalCtx.getModelName());
            }
            if (model == null) {
                throw new RuntimeException("Unable to locate DMN Model to evaluate");
            }
            LOG.debug("Will use model: {}", (Object)model);
            DMNContext dmnContext = DMNFactory.newContext();
            for (Map.Entry e : evalCtx.getDmnContext().entrySet()) {
                dmnContext.set((String)e.getKey(), e.getValue());
            }
            LOG.debug("Will use dmnContext: {}", (Object)dmnContext);
            DMNResult result = dmnRuntime.evaluateAll(model, dmnContext);
            LOG.debug("Result:");
            LOG.debug("{}", (Object)result);
            LOG.debug("{}", (Object)result.getContext());
            LOG.debug("{}", (Object)result.getDecisionResults());
            LOG.debug("{}", (Object)result.getMessages());
            DMNResultKS res = new DMNResultKS(model.getNamespace(), model.getName(), evalCtx.getDecisionName(), result);
            kieSession.dispose();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "OK from container '" + containerId + "'", (Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Error from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public KieServerRegistry getKieServerRegistry() {
        return this.context;
    }
}

