/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.drools;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kie.api.remote.Remotable;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieSessionLookupHandler;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.drools.DroolsKieContainerCommandServiceImpl;
import org.kie.server.services.drools.DroolsKieSessionLookupHandler;
import org.kie.server.services.drools.RulesExecutionService;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsKieServerExtension
implements KieServerExtension {
    private static final Logger logger = LoggerFactory.getLogger(DroolsKieServerExtension.class);
    public static final String EXTENSION_NAME = "Drools";
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.drools.server.ext.disabled", "false"));
    private static final Boolean filterRemoteable = Boolean.parseBoolean(System.getProperty("org.drools.server.filter.classes", "false"));
    private RulesExecutionService rulesExecutionService;
    private KieContainerCommandService batchCommandService;
    private KieServerRegistry registry;
    private List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.rulesExecutionService = new RulesExecutionService(registry);
        this.batchCommandService = new DroolsKieContainerCommandServiceImpl(kieServer, registry, this.rulesExecutionService);
        this.registry = registry;
        if (registry.getKieSessionLookupManager() != null) {
            registry.getKieSessionLookupManager().addHandler((KieSessionLookupHandler)new DroolsKieSessionLookupHandler());
        }
        this.services.add(this.batchCommandService);
        this.services.add(this.rulesExecutionService);
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        HashSet extraClasses = new HashSet();
        Collection kbases = kieContainerInstance.getKieContainer().getKieBaseNames();
        for (String kbase : kbases) {
            kieContainerInstance.getKieContainer().getKieBase(kbase);
        }
        KieModuleMetaData metaData = (KieModuleMetaData)parameters.get("KieModuleMetaData");
        Collection packages = metaData.getPackages();
        for (String p : packages) {
            Collection classes = metaData.getClasses(p);
            for (String c : classes) {
                String type = p + "." + c;
                try {
                    logger.debug("Adding {} type into extra jaxb classes set", (Object)type);
                    Class<?> clazz = kieContainerInstance.getKieContainer().getClassLoader().loadClass(type);
                    this.addExtraClass(extraClasses, clazz, filterRemoteable);
                    logger.debug("Added {} type into extra jaxb classes set", (Object)type);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Unable to create instance of type {} due to {}", (Object)type, (Object)e.getMessage());
                    logger.debug("Complete stack trace for exception while creating type {}", (Object)type, (Object)e);
                }
                catch (Throwable e) {
                    logger.warn("Unexpected error while create instance of type {} due to {}", (Object)type, (Object)e.getMessage());
                    logger.debug("Complete stack trace for unknown error while creating type {}", (Object)type, (Object)e);
                }
            }
        }
        kieContainerInstance.addExtraClasses(extraClasses);
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.disposeContainer(id, kieContainerInstance, parameters);
        this.createContainer(id, kieContainerInstance, parameters);
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.batchCommandService, this.rulesExecutionService, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.batchCommandService.getClass())) {
            return (T)this.batchCommandService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BRM";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 0;
    }

    public String toString() {
        return "Drools KIE Server extension";
    }

    protected void addExtraClass(Set<Class<?>> extraClasses, Class classToAdd, boolean filtered) {
        if (classToAdd.isInterface() || classToAdd.isAnnotation() || classToAdd.isLocalClass() || classToAdd.isMemberClass()) {
            return;
        }
        if (filtered) {
            boolean jaxbClass = false;
            boolean remoteableClass = false;
            for (Annotation anno : classToAdd.getAnnotations()) {
                if (XmlRootElement.class.equals(anno.annotationType())) {
                    jaxbClass = true;
                    break;
                }
                if (!XmlType.class.equals(anno.annotationType())) continue;
                jaxbClass = true;
                break;
            }
            for (Annotation anno : classToAdd.getDeclaredAnnotations()) {
                if (!Remotable.class.equals(anno.annotationType())) continue;
                remoteableClass = true;
                break;
            }
            if (jaxbClass || remoteableClass) {
                extraClasses.add(classToAdd);
            }
        } else {
            extraClasses.add(classToAdd);
        }
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

