/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.drools;

import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventManager;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.KieSession;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieSessionLookupHandler;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.kie.server.services.prometheus.PrometheusMetricsDroolsListener;

public class DroolsKieSessionLookupHandler
implements KieSessionLookupHandler {
    public CommandExecutor lookupKieSession(String kieSessionId, KieContainerInstance containerInstance, KieServerRegistry registry) {
        KieSession ks = null;
        if (kieSessionId != null) {
            KieServerExtension extension;
            KieSessionModel ksm = containerInstance.getKieContainer().getKieSessionModel(kieSessionId);
            if (ksm != null) {
                switch (ksm.getType()) {
                    case STATEFUL: {
                        ks = ((KieContainerImpl)containerInstance.getKieContainer()).getKieSession(kieSessionId);
                        break;
                    }
                    case STATELESS: {
                        ks = ((KieContainerImpl)containerInstance.getKieContainer()).getStatelessKieSession(kieSessionId);
                    }
                }
            }
            if ((extension = registry.getServerExtension("Prometheus")) != null && ks != null) {
                RuleRuntimeEventManager eventManager = (RuleRuntimeEventManager)ks;
                PrometheusMetrics metrics = PrometheusKieServerExtension.getMetrics();
                PrometheusMetricsDroolsListener listener = new PrometheusMetricsDroolsListener(metrics, kieSessionId, containerInstance);
                eventManager.addEventListener((AgendaEventListener)listener);
            }
            return ks;
        }
        return null;
    }
}

