/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.drools;

import java.util.List;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventManager;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.KieSession;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieSessionLookupHandler;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetricsDroolsListener;

public class DroolsKieSessionLookupHandler
implements KieSessionLookupHandler {
    private static final String DEFAULT_KIE_SESSION_ID = "default";

    public CommandExecutor lookupKieSession(String kieSessionId, KieContainerInstance containerInstance, KieServerRegistry registry) {
        KieSession ks = null;
        if (kieSessionId != null) {
            KieSessionModel ksm = containerInstance.getKieContainer().getKieSessionModel(kieSessionId);
            if (ksm != null) {
                switch (ksm.getType()) {
                    case STATEFUL: {
                        ks = ((KieContainerImpl)containerInstance.getKieContainer()).getKieSession(kieSessionId);
                        break;
                    }
                    case STATELESS: {
                        ks = ((KieContainerImpl)containerInstance.getKieContainer()).getStatelessKieSession(kieSessionId);
                    }
                }
            }
            return ks;
        }
        return null;
    }

    public void postLookupKieSession(String kieSessionId, KieContainerInstance containerInstance, CommandExecutor ks, KieServerRegistry registry) {
        PrometheusKieServerExtension extension = (PrometheusKieServerExtension)registry.getServerExtension("Prometheus");
        if (extension != null && ks instanceof RuleRuntimeEventManager) {
            RuleRuntimeEventManager eventManager = (RuleRuntimeEventManager)ks;
            if (kieSessionId == null || kieSessionId.isEmpty()) {
                kieSessionId = DEFAULT_KIE_SESSION_ID;
            }
            if (eventManager.getAgendaEventListeners().stream().noneMatch(PrometheusMetricsDroolsListener.class::isInstance)) {
                PrometheusMetricsDroolsListener listener = new PrometheusMetricsDroolsListener(PrometheusKieServerExtension.getMetrics(), kieSessionId, containerInstance);
                eventManager.addEventListener((AgendaEventListener)listener);
            }
            List droolsListeners = extension.getDroolsListeners(kieSessionId, containerInstance);
            droolsListeners.forEach(l -> {
                if (!eventManager.getAgendaEventListeners().contains(l)) {
                    eventManager.addEventListener(l);
                }
            });
        }
    }
}

