/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.search.ProcessInstanceSearchServiceBase;
import org.mockito.Mockito;

public class ProcessInstanceSearchServiceBaseTest {
    @Test
    public void testGetProcessInstancesTasksWithFilters() {
        QueryService queryServiceMock = (QueryService)Mockito.mock(QueryService.class);
        KieServerRegistry contextMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        KieServerConfig configMock = (KieServerConfig)Mockito.mock(KieServerConfig.class);
        Mockito.when((Object)contextMock.getConfig()).thenReturn((Object)configMock);
        ProcessInstanceSearchServiceBase base = new ProcessInstanceSearchServiceBase(queryServiceMock, contextMock);
        Integer page = new Integer(0);
        Integer pageSize = new Integer(10);
        String payload = this.getPayload();
        String marshallingType = "JAXB";
        Collection<ProcessInstanceWithVarsDesc> processInstanceCollection = this.getProcessInstances();
        Mockito.when((Object)queryServiceMock.query((String)Mockito.any(), (QueryResultMapper)Mockito.any(), (QueryContext)Mockito.any(), new QueryParam[]{(QueryParam)Mockito.any(QueryParam.class)})).thenReturn(processInstanceCollection);
        ProcessInstanceList processInstances = base.getProcessInstancesWithFilters(page, pageSize, payload, marshallingType);
        Assert.assertEquals((long)1L, (long)processInstances.getItems().size());
        ProcessInstance pi1 = (ProcessInstance)processInstances.getItems().stream().findFirst().get();
        Assert.assertEquals((Object)"test-process", (Object)pi1.getProcessName());
        Assert.assertEquals((long)42L, (long)pi1.getId());
        Assert.assertEquals((Object)"mswiderski", (Object)pi1.getInitiator());
    }

    private String getPayload() {
        StringBuilder payloadBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        payloadBuilder.append("<process-instance-query-filter-spec>");
        payloadBuilder.append("<order-asc>false</order-asc>");
        payloadBuilder.append("<query-params>");
        payloadBuilder.append("<cond-column>PROCESSNAME</cond-column>");
        payloadBuilder.append("<cond-operator>EQUALS_TO</cond-operator>");
        payloadBuilder.append("<cond-values xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">test-process</cond-values>");
        payloadBuilder.append("</query-params>");
        payloadBuilder.append("</process-instance-query-filter-spec>");
        return payloadBuilder.toString();
    }

    private Collection<ProcessInstanceWithVarsDesc> getProcessInstances() {
        ArrayList<ProcessInstanceWithVarsDesc> processInstances = new ArrayList<ProcessInstanceWithVarsDesc>();
        org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc processInstance1 = new org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc(42L, "test-process-id", "test-process", "1.0", 1, "test-deployment", new Date(), "mswiderski", "test description", "ck101");
        processInstances.add((ProcessInstanceWithVarsDesc)processInstance1);
        return processInstances;
    }
}

