/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.search.TaskSearchServiceBase;
import org.mockito.Mockito;

public class TaskSearchServiceBaseTest {
    @Test
    public void testGetHumanTasksWithFilters() {
        QueryService queryServiceMock = (QueryService)Mockito.mock(QueryService.class);
        KieServerRegistry contextMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        KieServerConfig configMock = (KieServerConfig)Mockito.mock(KieServerConfig.class);
        Mockito.when((Object)contextMock.getConfig()).thenReturn((Object)configMock);
        TaskSearchServiceBase base = new TaskSearchServiceBase(queryServiceMock, contextMock);
        Integer page = new Integer(0);
        Integer pageSize = new Integer(10);
        String payload = this.getPayload();
        String marshallingType = "JAXB";
        Collection<UserTaskInstanceWithVarsDesc> userTaskInstances = this.getUserTaskInstances();
        Mockito.when((Object)queryServiceMock.query((String)Mockito.any(), (QueryResultMapper)Mockito.any(), (QueryContext)Mockito.any(), new QueryParam[]{(QueryParam)Mockito.any(QueryParam.class)})).thenReturn(userTaskInstances);
        TaskInstanceList taskInstances = base.getHumanTasksWithFilters(page, pageSize, payload, marshallingType);
        Assert.assertEquals((long)1L, (long)taskInstances.getItems().size());
        TaskInstance ti1 = (TaskInstance)taskInstances.getItems().stream().findFirst().get();
        Assert.assertEquals((Object)"ddoyle", (Object)ti1.getActualOwner());
        Assert.assertEquals((Object)"RESERVED", (Object)ti1.getStatus());
        Assert.assertEquals((Object)"mswiderski", (Object)ti1.getCreatedBy());
    }

    private String getPayload() {
        StringBuilder payloadBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        payloadBuilder.append("<task-query-filter-spec>");
        payloadBuilder.append("<order-asc>false</order-asc>");
        payloadBuilder.append("<query-params>");
        payloadBuilder.append("<cond-column>DEPLOYMENTID</cond-column>");
        payloadBuilder.append("<cond-operator>EQUALS_TO</cond-operator>");
        payloadBuilder.append("<cond-values xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">simple-project</cond-values>");
        payloadBuilder.append("</query-params>");
        payloadBuilder.append("</task-query-filter-spec>");
        return payloadBuilder.toString();
    }

    private Collection<UserTaskInstanceWithVarsDesc> getUserTaskInstances() {
        ArrayList<UserTaskInstanceWithVarsDesc> tasks = new ArrayList<UserTaskInstanceWithVarsDesc>();
        org.jbpm.kie.services.impl.model.UserTaskInstanceWithVarsDesc task1 = new org.jbpm.kie.services.impl.model.UserTaskInstanceWithVarsDesc(new Long(1L), "RESERVED", new Date(), "test-task", "Test task", new Integer(1), "ddoyle", "mswiderski", "test-deployment", "test-process", new Long(1L), new Date(), new Date());
        tasks.add((UserTaskInstanceWithVarsDesc)task1);
        return tasks;
    }
}

