/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.QueryResultMapper;
import org.kie.api.task.model.TaskSummary;
import org.kie.server.services.jbpm.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSearchServiceBase.class);

    protected Object transform(Object result, QueryResultMapper resultMapper) {
        ArrayList actualResult = null;
        if (result instanceof Collection) {
            if (ProcessInstanceWithVarsDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ProcessInstanceWithVarsDesc to ProcessInstanceList");
                actualResult = ConvertUtils.convertToProcessInstanceWithVarsList((Collection)result);
            } else if (ProcessInstanceDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ProcessInstanceDesc to ProcessInstanceList");
                actualResult = ConvertUtils.convertToProcessInstanceList((Collection)result);
            } else if (UserTaskInstanceWithVarsDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of UserTaskInstanceWithVarsDesc to TaskInstanceList");
                actualResult = ConvertUtils.convertToTaskInstanceWithVarsList((Collection)result);
            } else if (UserTaskInstanceDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of UserTaskInstanceDesc to TaskInstanceList");
                actualResult = ConvertUtils.convertToTaskInstanceList((Collection)result);
            } else if (TaskSummary.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of TaskSummary to TaskSummaryList");
                actualResult = ConvertUtils.convertToTaskSummaryList((Collection)result);
            } else if (List.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of List to ArrayList");
                actualResult = new ArrayList(result);
            } else {
                logger.debug("Convert not supported for custom type {}", (Object)resultMapper.getType());
                actualResult = result;
            }
            logger.debug("Actual result after converting is {}", (Object)actualResult);
        } else {
            logger.debug("Result is not a collection - {}, skipping any conversion", (Object)result);
            actualResult = result;
        }
        return actualResult;
    }
}

