/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.kie.server.api.model.definition.BaseQueryFilterSpec;
import org.kie.server.api.model.definition.TaskQueryFilterSpec;
import org.kie.server.api.model.instance.TaskInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.search.AbstractSearchServiceBase;
import org.kie.server.services.jbpm.search.QueryCallback;
import org.kie.server.services.jbpm.search.QueryServiceTemplate;
import org.kie.server.services.jbpm.search.RequestCallback;
import org.kie.server.services.jbpm.search.util.QueryStrategy;
import org.kie.server.services.jbpm.search.util.TaskQueryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSearchServiceBase
extends AbstractSearchServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(TaskSearchServiceBase.class);
    private static final String MAPPER_NAME = "UserTasksWithCustomVariables";
    private static final String TASK_QUERY_NAME = "getTasksWithFilters";
    private MarshallerHelper marshallerHelper;
    private QueryServiceTemplate queryServiceTemplate;
    private QueryCallback queryCallback;

    public TaskSearchServiceBase(QueryService queryService, KieServerRegistry context) {
        this.queryServiceTemplate = new QueryServiceTemplate(queryService);
        this.marshallerHelper = new MarshallerHelper(context);
        String taskQuerySource = context.getConfig().getConfigItemValue("org.kie.server.persistence.ds", "java:jboss/datasources/ExampleDS");
        final TaskQueryStrategy queryStrategy = new TaskQueryStrategy();
        this.queryCallback = new QueryCallback(){

            @Override
            public QueryStrategy getQueryStrategy() {
                return queryStrategy;
            }

            @Override
            public String getQueryName() {
                return TaskSearchServiceBase.TASK_QUERY_NAME;
            }

            @Override
            public String getMapperName() {
                return TaskSearchServiceBase.MAPPER_NAME;
            }
        };
        SqlQueryDefinition queryDefinition = new SqlQueryDefinition(TASK_QUERY_NAME, taskQuerySource, QueryDefinition.Target.CUSTOM);
        queryDefinition.setExpression(queryStrategy.getQueryExpression());
        queryService.replaceQuery((QueryDefinition)queryDefinition);
    }

    public TaskInstanceList getHumanTasksWithFilters(Integer page, Integer pageSize, final String payload, final String marshallingType) {
        RequestCallback reqCallback = new RequestCallback(){

            @Override
            public BaseQueryFilterSpec getQueryFilterSpec() {
                return (BaseQueryFilterSpec)TaskSearchServiceBase.this.marshallerHelper.unmarshal(payload, marshallingType, TaskQueryFilterSpec.class);
            }
        };
        return (TaskInstanceList)this.queryServiceTemplate.getWithFilters(page, pageSize, this.queryCallback, reqCallback);
    }
}

