/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search.util;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.services.api.query.model.QueryParam;
import org.kie.server.api.model.definition.ProcessInstanceField;
import org.kie.server.services.jbpm.search.util.QueryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceQueryStrategy
implements QueryStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceQueryStrategy.class);
    private static final String PROCESS_INSTANCE_QUERY = "select pi.* from ProcessInstanceLog pi";

    @Override
    public String getQueryExpression() {
        return PROCESS_INSTANCE_QUERY;
    }

    @Override
    public Map<String, String> getColumnMapping(QueryParam[] params) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (QueryParam nextParam : params) {
            mapping.put(nextParam.getColumn(), this.getColumnType(nextParam.getColumn()));
        }
        return mapping;
    }

    private String getColumnType(String param) {
        String columnType = null;
        switch (ProcessInstanceField.valueOf((String)param)) {
            case ID: {
                columnType = "integer";
                break;
            }
            case CORRELATIONKEY: {
                columnType = "string";
                break;
            }
            case DURATION: {
                columnType = "integer";
                break;
            }
            case END_DATE: {
                columnType = "date";
                break;
            }
            case EXTERNALID: {
                columnType = "string";
                break;
            }
            case USER_IDENTITY: {
                columnType = "string";
                break;
            }
            case OUTCOME: {
                columnType = "string";
                break;
            }
            case PARENTPROCESSINSTANCEID: {
                columnType = "integer";
                break;
            }
            case PROCESSID: {
                columnType = "string";
                break;
            }
            case PROCESSINSTANCEDESCRIPTION: {
                columnType = "string";
                break;
            }
            case PROCESSINSTANCEID: {
                columnType = "integer";
                break;
            }
            case PROCESSNAME: {
                columnType = "string";
                break;
            }
            case PROCESSTYPE: {
                columnType = "integer";
                break;
            }
            case PROCESSVERSION: {
                columnType = "string";
                break;
            }
            case START_DATE: {
                columnType = "date";
                break;
            }
            case STATUS: {
                columnType = "integer";
                break;
            }
            default: {
                String message = "Unknown paramater.";
                logger.error(message);
                throw new IllegalArgumentException(message);
            }
        }
        return columnType;
    }
}

