/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.kie.server.api.model.definition.BaseQueryFilterSpec;
import org.kie.server.api.model.definition.ProcessInstanceQueryFilterSpec;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.search.AbstractSearchServiceBase;
import org.kie.server.services.jbpm.search.QueryCallback;
import org.kie.server.services.jbpm.search.QueryServiceTemplate;
import org.kie.server.services.jbpm.search.RequestCallback;
import org.kie.server.services.jbpm.search.TaskSearchServiceBase;
import org.kie.server.services.jbpm.search.util.ProcessInstanceQueryStrategy;
import org.kie.server.services.jbpm.search.util.QueryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceSearchServiceBase
extends AbstractSearchServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(TaskSearchServiceBase.class);
    private static final String MAPPER_NAME = "ProcessInstancesWithCustomVariables";
    private static final String PROCESS_INSTANCE_QUERY_NAME = "getProcessInstancesWithFilters";
    private MarshallerHelper marshallerHelper;
    private QueryServiceTemplate queryServiceTemplate;
    private QueryCallback queryCallback;

    public ProcessInstanceSearchServiceBase(QueryService queryService, KieServerRegistry context) {
        this.queryServiceTemplate = new QueryServiceTemplate(queryService);
        this.marshallerHelper = new MarshallerHelper(context);
        String processInstanceQuerySource = context.getConfig().getConfigItemValue("org.kie.server.persistence.ds", "java:jboss/datasources/ExampleDS");
        final ProcessInstanceQueryStrategy queryStrategy = new ProcessInstanceQueryStrategy();
        this.queryCallback = new QueryCallback(){

            @Override
            public QueryStrategy getQueryStrategy() {
                return queryStrategy;
            }

            @Override
            public String getQueryName() {
                return ProcessInstanceSearchServiceBase.PROCESS_INSTANCE_QUERY_NAME;
            }

            @Override
            public String getMapperName() {
                return ProcessInstanceSearchServiceBase.MAPPER_NAME;
            }
        };
        SqlQueryDefinition queryDefinition = new SqlQueryDefinition(PROCESS_INSTANCE_QUERY_NAME, processInstanceQuerySource, QueryDefinition.Target.CUSTOM);
        queryDefinition.setExpression(queryStrategy.getQueryExpression());
        queryService.replaceQuery((QueryDefinition)queryDefinition);
    }

    public ProcessInstanceList getProcessInstancesWithFilters(Integer page, Integer pageSize, final String payload, final String marshallingType) {
        RequestCallback reqCallback = new RequestCallback(){

            @Override
            public BaseQueryFilterSpec getQueryFilterSpec() {
                return (BaseQueryFilterSpec)ProcessInstanceSearchServiceBase.this.marshallerHelper.unmarshal(payload, marshallingType, ProcessInstanceQueryFilterSpec.class);
            }
        };
        return (ProcessInstanceList)this.queryServiceTemplate.getWithFilters(page, pageSize, this.queryCallback, reqCallback);
    }
}

