/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jbpm.services.api.query.QueryService;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.jbpm.search.JbpmSearchKieContainerCommandServiceImpl;
import org.kie.server.services.jbpm.search.ProcessInstanceSearchServiceBase;
import org.kie.server.services.jbpm.search.TaskSearchServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmSearchKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "jBPMSearch";
    private static final Logger logger = LoggerFactory.getLogger(JbpmSearchKieServerExtension.class);
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.jbpm.search.server.ext.disabled", "false"));
    private static final Boolean jbpmDisabled = Boolean.parseBoolean(System.getProperty("org.jbpm.server.ext.disabled", "false"));
    private KieServerImpl kieServer;
    private KieServerRegistry context;
    private QueryService queryService;
    private List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;
    private TaskSearchServiceBase taskSearchServiceBase;
    private ProcessInstanceSearchServiceBase processInstanceSearchServiceBase;
    private KieContainerCommandService kieContainerCommandService;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false && jbpmDisabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.kieServer = kieServer;
        this.context = registry;
        KieServerExtension jBpmExtension = registry.getServerExtension("jBPM");
        if (jBpmExtension == null) {
            logger.error("No jBPM extension available, quiting...");
            return;
        }
        this.queryService = (QueryService)jBpmExtension.getAppComponents(QueryService.class);
        this.processInstanceSearchServiceBase = new ProcessInstanceSearchServiceBase(this.queryService, this.context);
        this.taskSearchServiceBase = new TaskSearchServiceBase(this.queryService, this.context);
        this.services.add(this.processInstanceSearchServiceBase);
        this.services.add(this.taskSearchServiceBase);
        this.kieContainerCommandService = new JbpmSearchKieContainerCommandServiceImpl(this.context, this.taskSearchServiceBase, this.processInstanceSearchServiceBase);
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        if (!this.initialized) {
            return appComponentsList;
        }
        Object[] services = new Object[]{this.processInstanceSearchServiceBase, this.taskSearchServiceBase, this.context};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (!this.initialized) {
            return null;
        }
        if (serviceType.isAssignableFrom(this.kieContainerCommandService.getClass())) {
            return (T)this.kieContainerCommandService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BPMQueries";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 50;
    }

    public String toString() {
        return "jBPMSearch KIE Server extension";
    }
}

