/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.QueryMapperRegistry;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.server.api.model.definition.BaseQueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.services.jbpm.ConvertUtils;
import org.kie.server.services.jbpm.search.QueryCallback;
import org.kie.server.services.jbpm.search.RequestCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceTemplate {
    private static final Logger logger = LoggerFactory.getLogger(QueryServiceTemplate.class);
    private QueryService queryService;

    public QueryServiceTemplate(QueryService queryService) {
        this.queryService = queryService;
    }

    public <T> T getWithFilters(Integer page, Integer pageSize, QueryCallback queryCallback, RequestCallback reqCallback) {
        org.jbpm.services.api.query.model.QueryParam[] params = new org.jbpm.services.api.query.model.QueryParam[]{};
        Map columnMapping = null;
        QueryContext queryContext = ConvertUtils.buildQueryContext((Integer)page, (Integer)pageSize);
        BaseQueryFilterSpec filterSpec = reqCallback.getQueryFilterSpec();
        if (filterSpec != null) {
            queryContext.setOrderBy(filterSpec.getOrderBy());
            queryContext.setAscending(Boolean.valueOf(filterSpec.isAscending()));
            if (filterSpec.getParameters() != null) {
                params = new org.jbpm.services.api.query.model.QueryParam[filterSpec.getParameters().length];
                int index = 0;
                for (QueryParam param : filterSpec.getParameters()) {
                    params[index] = new org.jbpm.services.api.query.model.QueryParam(param.getColumn(), param.getOperator(), param.getValue());
                    ++index;
                }
            }
        }
        QueryResultMapper resultMapper = QueryMapperRegistry.get().mapperFor(queryCallback.getMapperName(), columnMapping);
        logger.debug("About to perform query '{}' with page {} and page size {}", new Object[]{queryCallback.getQueryName(), page, pageSize});
        Object result = this.queryService.query(queryCallback.getQueryName(), resultMapper, queryContext, params);
        logger.debug("Result returned from the query {} mapped with {}", result, (Object)resultMapper);
        return (T)this.transform(result, resultMapper);
    }

    protected Object transform(Object result, QueryResultMapper resultMapper) {
        ArrayList actualResult = null;
        if (result instanceof Collection) {
            if (ProcessInstanceWithVarsDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ProcessInstanceWithVarsDesc to ProcessInstanceList");
                actualResult = ConvertUtils.convertToProcessInstanceWithVarsList((Collection)result);
            } else if (ProcessInstanceDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ProcessInstanceDesc to ProcessInstanceList");
                actualResult = ConvertUtils.convertToProcessInstanceList((Collection)result);
            } else if (UserTaskInstanceWithVarsDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of UserTaskInstanceWithVarsDesc to TaskInstanceList");
                actualResult = ConvertUtils.convertToTaskInstanceWithVarsList((Collection)result);
            } else if (UserTaskInstanceDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of UserTaskInstanceDesc to TaskInstanceList");
                actualResult = ConvertUtils.convertToTaskInstanceList((Collection)result);
            } else if (TaskSummary.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of TaskSummary to TaskSummaryList");
                actualResult = ConvertUtils.convertToTaskSummaryList((Collection)result);
            } else if (ExecutionError.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ExecutionError to ErrorInstanceList");
                actualResult = ConvertUtils.convertToErrorInstanceList((List)result);
            } else if (List.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of List to ArrayList");
                actualResult = new ArrayList(result);
            } else {
                logger.debug("Convert not supported for custom type {}", (Object)resultMapper.getType());
                actualResult = result;
            }
            logger.debug("Actual result after converting is {}", (Object)actualResult);
        } else {
            logger.debug("Result is not a collection - {}, skipping any conversion", (Object)result);
            actualResult = result;
        }
        return actualResult;
    }
}

