/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.server.api.model.definition.AssociatedEntitiesDefinition;
import org.kie.server.api.model.definition.ServiceTasksDefinition;
import org.kie.server.api.model.definition.SubProcessesDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.definition.UserTaskDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.definition.VariablesDefinition;

public class DefinitionServiceBase {
    private DefinitionService definitionService;

    public DefinitionServiceBase(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }

    public org.kie.server.api.model.definition.ProcessDefinition getProcessDefinition(String containerId, String processId) {
        ProcessDefinition procDef = this.findProcessDefinition(containerId, processId);
        org.kie.server.api.model.definition.ProcessDefinition responseObject = org.kie.server.api.model.definition.ProcessDefinition.builder().id(procDef.getId()).name(procDef.getName()).version(procDef.getVersion()).packageName(procDef.getPackageName()).containerId(procDef.getDeploymentId()).entitiesAsCollection(procDef.getAssociatedEntities()).serviceTasks(procDef.getServiceTasks()).subprocesses(procDef.getReusableSubProcesses()).variables(procDef.getProcessVariables()).build();
        return responseObject;
    }

    public SubProcessesDefinition getReusableSubProcesses(String containerId, String processId) {
        this.findProcessDefinition(containerId, processId);
        Collection reusableSubProcesses = this.definitionService.getReusableSubProcesses(containerId, processId);
        return new SubProcessesDefinition(reusableSubProcesses);
    }

    public VariablesDefinition getProcessVariables(String containerId, String processId) {
        this.findProcessDefinition(containerId, processId);
        Map processVariables = this.definitionService.getProcessVariables(containerId, processId);
        return new VariablesDefinition(processVariables);
    }

    public ServiceTasksDefinition getServiceTasks(String containerId, String processId) {
        this.findProcessDefinition(containerId, processId);
        Map serviceTasks = this.definitionService.getServiceTasks(containerId, processId);
        return new ServiceTasksDefinition(serviceTasks);
    }

    public AssociatedEntitiesDefinition getAssociatedEntities(String containerId, String processId) {
        this.findProcessDefinition(containerId, processId);
        Map entities = this.definitionService.getAssociatedEntities(containerId, processId);
        return AssociatedEntitiesDefinition.from((Map)entities);
    }

    public UserTaskDefinitionList getTasksDefinitions(String containerId, String processId) {
        this.findProcessDefinition(containerId, processId);
        Collection userTaskDefinitions = this.definitionService.getTasksDefinitions(containerId, processId);
        return this.convert(userTaskDefinitions);
    }

    public TaskInputsDefinition getTaskInputMappings(String containerId, String processId, String taskName) {
        this.findProcessDefinition(containerId, processId);
        Map taskInputs = this.definitionService.getTaskInputMappings(containerId, processId, taskName);
        return new TaskInputsDefinition(taskInputs);
    }

    public TaskOutputsDefinition getTaskOutputMappings(String containerId, String processId, String taskName) {
        this.findProcessDefinition(containerId, processId);
        Map taskOutputs = this.definitionService.getTaskOutputMappings(containerId, processId, taskName);
        return new TaskOutputsDefinition(taskOutputs);
    }

    protected ProcessDefinition findProcessDefinition(String containerId, String processId) {
        ProcessDefinition procDef = this.definitionService.getProcessDefinition(containerId, processId);
        if (procDef == null) {
            throw new IllegalStateException("Process definition " + containerId + " : " + processId + " not found");
        }
        return procDef;
    }

    protected UserTaskDefinitionList convert(Collection<org.jbpm.services.api.model.UserTaskDefinition> taskDefinitions) {
        UserTaskDefinition[] userTaskDefinitions = new UserTaskDefinition[taskDefinitions.size()];
        int i = 0;
        for (org.jbpm.services.api.model.UserTaskDefinition orig : taskDefinitions) {
            UserTaskDefinition definition;
            List<String> entities = orig.getAssociatedEntities();
            if (entities == null) {
                entities = Collections.emptyList();
            }
            userTaskDefinitions[i] = definition = UserTaskDefinition.builder().name(orig.getName()).comment(orig.getComment()).createdBy(orig.getCreatedBy()).priority(orig.getPriority().intValue()).skippable(orig.isSkippable()).entities(entities.toArray(new String[entities.size()])).taskInputs(orig.getTaskInputMappings()).taskOutputs(orig.getTaskOutputMappings()).build();
            ++i;
        }
        return new UserTaskDefinitionList(userTaskDefinitions);
    }
}

