/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.api.model.instance.WorkItemInstanceList;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.locator.ByProcessInstanceIdContainerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceBase {
    public static final Logger logger = LoggerFactory.getLogger(ProcessServiceBase.class);
    private ProcessService processService;
    private DefinitionService definitionService;
    private RuntimeDataService runtimeDataService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();

    public ProcessServiceBase(ProcessService processService, DefinitionService definitionService, RuntimeDataService runtimeDataService, KieServerRegistry context) {
        this.processService = processService;
        this.definitionService = definitionService;
        this.runtimeDataService = runtimeDataService;
        this.marshallerHelper = new MarshallerHelper(context);
        this.context = context;
    }

    public String startProcess(String containerId, String processId, String marshallingType) {
        ProcessDefinition procDef = this.definitionService.getProcessDefinition(containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator()), processId);
        if (procDef == null) {
            throw new IllegalStateException("Unable to find process '" + processId + "' in container " + containerId);
        }
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, null});
        Long processInstanceId = this.processService.startProcess(containerId, processId);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstanceId);
        return response;
    }

    public String startProcess(String containerId, String processId, String payload, String marshallingType) {
        ProcessDefinition procDef = this.definitionService.getProcessDefinition(containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator()), processId);
        if (procDef == null) {
            throw new IllegalStateException("Unable to find process '" + processId + "' in container " + containerId);
        }
        logger.debug("About to unmarshal parameters from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters});
        Long processInstanceId = this.processService.startProcess(containerId, processId, parameters);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstanceId);
        return response;
    }

    public String startProcessWithCorrelation(String containerId, String processId, String correlationKey, String payload, String marshallingType) {
        ProcessDefinition procDef = this.definitionService.getProcessDefinition(containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator()), processId);
        if (procDef == null) {
            throw new IllegalStateException("Unable to find process '" + processId + "' in container " + containerId);
        }
        logger.debug("About to unmarshal parameters from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters});
        Long processInstanceId = this.processService.startProcess(containerId, processId, actualCorrelationKey, parameters);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstanceId);
        return response;
    }

    public Object abortProcessInstance(String containerId, Number processInstanceId) {
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId.longValue()));
        return null;
    }

    protected List<Long> convert(List<? extends Number> input) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Number number : input) {
            result.add(number.longValue());
        }
        return result;
    }

    public Object abortProcessInstances(String containerId, List<Long> processInstanceIds) {
        this.processService.abortProcessInstances(this.convert(processInstanceIds));
        return null;
    }

    public void signalProcessInstance(String containerId, Number processInstanceId, String signalName, String marshallingType) {
        logger.debug("Calling signal '{}' process instance with id {} on container {} and event {}", new Object[]{signalName, processInstanceId, containerId, null});
        this.processService.signalProcessInstance(Long.valueOf(processInstanceId.longValue()), signalName, null);
    }

    public void signalProcessInstance(String containerId, Number processInstanceId, String signalName, String eventPayload, String marshallingType) {
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("Calling signal '{}' process instance with id {} on container {} and event {}", new Object[]{signalName, processInstanceId, containerId, event});
        this.processService.signalProcessInstance(Long.valueOf(processInstanceId.longValue()), signalName, event);
    }

    public void signalProcessInstances(String containerId, List<Long> processInstanceIds, String signalName, String marshallingType) {
        logger.debug("Calling signal '{}' process instances with id {} on container {} and event {}", new Object[]{signalName, processInstanceIds, containerId, null});
        this.processService.signalProcessInstances(this.convert(processInstanceIds), signalName, null);
    }

    public void signalProcessInstances(String containerId, List<Long> processInstanceIds, String signalName, String eventPayload, String marshallingType) {
        List<Long> ids = this.convert(processInstanceIds);
        if (ids.isEmpty()) {
            return;
        }
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class, (ContainerLocator)new ByProcessInstanceIdContainerLocator(ids.get(0)));
        logger.debug("Calling signal '{}' process instances with id {} on container {} and event {}", new Object[]{signalName, processInstanceIds, containerId, event});
        this.processService.signalProcessInstances(ids, signalName, event);
    }

    public void signal(String containerId, String signalName, String marshallingType) {
        logger.debug("Calling signal '{}' on container {} and event {}", new Object[]{signalName, containerId, null});
        this.processService.signalEvent(containerId, signalName, null);
    }

    public void signal(String containerId, String signalName, String eventPayload, String marshallingType) {
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class);
        logger.debug("Calling signal '{}' on container {} and event {}", new Object[]{signalName, containerId, event});
        this.processService.signalEvent(containerId, signalName, event);
    }

    public String getProcessInstance(String containerId, Number processInstanceId, boolean withVars, String marshallingType) {
        ProcessInstanceDesc instanceDesc = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (instanceDesc == null) {
            throw new IllegalStateException("Unable to find process instance with id " + processInstanceId);
        }
        ProcessInstance processInstance = ProcessInstance.builder().id(instanceDesc.getId()).processId(instanceDesc.getProcessId()).processName(instanceDesc.getProcessName()).processVersion(instanceDesc.getProcessVersion()).state(instanceDesc.getState()).containerId(instanceDesc.getDeploymentId()).date(instanceDesc.getDataTimeStamp()).initiator(instanceDesc.getInitiator()).processInstanceDescription(instanceDesc.getProcessInstanceDescription()).parentInstanceId(instanceDesc.getParentId()).correlationKey(instanceDesc.getCorrelationKey()).build();
        if (Boolean.TRUE.equals(withVars) && processInstance.getState().equals(1)) {
            Map variables = this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId.longValue()));
            processInstance.setVariables(variables);
        }
        logger.debug("About to marshal process instance with id '{}' {}", (Object)processInstanceId, (Object)processInstance);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstance, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        return response;
    }

    public void setProcessVariable(String containerId, Number processInstanceId, String varName, String variablePayload, String marshallingType) {
        logger.debug("About to unmarshal variable from payload: '{}'", (Object)variablePayload);
        Object variable = this.marshallerHelper.unmarshal(containerId, variablePayload, marshallingType, Object.class, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("Setting variable '{}' on process instance with id {} with value {}", new Object[]{varName, processInstanceId, variable});
        this.processService.setProcessVariable(Long.valueOf(processInstanceId.longValue()), varName, variable);
    }

    public void setProcessVariables(String containerId, Number processInstanceId, String variablePayload, String marshallingType) {
        logger.debug("About to unmarshal variables from payload: '{}'", (Object)variablePayload);
        Map variables = (Map)this.marshallerHelper.unmarshal(containerId, variablePayload, marshallingType, Map.class, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("Setting variables '{}' on process instance with id {} with value {}", new Object[]{variables.keySet(), processInstanceId, variables.values()});
        this.processService.setProcessVariables(Long.valueOf(processInstanceId.longValue()), variables);
    }

    public String getProcessInstanceVariable(String containerId, Number processInstanceId, String varName, String marshallingType) {
        Object variable = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId.longValue()), varName);
        if (variable == null) {
            throw new IllegalStateException("Unable to find variable '" + varName + "' within process instance with id " + processInstanceId);
        }
        logger.debug("About to marshal process variable with name '{}' {}", (Object)varName, variable);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, variable, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        return response;
    }

    public String getProcessInstanceVariables(String containerId, Number processInstanceId, String marshallingType) {
        Map variables = this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId.longValue()));
        logger.debug("About to marshal process variables {}", (Object)variables);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)variables, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        return response;
    }

    public String getAvailableSignals(String containerId, Number processInstanceId, String marshallingType) {
        Collection signals = this.processService.getAvailableSignals(Long.valueOf(processInstanceId.longValue()));
        logger.debug("About to marshal available signals {}", (Object)signals);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)signals);
        return response;
    }

    public void completeWorkItem(String containerId, Number processInstanceId, Number workItemId, String resultPayload, String marshallingType) {
        logger.debug("About to unmarshal work item result from payload: '{}'", (Object)resultPayload);
        Map results = (Map)this.marshallerHelper.unmarshal(containerId, resultPayload, marshallingType, Map.class, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("Completing work item '{}' on process instance id {} with value {}", new Object[]{workItemId, processInstanceId, results});
        this.processService.completeWorkItem(Long.valueOf(workItemId.longValue()), results);
    }

    public void abortWorkItem(String containerId, Number processInstanceId, Number workItemId) {
        logger.debug("Aborting work item '{}' on process instance id {}", (Object)workItemId, (Object)processInstanceId);
        this.processService.abortWorkItem(Long.valueOf(workItemId.longValue()));
    }

    public String getWorkItem(String containerId, Number processInstanceId, Number workItemId, String marshallingType) {
        WorkItem workItem = this.processService.getWorkItem(Long.valueOf(workItemId.longValue()));
        if (workItem == null) {
            throw new IllegalStateException("Unable to find work item with id " + workItemId);
        }
        WorkItemInstance workItemInstance = WorkItemInstance.builder().id(Long.valueOf(workItem.getId())).nodeInstanceId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeInstanceId())).processInstanceId(Long.valueOf(workItem.getProcessInstanceId())).containerId(((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId()).name(workItem.getName()).nodeId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeId())).parameters(workItem.getParameters()).state(Integer.valueOf(workItem.getState())).build();
        logger.debug("About to marshal work item {}", (Object)workItemInstance);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)workItemInstance, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        return response;
    }

    public String getWorkItemByProcessInstance(String containerId, Number processInstanceId, String marshallingType) {
        List workItems = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId.longValue()));
        WorkItemInstance[] instances = new WorkItemInstance[workItems.size()];
        int counter = 0;
        for (WorkItem workItem : workItems) {
            WorkItemInstance workItemInstance;
            instances[counter] = workItemInstance = WorkItemInstance.builder().id(Long.valueOf(workItem.getId())).nodeInstanceId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeInstanceId())).processInstanceId(Long.valueOf(workItem.getProcessInstanceId())).containerId(((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId()).name(workItem.getName()).nodeId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeId())).parameters(workItem.getParameters()).state(Integer.valueOf(workItem.getState())).build();
            ++counter;
        }
        WorkItemInstanceList result = new WorkItemInstanceList(instances);
        logger.debug("About to marshal work items {}", (Object)result);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)result, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        return response;
    }
}

