/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jbpm.services.api.admin.MigrationEntry;
import org.jbpm.services.api.admin.MigrationReport;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.kie.server.api.model.admin.MigrationReportInstance;
import org.kie.server.api.model.admin.MigrationReportInstanceList;
import org.kie.server.api.model.admin.ProcessNode;
import org.kie.server.api.model.admin.ProcessNodeList;
import org.kie.server.api.model.admin.TimerInstance;
import org.kie.server.api.model.admin.TimerInstanceList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessAdminServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAdminServiceBase.class);
    private ProcessInstanceMigrationService processInstanceMigrationService;
    private ProcessInstanceAdminService processInstanceAdminService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;

    public ProcessAdminServiceBase(ProcessInstanceMigrationService processInstanceMigrationService, ProcessInstanceAdminService processInstanceAdminService, KieServerRegistry context) {
        this.processInstanceMigrationService = processInstanceMigrationService;
        this.processInstanceAdminService = processInstanceAdminService;
        this.marshallerHelper = new MarshallerHelper(context);
        this.context = context;
    }

    public MigrationReportInstance migrateProcessInstance(String containerId, Number processInstanceId, String targetContainerId, String targetProcessId, String payload, String marshallingType) {
        Map nodeMapping = Collections.emptyMap();
        if (payload != null) {
            logger.debug("About to unmarshal node mapping from payload: '{}' using container {} marshaller", (Object)payload, (Object)containerId);
            nodeMapping = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        }
        logger.debug("About to migrate process instance with id {} from container '{}' to container '{}' and process id '{}' with node mapping {}", new Object[]{processInstanceId, containerId, targetContainerId, targetProcessId, nodeMapping});
        MigrationReport report = this.processInstanceMigrationService.migrate(containerId, Long.valueOf(processInstanceId.longValue()), targetContainerId, targetProcessId, nodeMapping);
        logger.debug("Migration of process instance {} finished with report {}", (Object)processInstanceId, (Object)report);
        return this.convertMigrationReport(report);
    }

    public MigrationReportInstanceList migrateProcessInstances(String containerId, List<Long> processInstancesId, String targetContainerId, String targetProcessId, String payload, String marshallingType) {
        Map nodeMapping = Collections.emptyMap();
        if (payload != null) {
            logger.debug("About to unmarshal node mapping from payload: '{}' using container {} marshaller", (Object)payload, (Object)containerId);
            nodeMapping = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        }
        logger.debug("About to migrate process instances with ids {} from container '{}' to container '{}' and process id '{}' with node mapping {}", new Object[]{processInstancesId, containerId, targetContainerId, targetProcessId, nodeMapping});
        List reports = this.processInstanceMigrationService.migrate(containerId, this.convert(processInstancesId), targetContainerId, targetProcessId, nodeMapping);
        logger.debug("Migration of process instances {} finished with reports {}", processInstancesId, (Object)reports);
        return this.convertMigrationReports(reports);
    }

    public ProcessNodeList getProcessNodes(String containerId, Number processInstanceId) {
        logger.debug("About to get process nodes for process instance {} in container {}", (Object)processInstanceId, (Object)containerId);
        Collection processNodes = this.processInstanceAdminService.getProcessNodes(processInstanceId.longValue());
        logger.debug("Found process nodes {} for process instance {}", (Object)processNodes, (Object)processInstanceId);
        ProcessNodeList processNodeList = this.convertProcessNodes(processNodes);
        return processNodeList;
    }

    public void cancelNodeInstance(String containerId, Number processInstanceId, Number nodeInstanceId) {
        logger.debug("About to cancel node instance {} in process instance {}", (Object)nodeInstanceId, (Object)processInstanceId);
        this.processInstanceAdminService.cancelNodeInstance(processInstanceId.longValue(), nodeInstanceId.longValue());
        logger.debug("Node instance {} canceled successfully", (Object)nodeInstanceId);
    }

    public void retriggerNodeInstance(String containerId, Number processInstanceId, Number nodeInstanceId) {
        logger.debug("About to retrigger node instance {} in process instance {}", (Object)nodeInstanceId, (Object)processInstanceId);
        this.processInstanceAdminService.retriggerNodeInstance(processInstanceId.longValue(), nodeInstanceId.longValue());
        logger.debug("Node instance {} retriggered successfully", (Object)nodeInstanceId);
    }

    public NodeInstanceList getActiveNodeInstances(String containerId, Number processInstanceId) {
        logger.debug("About to get active node instance for process instance {} in container {}", (Object)processInstanceId, (Object)containerId);
        Collection activeNodeInstances = this.processInstanceAdminService.getActiveNodeInstances(processInstanceId.longValue());
        logger.debug("Found active node instance {} in process instance {}", (Object)activeNodeInstances, (Object)processInstanceId);
        return ConvertUtils.convertToNodeInstanceList(activeNodeInstances);
    }

    public void triggerNode(String containerId, Number processInstanceId, Number nodeId) {
        logger.debug("About to trigger (create) node {} in process instance {}", (Object)nodeId, (Object)processInstanceId);
        this.processInstanceAdminService.triggerNode(processInstanceId.longValue(), nodeId.longValue());
        logger.debug("Node {} triggered successfully", (Object)nodeId);
    }

    public void updateTimer(String containerId, Number processInstanceId, Number timerId, boolean relative, String payload, String marshallingType) {
        logger.debug("About to unmarshal timer update details from payload: '{}' using container {} marshaller", (Object)payload, (Object)containerId);
        Map timerUpdates = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        Number delay = timerUpdates.getOrDefault("delay", 0);
        Number period = timerUpdates.getOrDefault("period", 0);
        Number repeatLimit = timerUpdates.getOrDefault("repeatLimit", 0);
        if (relative) {
            logger.debug("Timer {} in process instance is going to be updated relatively to current time with values: delay {}, period {}, repeat limit {}", new Object[]{timerId, processInstanceId, delay, period, repeatLimit});
            this.processInstanceAdminService.updateTimerRelative(processInstanceId.longValue(), timerId.longValue(), delay.longValue(), period.longValue(), repeatLimit.intValue());
        } else {
            logger.debug("Timer {} in process instance is going to be updated with values: delay {}, period {}, repeat limit {}", new Object[]{timerId, processInstanceId, delay, period, repeatLimit});
            this.processInstanceAdminService.updateTimer(processInstanceId.longValue(), timerId.longValue(), delay.longValue(), period.longValue(), repeatLimit.intValue());
        }
        logger.debug("Timer {} triggered successfully in process instance", (Object)timerId, (Object)processInstanceId);
    }

    public TimerInstanceList getTimerInstances(String containerId, Number processInstanceId) {
        logger.debug("About to get timers for process instance {} in container {}", (Object)processInstanceId, (Object)containerId);
        Collection timerInstances = this.processInstanceAdminService.getTimerInstances(processInstanceId.longValue());
        logger.debug("Found timers {} in process instance {}", (Object)timerInstances, (Object)processInstanceId);
        TimerInstanceList timerInstanceList = this.convertTimerInstances(timerInstances);
        return timerInstanceList;
    }

    protected MigrationReportInstanceList convertMigrationReports(List<MigrationReport> reports) {
        if (reports == null) {
            return new MigrationReportInstanceList();
        }
        MigrationReportInstance[] reportInstances = new MigrationReportInstance[reports.size()];
        int index = 0;
        for (MigrationReport report : reports) {
            MigrationReportInstance instance;
            reportInstances[index] = instance = this.convertMigrationReport(report);
            ++index;
        }
        return new MigrationReportInstanceList(reportInstances);
    }

    protected MigrationReportInstance convertMigrationReport(MigrationReport report) {
        if (report == null) {
            return null;
        }
        MigrationReportInstance reportInstance = MigrationReportInstance.builder().successful(report.isSuccessful()).startDate(report.getStartDate()).endDate(report.getEndDate()).logs(this.convertLogs(report.getEntries())).build();
        return reportInstance;
    }

    protected ProcessNodeList convertProcessNodes(Collection<org.jbpm.services.api.admin.ProcessNode> processNodes) {
        if (processNodes == null) {
            return new ProcessNodeList();
        }
        ProcessNode[] processNodesConverted = new ProcessNode[processNodes.size()];
        int index = 0;
        for (org.jbpm.services.api.admin.ProcessNode processNode : processNodes) {
            ProcessNode instance;
            processNodesConverted[index] = instance = this.convertProcessNode(processNode);
            ++index;
        }
        return new ProcessNodeList(processNodesConverted);
    }

    protected ProcessNode convertProcessNode(org.jbpm.services.api.admin.ProcessNode processNode) {
        if (processNode == null) {
            return null;
        }
        ProcessNode processNodeConverted = ProcessNode.builder().nodeId(processNode.getNodeId()).nodeName(processNode.getNodeName()).nodeType(processNode.getNodeType()).processId(processNode.getProcessId()).build();
        return processNodeConverted;
    }

    protected TimerInstanceList convertTimerInstances(Collection<org.jbpm.services.api.admin.TimerInstance> timerInstances) {
        if (timerInstances == null) {
            return new TimerInstanceList();
        }
        TimerInstance[] timerInstancesConverted = new TimerInstance[timerInstances.size()];
        int index = 0;
        for (org.jbpm.services.api.admin.TimerInstance timerInstance : timerInstances) {
            TimerInstance instance;
            timerInstancesConverted[index] = instance = this.convertTimerInstance(timerInstance);
            ++index;
        }
        return new TimerInstanceList(timerInstancesConverted);
    }

    protected TimerInstance convertTimerInstance(org.jbpm.services.api.admin.TimerInstance timerInstance) {
        if (timerInstance == null) {
            return null;
        }
        TimerInstance timerInstanceConverted = TimerInstance.builder().activationTime(timerInstance.getActivationTime()).delay(timerInstance.getDelay()).lastFireTime(timerInstance.getLastFireTime()).nextFireTime(timerInstance.getNextFireTime()).period(timerInstance.getPeriod()).processInstanceId(timerInstance.getProcessInstanceId()).repeatLimit(timerInstance.getRepeatLimit()).sessionId(timerInstance.getSessionId()).timerId(timerInstance.getTimerId()).timerName(timerInstance.getTimerName()).build();
        return timerInstanceConverted;
    }

    protected List<String> convertLogs(List<MigrationEntry> entries) {
        ArrayList<String> logs = new ArrayList<String>();
        if (entries != null) {
            for (MigrationEntry entry : entries) {
                logs.add(entry.getType() + " " + entry.getTimestamp() + " " + entry.getMessage());
            }
        }
        return logs;
    }

    protected List<Long> convert(List<? extends Number> input) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Number number : input) {
            result.add(number.longValue());
        }
        return result;
    }
}

