/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.services.api.model.ProcessInstanceCustomDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.QueryAlreadyRegisteredException;
import org.jbpm.services.api.query.QueryMapperRegistry;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.QueryParamBuilderFactory;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.kie.api.runtime.query.AdvancedQueryContext;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.definition.QueryDefinitionList;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.ConvertUtils;
import org.kie.server.services.jbpm.QueryParamBuilderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDataServiceBase {
    public static final Logger logger = LoggerFactory.getLogger(QueryDataServiceBase.class);
    protected static final Pattern PARAMETER_MATCHER = Pattern.compile("\\$\\{([\\S&&[^\\}]]+)\\}", 32);
    private QueryService queryService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;

    public QueryDataServiceBase(QueryService queryService, KieServerRegistry context) {
        this.queryService = queryService;
        this.context = context;
        this.marshallerHelper = new MarshallerHelper(context);
    }

    public org.kie.server.api.model.definition.QueryDefinition registerQuery(String queryName, String payload, String marshallingType) throws QueryAlreadyRegisteredException {
        logger.debug("About to unmarshal queryDefinition from payload: '{}'", (Object)payload);
        org.kie.server.api.model.definition.QueryDefinition queryDefinition = (org.kie.server.api.model.definition.QueryDefinition)this.marshallerHelper.unmarshal(payload, marshallingType, org.kie.server.api.model.definition.QueryDefinition.class);
        queryDefinition.setName(queryName);
        SqlQueryDefinition actualDefinition = QueryDataServiceBase.build(this.context, queryDefinition);
        logger.debug("Built sql query definition for {} with content {}", (Object)queryName, (Object)actualDefinition);
        this.queryService.registerQuery((QueryDefinition)actualDefinition);
        return ConvertUtils.convertQueryDefinition((QueryDefinition)actualDefinition);
    }

    public org.kie.server.api.model.definition.QueryDefinition replaceQuery(String queryName, String payload, String marshallingType) {
        logger.debug("About to unmarshal queryDefinition from payload: '{}'", (Object)payload);
        org.kie.server.api.model.definition.QueryDefinition queryDefinition = (org.kie.server.api.model.definition.QueryDefinition)this.marshallerHelper.unmarshal(payload, marshallingType, org.kie.server.api.model.definition.QueryDefinition.class);
        queryDefinition.setName(queryName);
        SqlQueryDefinition actualDefinition = QueryDataServiceBase.build(this.context, queryDefinition);
        logger.debug("Built sql query definition for {} with content {}", (Object)queryName, (Object)actualDefinition);
        this.queryService.replaceQuery((QueryDefinition)actualDefinition);
        return ConvertUtils.convertQueryDefinition((QueryDefinition)actualDefinition);
    }

    public void unregisterQuery(String uniqueQueryName) throws QueryNotFoundException {
        this.queryService.unregisterQuery(uniqueQueryName);
    }

    public org.kie.server.api.model.definition.QueryDefinition getQuery(String uniqueQueryName) throws QueryNotFoundException {
        QueryDefinition query = this.queryService.getQuery(uniqueQueryName);
        return ConvertUtils.convertQueryDefinition(query);
    }

    public QueryDefinitionList getQueries(Integer page, Integer pageSize) throws QueryNotFoundException {
        List queries = this.queryService.getQueries(ConvertUtils.buildQueryContext(page, pageSize));
        return ConvertUtils.convertToQueryDefinitionList(queries);
    }

    public Object query(String queryName, String mapper, String orderBy, Integer page, Integer pageSize) {
        QueryResultMapper resultMapper = QueryMapperRegistry.get().mapperFor(mapper, null);
        QueryContext queryContext = ConvertUtils.buildQueryContext(page, pageSize);
        if (orderBy != null && !orderBy.isEmpty()) {
            String[] orderBySortOrderItems = orderBy.split(",");
            if (orderBySortOrderItems.length > 1) {
                logger.debug("-- query() > orderBy clause = {} ", (Object)orderBy);
                queryContext = new AdvancedQueryContext(queryContext, orderBy);
            } else {
                logger.debug("-- query() > sortBy = {}", (Object)orderBy);
                queryContext.setOrderBy(orderBy);
                queryContext.setAscending(Boolean.valueOf(true));
            }
        }
        logger.debug("About to perform query '{}' with sorting criteria '{}' and page {} and page size {}", new Object[]{queryName, orderBy, page, pageSize});
        Object result = this.queryService.query(queryName, resultMapper, queryContext, new org.jbpm.services.api.query.model.QueryParam[0]);
        logger.debug("Result returned from the query {} mapped with {}", result, (Object)resultMapper);
        return this.transform(result, resultMapper);
    }

    public Object queryFiltered(String queryName, String mapper, Integer page, Integer pageSize, String payload, String marshallingType) {
        return this.queryFiltered(null, queryName, mapper, page, pageSize, payload, marshallingType);
    }

    public Object queryFiltered(String containerId, String queryName, String mapper, Integer page, Integer pageSize, String payload, String marshallingType) {
        org.jbpm.services.api.query.model.QueryParam[] params = new org.jbpm.services.api.query.model.QueryParam[]{};
        Map columnMapping = null;
        QueryContext queryContext = ConvertUtils.buildQueryContext(page, pageSize);
        QueryFilterSpec filterSpec = new QueryFilterSpec();
        if (payload != null && !payload.isEmpty()) {
            logger.debug("About to unmarshal queryDefinition from payload: '{}'", (Object)payload);
            filterSpec = containerId != null ? (QueryFilterSpec)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, QueryFilterSpec.class) : (QueryFilterSpec)this.marshallerHelper.unmarshal(payload, marshallingType, QueryFilterSpec.class);
            if (filterSpec.getParameters() != null) {
                params = new org.jbpm.services.api.query.model.QueryParam[filterSpec.getParameters().length];
                int index = 0;
                for (QueryParam param : filterSpec.getParameters()) {
                    params[index] = new org.jbpm.services.api.query.model.QueryParam(param.getColumn(), param.getOperator(), param.getValue());
                    ++index;
                }
            }
            columnMapping = filterSpec.getColumnMapping();
        }
        QueryResultMapper resultMapper = QueryMapperRegistry.get().mapperFor(mapper, columnMapping);
        if (filterSpec.getOrderByClause() != null) {
            queryContext = new AdvancedQueryContext(queryContext, filterSpec.getOrderByClause());
        } else {
            queryContext.setOrderBy(filterSpec.getOrderBy());
            queryContext.setAscending(Boolean.valueOf(filterSpec.isAscending()));
        }
        logger.debug("About to perform query '{}' with page {} and page size {}", new Object[]{queryName, page, pageSize});
        Object result = this.queryService.query(queryName, resultMapper, queryContext, params);
        logger.debug("Result returned from the query {} mapped with {}", result, (Object)resultMapper);
        return this.transform(result, resultMapper);
    }

    public Object queryFilteredWithBuilder(String queryName, String mapper, String builder, Integer page, Integer pageSize, String payload, String marshallingType) {
        return this.queryFilteredWithBuilder(null, queryName, mapper, builder, page, pageSize, payload, marshallingType);
    }

    public Object queryFilteredWithBuilder(String containerId, String queryName, String mapper, String builder, Integer page, Integer pageSize, String payload, String marshallingType) {
        Map columnMapping = null;
        QueryContext queryContext = ConvertUtils.buildQueryContext(page, pageSize);
        Map queryParameters = new HashMap();
        String orderBy = null;
        Boolean ascending = null;
        String orderByClause = null;
        if (payload != null && !payload.isEmpty()) {
            logger.debug("About to unmarshal query params from payload: '{}'", (Object)payload);
            queryParameters = containerId != null ? (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class) : (Map)this.marshallerHelper.unmarshal(payload, marshallingType, Map.class);
            orderBy = (String)queryParameters.remove("q_order_by");
            ascending = (Boolean)queryParameters.remove("q_ascending");
            orderByClause = (String)queryParameters.remove("q_order_by_clause");
            columnMapping = (Map)queryParameters.remove("q_column_mapping");
        }
        QueryResultMapper resultMapper = QueryMapperRegistry.get().mapperFor(mapper, columnMapping);
        QueryParamBuilderFactory paramBuilderFactory = QueryParamBuilderManager.get().find(builder);
        if (paramBuilderFactory == null) {
            throw new RuntimeException("No query param builder found for " + builder);
        }
        if (orderByClause != null) {
            queryContext = new AdvancedQueryContext(queryContext, orderByClause);
        } else {
            if (orderBy != null) {
                queryContext.setOrderBy(orderBy);
            }
            if (ascending != null) {
                queryContext.setAscending(ascending);
            }
        }
        logger.debug("About to perform query '{}' with page {} and page size {}", new Object[]{queryName, page, pageSize});
        Object result = this.queryService.query(queryName, resultMapper, queryContext, paramBuilderFactory.newInstance(queryParameters));
        logger.debug("Result returned from the query {} mapped with {}", result, (Object)resultMapper);
        return this.transform(result, resultMapper);
    }

    protected Object transform(Object result, QueryResultMapper resultMapper) {
        ArrayList actualResult = null;
        if (result instanceof Collection) {
            if (ProcessInstanceCustomDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ProcessInstanceCustomDesc to ProcessInstanceCustomList");
                actualResult = ConvertUtils.convertToProcessInstanceCustomVarsList(result);
            } else if (ProcessInstanceWithVarsDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ProcessInstanceWithVarsDesc to ProcessInstanceList");
                actualResult = ConvertUtils.convertToProcessInstanceWithVarsList(result);
            } else if (ProcessInstanceDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ProcessInstanceDesc to ProcessInstanceList");
                actualResult = ConvertUtils.convertToProcessInstanceList(result);
            } else if (UserTaskInstanceWithVarsDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of UserTaskInstanceWithVarsDesc to TaskInstanceList");
                actualResult = ConvertUtils.convertToTaskInstanceWithVarsList(result);
            } else if (UserTaskInstanceWithPotOwnerDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of UserTaskInstanceWithPotOwnerDesc to TaskInstanceList");
                actualResult = ConvertUtils.convertToTaskInstanceListPO(result);
            } else if (UserTaskInstanceDesc.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of UserTaskInstanceDesc to TaskInstanceList");
                actualResult = ConvertUtils.convertToTaskInstanceList(result);
            } else if (TaskSummary.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of TaskSummary to TaskSummaryList");
                actualResult = ConvertUtils.convertToTaskSummaryList(result);
            } else if (ExecutionError.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of ExecutionError to ErrorInstanceList");
                actualResult = ConvertUtils.convertToErrorInstanceList(result);
            } else if (List.class.isAssignableFrom(resultMapper.getType())) {
                logger.debug("Converting collection of List to ArrayList");
                actualResult = new ArrayList(result);
            } else {
                logger.debug("Convert not supported for custom type {}", (Object)resultMapper.getType());
                actualResult = result;
            }
            logger.debug("Actual result after converting is {}", (Object)actualResult);
        } else {
            logger.debug("Result is not a collection - {}, skipping any conversion", (Object)result);
            actualResult = result;
        }
        return actualResult;
    }

    protected static SqlQueryDefinition build(KieServerRegistry context, org.kie.server.api.model.definition.QueryDefinition queryDefinition) {
        String dataSource = queryDefinition.getSource();
        Matcher matcher = PARAMETER_MATCHER.matcher(dataSource);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            KieServerConfig configuration = context.getStateRepository().load(KieServerEnvironment.getServerId()).getConfiguration();
            dataSource = configuration.getConfigItemValue(paramName, "java:jboss/datasources/ExampleDS");
        }
        SqlQueryDefinition actualDefinition = new SqlQueryDefinition(queryDefinition.getName(), dataSource);
        actualDefinition.setExpression(queryDefinition.getExpression());
        actualDefinition.setTarget(QueryDefinition.Target.valueOf((String)queryDefinition.getTarget()));
        return actualDefinition;
    }
}

