/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.DependencyFilter;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.core.impl.InternalKieContainer;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.scanner.KieMavenRepository;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.kie.server.services.jbpm.JbpmKieServerExtension;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class JbpmKieServerExtensionTest {
    private static final String RESOURCES = "src/main/resources/";
    private static final String CONTAINER_ID = "my-container";
    private static final String GROUP_ID = "org.kie.server.test";
    private static final String ARTIFACT_ID = "my-test-artifact";
    private static final String VERSION = "1.0.0.Final";
    private static final String VERSION_SNAPSHOT = "1.0.0-SNAPSHOT";
    private boolean deployed = false;
    @Captor
    private ArgumentCaptor<Function<DeploymentUnit, Boolean>> beforeUndeployCaptor;
    @Mock
    private DeploymentService deploymentService;
    @Mock
    private RuntimeDataService runtimeDataService;
    @Mock
    private QueryService queryService;
    @Mock
    private KieServerImpl kieServer;
    @Mock
    private KieServerInfo kieServerInfo;
    private KieServerMode mode;
    private List<ProcessInstanceDesc> activeProcessInstances = new ArrayList<ProcessInstanceDesc>();
    private KieServicesImpl kieServices;
    private KieServerRegistry context;
    private JbpmKieServerExtension extension;
    private InternalKieContainer kieContainer;
    private DeploymentUnit deploymentUnit;
    private DeployedUnitImpl deployedUnit;
    private RuntimeManager runimeManager;
    private RuntimeEngine engine;
    private KieSession session;

    @Before
    public void init() {
        KieServerEnvironment.setServerId((String)UUID.randomUUID().toString());
        this.context = new KieServerRegistryImpl();
        this.context.registerStateRepository((KieServerStateRepository)new KieServerStateFileRepository(new File("target")));
        this.kieServices = (KieServicesImpl)KieServices.Factory.get();
        Mockito.when((Object)this.kieServerInfo.getMode()).thenAnswer(invocationOnMock -> this.mode);
        Mockito.when((Object)this.kieServer.getInfo()).thenReturn((Object)new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "", (Object)this.kieServerInfo));
        this.extension = new JbpmKieServerExtension(){
            {
                this.deploymentService = JbpmKieServerExtensionTest.this.deploymentService;
                this.runtimeDataService = JbpmKieServerExtensionTest.this.runtimeDataService;
                this.kieServer = JbpmKieServerExtensionTest.this.kieServer;
            }
        };
        Mockito.when((Object)this.deploymentService.isDeployed(Mockito.anyString())).thenAnswer(invocation -> this.deployed);
        ((DeploymentService)Mockito.doAnswer(invocation -> {
            this.deployed = false;
            return null;
        }).when((Object)this.deploymentService)).undeploy((DeploymentUnit)Mockito.any(), (Function)Mockito.any());
        ((DeploymentService)Mockito.doAnswer(invocation -> {
            this.deployed = false;
            return null;
        }).when((Object)this.deploymentService)).undeploy((DeploymentUnit)Mockito.any());
        ((DeploymentService)Mockito.doAnswer(invocation -> {
            this.deploymentUnit = (DeploymentUnit)invocation.getArguments()[0];
            this.deployed = true;
            return null;
        }).when((Object)this.deploymentService)).deploy((DeploymentUnit)Mockito.any());
        Mockito.when((Object)this.deploymentService.getDeployedUnit(Mockito.anyString())).thenAnswer(invocation -> {
            this.deployedUnit = new DeployedUnitImpl(this.deploymentUnit);
            this.runimeManager = (RuntimeManager)Mockito.mock(RuntimeManager.class);
            this.engine = (RuntimeEngine)Mockito.mock(RuntimeEngine.class);
            Mockito.when((Object)this.runimeManager.getRuntimeEngine((Context)Mockito.any())).thenReturn((Object)this.engine);
            this.session = (KieSession)Mockito.mock(KieSession.class);
            Mockito.when((Object)this.engine.getKieSession()).thenReturn((Object)this.session);
            this.deployedUnit.setRuntimeManager(this.runimeManager);
            return this.deployedUnit;
        });
        this.extension.setQueryService(this.queryService);
        this.extension.setContext(this.context);
        Mockito.when((Object)this.runtimeDataService.getProcessInstancesByDeploymentId(Mockito.anyString(), Mockito.anyList(), (QueryContext)Mockito.any())).thenReturn(this.activeProcessInstances);
    }

    @After
    public void clear() {
        this.kieServices.nullAllContainerIds();
    }

    @Test
    public void testCreateContainer() throws IOException {
        this.testDeployContainer(VERSION);
    }

    @Test
    public void testCreateSNAPSHOTContainer() throws IOException {
        this.testDeployContainer(VERSION_SNAPSHOT);
    }

    @Test
    public void testIsUpdateAllowedDevModeSNAPSHOT() throws IOException {
        this.testDeployContainer(VERSION_SNAPSHOT);
        this.mode = KieServerMode.DEVELOPMENT;
        Assert.assertTrue((boolean)this.extension.isUpdateContainerAllowed(CONTAINER_ID, (KieContainerInstance)new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED, this.kieContainer), new HashMap()));
    }

    @Test
    public void testIsUpdateAllowedDevModeNonSNAPSHOT() throws IOException {
        this.testDeployContainer(VERSION);
        this.mode = KieServerMode.DEVELOPMENT;
        Assert.assertTrue((boolean)this.extension.isUpdateContainerAllowed(CONTAINER_ID, (KieContainerInstance)new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED, this.kieContainer), new HashMap()));
    }

    @Test
    public void testIsUpdateAllowedProductionModeWithoutProcessInstances() throws IOException {
        this.testIsUpdateAllowed(false);
    }

    @Test
    public void testIsUpdateAllowedProductionModeWithProcessInstances() throws IOException {
        this.testIsUpdateAllowed(true);
    }

    @Test
    public void testLoadDefaultQueryDefinitions() {
        this.extension.registerDefaultQueryDefinitions();
        ((QueryService)Mockito.verify((Object)this.queryService, (VerificationMode)Mockito.times((int)10))).replaceQuery((QueryDefinition)Mockito.any());
    }

    @Test
    public void testUpdateContainerProductionMode() throws IOException {
        this.testUpdateContainer(KieServerMode.PRODUCTION, VERSION, false, false);
    }

    @Test
    public void testUpdateContainerProductionModeWithForcedCleanup() throws IOException {
        this.testUpdateContainer(KieServerMode.PRODUCTION, VERSION, true, false);
    }

    @Test
    public void testUpdateDevModeSNAPSHOTContainer() throws IOException {
        this.testUpdateContainer(KieServerMode.DEVELOPMENT, VERSION_SNAPSHOT, false, false);
    }

    @Test
    public void testUpdateDevModeSNAPSHOTContainerWithForcedCeanup() throws IOException {
        this.activeProcessInstances.add(this.mockProcessInstance());
        this.activeProcessInstances.add(this.mockProcessInstance());
        this.activeProcessInstances.add(this.mockProcessInstance());
        this.testUpdateContainer(KieServerMode.DEVELOPMENT, VERSION_SNAPSHOT, true, true);
    }

    @Test
    public void testUpdateDevModeNonSNAPSHOTContainer() throws IOException {
        this.testUpdateContainer(KieServerMode.DEVELOPMENT, VERSION, false, false);
    }

    @Test
    public void testUpdateDevModeNonSNAPSHOTContainerWithForcedCeanup() throws IOException {
        this.activeProcessInstances.add(this.mockProcessInstance());
        this.activeProcessInstances.add(this.mockProcessInstance());
        this.activeProcessInstances.add(this.mockProcessInstance());
        this.testUpdateContainer(KieServerMode.DEVELOPMENT, VERSION, true, true);
    }

    private ProcessInstanceDesc mockProcessInstance() {
        ProcessInstanceDesc instance = (ProcessInstanceDesc)Mockito.mock(ProcessInstanceDesc.class);
        Mockito.when((Object)instance.getId()).thenReturn((Object)new Long(1L));
        return instance;
    }

    private void testUpdateContainer(KieServerMode mode, String version, boolean cleanup, boolean expectedCleanup) throws IOException {
        this.mode = mode;
        this.testDeployContainer(version);
        KieModuleMetaData metaData = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.ReleaseId)new ReleaseId(GROUP_ID, ARTIFACT_ID, version), (DependencyFilter)DependencyFilter.COMPILE_FILTER);
        ArrayList messages = new ArrayList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("KieModuleMetaData", metaData);
        params.put("ContainerMessages", messages);
        params.put("KieServerResetBeforeUpdate", cleanup);
        this.extension.updateContainer(CONTAINER_ID, (KieContainerInstance)new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED, this.kieContainer), params);
        if (mode.equals((Object)KieServerMode.PRODUCTION)) {
            ((DeploymentService)Mockito.verify((Object)this.deploymentService)).undeploy((DeploymentUnit)Mockito.any());
        } else {
            ((DeploymentService)Mockito.verify((Object)this.deploymentService)).undeploy((DeploymentUnit)Mockito.any(), (Function)this.beforeUndeployCaptor.capture());
            Function function = (Function)this.beforeUndeployCaptor.getValue();
            Assert.assertNotNull((Object)function);
            Assert.assertTrue((boolean)((Boolean)function.apply(this.deploymentUnit)));
            if (expectedCleanup) {
                ((RuntimeDataService)Mockito.verify((Object)this.runtimeDataService)).getProcessInstancesByDeploymentId((String)Matchers.eq((Object)CONTAINER_ID), Mockito.anyList(), (QueryContext)Mockito.any());
                ((RuntimeManager)Mockito.verify((Object)this.runimeManager, (VerificationMode)Mockito.times((int)this.activeProcessInstances.size()))).getRuntimeEngine((Context)Mockito.any());
                ((RuntimeEngine)Mockito.verify((Object)this.engine, (VerificationMode)Mockito.times((int)this.activeProcessInstances.size()))).getKieSession();
                ((KieSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)this.activeProcessInstances.size()))).abortProcessInstance(((Long)Matchers.eq((Object)new Long(1L))).longValue());
                ((RuntimeManager)Mockito.verify((Object)this.runimeManager, (VerificationMode)Mockito.times((int)this.activeProcessInstances.size()))).disposeRuntimeEngine((RuntimeEngine)Mockito.any());
            } else {
                ((RuntimeDataService)Mockito.verify((Object)this.runtimeDataService, (VerificationMode)Mockito.never())).getProcessInstancesByDeploymentId((String)Matchers.eq((Object)CONTAINER_ID), Mockito.anyList(), (QueryContext)Mockito.any());
                ((RuntimeManager)Mockito.verify((Object)this.runimeManager, (VerificationMode)Mockito.never())).getRuntimeEngine((Context)Mockito.any());
                ((RuntimeEngine)Mockito.verify((Object)this.engine, (VerificationMode)Mockito.never())).getKieSession();
                ((KieSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).abortProcessInstance(((Long)Matchers.eq((Object)new Long(1L))).longValue());
                ((RuntimeManager)Mockito.verify((Object)this.runimeManager, (VerificationMode)Mockito.never())).disposeRuntimeEngine((RuntimeEngine)Mockito.any());
            }
        }
        ((DeploymentService)Mockito.verify((Object)this.deploymentService, (VerificationMode)Mockito.times((int)2))).deploy((DeploymentUnit)Mockito.any());
    }

    private void testDeployContainer(String version) throws IOException {
        this.createEmptyKjar(GROUP_ID, ARTIFACT_ID, version);
        ReleaseId releaseId = new ReleaseId(GROUP_ID, ARTIFACT_ID, version);
        this.kieContainer = (InternalKieContainer)this.kieServices.newKieContainer(CONTAINER_ID, (org.kie.api.builder.ReleaseId)releaseId);
        KieContainerInstanceImpl containerInstance = new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED, this.kieContainer);
        KieModuleMetaData metaData = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.ReleaseId)releaseId, (DependencyFilter)DependencyFilter.COMPILE_FILTER);
        ArrayList messages = new ArrayList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("KieModuleMetaData", metaData);
        params.put("ContainerMessages", messages);
        this.extension.createContainer(CONTAINER_ID, (KieContainerInstance)containerInstance, params);
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).deploy((DeploymentUnit)Mockito.any());
    }

    private void testIsUpdateAllowed(boolean existingInstances) throws IOException {
        this.mode = KieServerMode.PRODUCTION;
        ArrayList<Object> activeProcesses = new ArrayList<Object>();
        if (existingInstances) {
            activeProcesses.add(Mockito.mock(ProcessInstanceDesc.class));
            activeProcesses.add(Mockito.mock(ProcessInstanceDesc.class));
        }
        Mockito.when((Object)this.runtimeDataService.getProcessInstancesByDeploymentId(Mockito.anyString(), Mockito.anyList(), (QueryContext)Mockito.any())).thenReturn(activeProcesses);
        this.testDeployContainer(VERSION);
        if (existingInstances) {
            Assert.assertFalse((boolean)this.extension.isUpdateContainerAllowed(CONTAINER_ID, (KieContainerInstance)new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED, this.kieContainer), new HashMap()));
        } else {
            Assert.assertTrue((boolean)this.extension.isUpdateContainerAllowed(CONTAINER_ID, (KieContainerInstance)new KieContainerInstanceImpl(CONTAINER_ID, KieContainerStatus.STARTED, this.kieContainer), new HashMap()));
        }
    }

    private void createEmptyKjar(String groupId, String artifactId, String version) throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        org.kie.api.builder.ReleaseId releaseId = kieServices.newReleaseId(groupId, artifactId, version);
        kfs.generateAndWritePomXML(releaseId);
        String processContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/processes/hiring.bpmn2"), (Charset)Charset.defaultCharset());
        kfs.write("src/main/resources/hiring.bpmn2", processContent);
        KieModule kieModule = kieServices.newKieBuilder(kfs).buildAll().getKieModule();
        byte[] pom = kfs.read("pom.xml");
        byte[] jar = ((InternalKieModule)kieModule).getBytes();
        KieMavenRepository.getKieMavenRepository().installArtifact((AFReleaseId)releaseId, jar, pom);
    }
}

