/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.model.UserTaskInstanceDesc;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.server.api.model.instance.TaskAttachment;
import org.kie.server.api.model.instance.TaskAttachmentList;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskCommentList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.locator.ByTaskIdContainerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskServiceBase {
    public static final Logger logger = LoggerFactory.getLogger(UserTaskServiceBase.class);
    private IdentityProvider identityProvider;
    private UserTaskService userTaskService;
    private MarshallerHelper marshallerHelper;
    private boolean bypassAuthUser = false;

    public UserTaskServiceBase(UserTaskService userTaskService, KieServerRegistry context) {
        this.userTaskService = userTaskService;
        this.identityProvider = context.getIdentityProvider();
        this.marshallerHelper = new MarshallerHelper(context);
        this.bypassAuthUser = Boolean.parseBoolean(context.getConfig().getConfigItemValue("org.kie.server.bypass.auth.user", "false"));
    }

    protected String getUser(String queryParamUser) {
        if (this.bypassAuthUser) {
            return queryParamUser;
        }
        return this.identityProvider.getName();
    }

    public void activate(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to activate task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.activate(Long.valueOf(taskId.longValue()), userId);
    }

    public void claim(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to claim task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.claim(Long.valueOf(taskId.longValue()), userId);
    }

    public void complete(String containerId, Number taskId, String userId, String payload, String marshallerType) {
        userId = this.getUser(userId);
        logger.debug("About to unmarshal task outcome parameters from payload: '{}'", (Object)payload, (Object)new ByTaskIdContainerLocator(taskId.longValue()));
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallerType, Map.class);
        logger.debug("About to complete task with id '{}' as user '{}' with data {}", new Object[]{taskId, userId, parameters});
        this.userTaskService.complete(Long.valueOf(taskId.longValue()), userId, parameters);
    }

    public void completeAutoProgress(String containerId, Number taskId, String userId, String payload, String marshallerType) {
        userId = this.getUser(userId);
        logger.debug("About to unmarshal task outcome parameters from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallerType, Map.class, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        logger.debug("About to complete task with id '{}' as user '{}' with data {}", new Object[]{taskId, userId, parameters});
        this.userTaskService.completeAutoProgress(Long.valueOf(taskId.longValue()), userId, parameters);
    }

    public void delegate(String containerId, Number taskId, String userId, String targetUserId) {
        userId = this.getUser(userId);
        logger.debug("About to delegate task with id '{}' as user '{}' to user '{}'", new Object[]{taskId, userId, targetUserId});
        this.userTaskService.delegate(Long.valueOf(taskId.longValue()), userId, targetUserId);
    }

    public void exit(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to exit task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.exit(Long.valueOf(taskId.longValue()), userId);
    }

    public void fail(String containerId, Number taskId, String userId, String payload, String marshallerType) {
        userId = this.getUser(userId);
        logger.debug("About to unmarshal task failure data from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallerType, Map.class);
        logger.debug("About to fail task with id '{}' as user '{}' with data {}", new Object[]{taskId, userId, parameters});
        this.userTaskService.fail(Long.valueOf(taskId.longValue()), userId, parameters);
    }

    public void forward(String containerId, Number taskId, String userId, String targetUserId) {
        userId = this.getUser(userId);
        logger.debug("About to forward task with id '{}' as user '{}' to user '{}'", new Object[]{taskId, userId, targetUserId});
        this.userTaskService.forward(Long.valueOf(taskId.longValue()), userId, targetUserId);
    }

    public void release(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to release task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.release(Long.valueOf(taskId.longValue()), userId);
    }

    public void resume(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to resume task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.resume(Long.valueOf(taskId.longValue()), userId);
    }

    public void skip(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to skip task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.skip(Long.valueOf(taskId.longValue()), userId);
    }

    public void start(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to start task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.start(Long.valueOf(taskId.longValue()), userId);
    }

    public void stop(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to stop task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.stop(Long.valueOf(taskId.longValue()), userId);
    }

    public void suspend(String containerId, Number taskId, String userId) {
        userId = this.getUser(userId);
        logger.debug("About to suspend task with id '{}' as user '{}'", (Object)taskId, (Object)userId);
        this.userTaskService.suspend(Long.valueOf(taskId.longValue()), userId);
    }

    public void nominate(String containerId, Number taskId, String userId, List<String> potentialOwners) {
        userId = this.getUser(userId);
        logger.debug("About to nominate task with id '{}' as user '{}' to potential owners", new Object[]{taskId, userId, potentialOwners});
        ArrayList<User> potOwnerEntities = new ArrayList<User>();
        for (String potOwnerId : potentialOwners) {
            potOwnerEntities.add(TaskModelProvider.getFactory().newUser(potOwnerId));
        }
        this.userTaskService.nominate(Long.valueOf(taskId.longValue()), userId, potOwnerEntities);
    }

    public void setPriority(String containerId, Number taskId, String priorityPayload, String marshallingType) {
        logger.debug("About to unmarshal task priority from payload: '{}'", (Object)priorityPayload);
        Integer priority = (Integer)this.marshallerHelper.unmarshal(containerId, priorityPayload, marshallingType, Integer.class);
        logger.debug("About to set priority for a task with id '{}' with value '{}'", (Object)taskId, (Object)priority);
        this.userTaskService.setPriority(Long.valueOf(taskId.longValue()), priority.intValue());
    }

    public void setExpirationDate(String containerId, Number taskId, String datePayload, String marshallingType) {
        logger.debug("About to unmarshal task priority from payload: '{}'", (Object)datePayload);
        Date expirationDate = (Date)this.marshallerHelper.unmarshal(containerId, datePayload, marshallingType, Date.class);
        logger.debug("About to set expiration date for a task with id '{}' with value '{}'", (Object)taskId, (Object)expirationDate);
        this.userTaskService.setExpirationDate(Long.valueOf(taskId.longValue()), expirationDate);
    }

    public void setSkipable(String containerId, Number taskId, String skipablePayload, String marshallingType) {
        logger.debug("About to unmarshal task skipable from payload: '{}'", (Object)skipablePayload);
        Boolean skipable = (Boolean)this.marshallerHelper.unmarshal(containerId, skipablePayload, marshallingType, Boolean.class);
        logger.debug("About to set skipable attribute for a task with id '{}' with value '{}'", (Object)taskId, (Object)skipable);
        this.userTaskService.setSkipable(Long.valueOf(taskId.longValue()), skipable.booleanValue());
    }

    public void setName(String containerId, Number taskId, String namePayload, String marshallingType) {
        logger.debug("About to unmarshal task name from payload: '{}'", (Object)namePayload);
        String name = (String)this.marshallerHelper.unmarshal(containerId, namePayload, marshallingType, String.class);
        logger.debug("About to set name for a task with id '{}' with value '{}'", (Object)taskId, (Object)name);
        this.userTaskService.setName(Long.valueOf(taskId.longValue()), name);
    }

    public void setDescription(String containerId, Number taskId, String descriptionPayload, String marshallingType) {
        logger.debug("About to unmarshal task description from payload: '{}'", (Object)descriptionPayload);
        String description = (String)this.marshallerHelper.unmarshal(containerId, descriptionPayload, marshallingType, String.class);
        logger.debug("About to set name for a task with id '{}' with value '{}'", (Object)taskId, (Object)description);
        this.userTaskService.setDescription(Long.valueOf(taskId.longValue()), description);
    }

    public String saveContent(String containerId, Number taskId, String payload, String marshallingType) {
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        logger.debug("About to unmarshal task content parameters from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class, (ContainerLocator)locator);
        logger.debug("About to set content of a task with id '{}' with data {}", (Object)taskId, (Object)parameters);
        Long contentId = this.userTaskService.saveContent(Long.valueOf(taskId.longValue()), parameters);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)contentId, (ContainerLocator)locator);
        return response;
    }

    public String getTaskOutputContentByTaskId(String containerId, Number taskId, String marshallingType) {
        Map variables = this.userTaskService.getTaskOutputContentByTaskId(Long.valueOf(taskId.longValue()));
        logger.debug("About to marshal task '{}' output variables {}", (Object)taskId, (Object)variables);
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)variables, (ContainerLocator)locator);
        return response;
    }

    public String getTaskInputContentByTaskId(String containerId, Number taskId, String marshallingType) {
        Map variables = this.userTaskService.getTaskInputContentByTaskId(Long.valueOf(taskId.longValue()));
        logger.debug("About to marshal task '{}' input variables {}", (Object)taskId, (Object)variables);
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)variables, (ContainerLocator)locator);
        return response;
    }

    public void deleteContent(String containerId, Number taskId, Number contentId) {
        this.userTaskService.deleteContent(Long.valueOf(taskId.longValue()), Long.valueOf(contentId.longValue()));
    }

    public String addComment(String containerId, Number taskId, String payload, String marshallingType) {
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        logger.debug("About to unmarshal task comment from payload: '{}'", (Object)payload);
        TaskComment comment = (TaskComment)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, TaskComment.class, (ContainerLocator)locator);
        logger.debug("About to set comment on a task with id '{}' with data {}", (Object)taskId, (Object)comment);
        Long commentId = this.userTaskService.addComment(Long.valueOf(taskId.longValue()), comment.getText(), comment.getAddedBy(), comment.getAddedAt());
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)commentId, (ContainerLocator)locator);
        return response;
    }

    public void deleteComment(String containerId, Number taskId, Number commentId) {
        this.userTaskService.deleteComment(Long.valueOf(taskId.longValue()), Long.valueOf(commentId.longValue()));
    }

    public String getCommentsByTaskId(String containerId, Number taskId, String marshallingType) {
        List comments = this.userTaskService.getCommentsByTaskId(Long.valueOf(taskId.longValue()));
        TaskComment[] taskComments = new TaskComment[comments.size()];
        int counter = 0;
        for (Comment comment : comments) {
            TaskComment taskComment;
            taskComments[counter] = taskComment = TaskComment.builder().id(comment.getId()).text(comment.getText()).addedBy(comment.getAddedBy().getId()).addedAt(comment.getAddedAt()).build();
            ++counter;
        }
        TaskCommentList result = new TaskCommentList(taskComments);
        logger.debug("About to marshal task '{}' comments {}", (Object)taskId, (Object)result);
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)result, (ContainerLocator)locator);
        return response;
    }

    public String getCommentById(String containerId, Number taskId, Number commentId, String marshallingType) {
        Comment comment = this.userTaskService.getCommentById(Long.valueOf(taskId.longValue()), Long.valueOf(commentId.longValue()));
        if (comment == null) {
            throw new IllegalStateException("No comment found with id " + commentId + " on task " + taskId);
        }
        TaskComment taskComment = TaskComment.builder().id(comment.getId()).text(comment.getText()).addedBy(comment.getAddedBy().getId()).addedAt(comment.getAddedAt()).build();
        logger.debug("About to marshal task '{}' comment {}", (Object)taskId, (Object)taskComment);
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)taskComment, (ContainerLocator)locator);
        return response;
    }

    public String addAttachment(String containerId, Number taskId, String userId, String name, String attachmentPayload, String marshallingType) {
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        logger.debug("About to unmarshal task attachment from payload: '{}'", (Object)attachmentPayload);
        Object attachment = this.marshallerHelper.unmarshal(containerId, attachmentPayload, marshallingType, Object.class, (ContainerLocator)locator);
        logger.debug("About to add attachment on a task with id '{}' with data {}", (Object)taskId, attachment);
        Long attachmentId = this.userTaskService.addAttachment(Long.valueOf(taskId.longValue()), this.getUser(userId), name, attachment);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)attachmentId, (ContainerLocator)locator);
        return response;
    }

    public void deleteAttachment(String containerId, Number taskId, Number attachmentId) {
        this.userTaskService.deleteAttachment(Long.valueOf(taskId.longValue()), Long.valueOf(attachmentId.longValue()));
    }

    public String getAttachmentById(String containerId, Number taskId, Number attachmentId, String marshallingType) {
        Attachment attachment = this.userTaskService.getAttachmentById(Long.valueOf(taskId.longValue()), Long.valueOf(attachmentId.longValue()));
        TaskAttachment taskAttachment = TaskAttachment.builder().id(attachment.getId()).name(attachment.getName()).addedBy(attachment.getAttachedBy().getId()).addedAt(attachment.getAttachedAt()).attachmentContentId(Long.valueOf(attachment.getAttachmentContentId())).contentType(attachment.getContentType()).size(Integer.valueOf(attachment.getSize())).build();
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        logger.debug("About to marshal task '{}' attachment {} with content {}", new Object[]{taskId, attachmentId, taskAttachment});
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)taskAttachment, (ContainerLocator)locator);
        return response;
    }

    public String getAttachmentContentById(String containerId, Number taskId, Number attachmentId, String marshallingType) {
        Object attachment = this.userTaskService.getAttachmentContentById(Long.valueOf(taskId.longValue()), Long.valueOf(attachmentId.longValue()));
        if (attachment == null) {
            throw new IllegalStateException("No attachment found for id " + attachmentId + " for task " + taskId);
        }
        logger.debug("About to marshal task attachment with id '{}' {}", (Object)attachmentId, attachment);
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        String response = this.marshallerHelper.marshal(containerId, marshallingType, attachment, (ContainerLocator)locator);
        return response;
    }

    public String getAttachmentsByTaskId(String containerId, Number taskId, String marshallingType) {
        List attachments = this.userTaskService.getAttachmentsByTaskId(Long.valueOf(taskId.longValue()));
        TaskAttachment[] taskComments = new TaskAttachment[attachments.size()];
        int counter = 0;
        for (Attachment attachment : attachments) {
            TaskAttachment taskComment;
            taskComments[counter] = taskComment = TaskAttachment.builder().id(attachment.getId()).name(attachment.getName()).addedBy(attachment.getAttachedBy().getId()).addedAt(attachment.getAttachedAt()).contentType(attachment.getContentType()).attachmentContentId(Long.valueOf(attachment.getAttachmentContentId())).size(Integer.valueOf(attachment.getSize())).build();
            ++counter;
        }
        TaskAttachmentList result = new TaskAttachmentList(taskComments);
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        logger.debug("About to marshal task '{}' attachments {}", (Object)taskId, (Object)result);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)result, (ContainerLocator)locator);
        return response;
    }

    public String getTask(String containerId, Number taskId, boolean withInput, boolean withOutput, boolean withAssignments, String marshallingType) {
        Map variables;
        Task task = this.userTaskService.getTask(Long.valueOf(taskId.longValue()));
        if (task == null) {
            throw new TaskNotFoundException("No task found with id " + taskId);
        }
        TaskInstance.Builder builder = TaskInstance.builder();
        builder.id(task.getId()).name(task.getName()).subject(task.getSubject()).description(task.getDescription()).priority(task.getPriority()).taskType(task.getTaskType()).formName(((InternalTask)task).getFormName()).status(task.getTaskData().getStatus().name()).actualOwner(this.getOrgEntityIfNotNull((OrganizationalEntity)task.getTaskData().getActualOwner())).createdBy(this.getOrgEntityIfNotNull((OrganizationalEntity)task.getTaskData().getCreatedBy())).createdOn(task.getTaskData().getCreatedOn()).activationTime(task.getTaskData().getActivationTime()).expirationTime(task.getTaskData().getExpirationTime()).skippable(Boolean.valueOf(task.getTaskData().isSkipable())).workItemId(Long.valueOf(task.getTaskData().getWorkItemId())).processInstanceId(Long.valueOf(task.getTaskData().getProcessInstanceId())).parentId(Long.valueOf(task.getTaskData().getParentId())).processId(task.getTaskData().getProcessId()).containerId(task.getTaskData().getDeploymentId());
        if (Boolean.TRUE.equals(withInput)) {
            variables = this.userTaskService.getTaskInputContentByTaskId(Long.valueOf(taskId.longValue()));
            builder.inputData(variables);
        }
        if (Boolean.TRUE.equals(withOutput)) {
            variables = this.userTaskService.getTaskOutputContentByTaskId(Long.valueOf(taskId.longValue()));
            builder.outputData(variables);
        }
        if (Boolean.TRUE.equals(withAssignments)) {
            builder.potentialOwners(this.orgEntityAsList(task.getPeopleAssignments().getPotentialOwners()));
            builder.excludedOwners(this.orgEntityAsList(((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners()));
            builder.businessAdmins(this.orgEntityAsList(task.getPeopleAssignments().getBusinessAdministrators()));
        }
        TaskInstance taskInstance = builder.build();
        logger.debug("About to marshal task '{}' representation {}", (Object)taskId, (Object)taskInstance);
        ByTaskIdContainerLocator locator = new ByTaskIdContainerLocator(taskId.longValue());
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)taskInstance, (ContainerLocator)locator);
        return response;
    }

    public void update(String containerId, Number taskId, String userId, String payload, String marshallerType) {
        userId = this.getUser(userId);
        logger.debug("About to unmarshal task instances from payload: '{}'", (Object)payload, (Object)new ByTaskIdContainerLocator(taskId.longValue()));
        TaskInstance updatedTask = (TaskInstance)this.marshallerHelper.unmarshal(containerId, payload, marshallerType, TaskInstance.class);
        logger.debug("About to update task with id '{}' as user '{}' with data {}", new Object[]{taskId, userId, updatedTask});
        UserTaskInstanceDesc task = new UserTaskInstanceDesc(Long.valueOf(taskId.longValue()), updatedTask.getName(), updatedTask.getDescription(), updatedTask.getPriority(), updatedTask.getExpirationDate(), updatedTask.getFormName());
        this.userTaskService.updateTask(Long.valueOf(taskId.longValue()), userId, (org.jbpm.services.api.model.UserTaskInstanceDesc)task, updatedTask.getInputData(), updatedTask.getOutputData());
    }

    private String getOrgEntityIfNotNull(OrganizationalEntity organizationalEntity) {
        if (organizationalEntity == null) {
            return "";
        }
        return organizationalEntity.getId();
    }

    private List<String> orgEntityAsList(List<OrganizationalEntity> organizationalEntities) {
        ArrayList<String> entities = new ArrayList<String>();
        if (organizationalEntities == null) {
            return entities;
        }
        for (OrganizationalEntity entity : organizationalEntities) {
            entities.add(entity.getId());
        }
        return entities;
    }
}

