/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.locator;

import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieContainerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByTaskIdContainerLocator
implements ContainerLocator {
    private static final Logger logger = LoggerFactory.getLogger(ByTaskIdContainerLocator.class);
    private static final String CONTAINER_ID_QUERY = "select log.deploymentId from AuditTaskImpl log where log.taskId = :taskId";
    private Long taskId;
    private String containerId;

    public ByTaskIdContainerLocator(Long taskId) {
        this.taskId = taskId;
    }

    public String locateContainer(String alias, List<? extends KieContainerInstance> containerInstances) {
        if (this.containerId != null) {
            logger.debug("Container id has already be found for task {} and is {}", (Object)this.taskId, (Object)this.containerId);
            return this.containerId;
        }
        logger.debug("Searching for container id for task id {} and alias {}", (Object)this.taskId, (Object)alias);
        try (EntityManager em = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain").createEntityManager();){
            this.containerId = (String)em.createQuery(CONTAINER_ID_QUERY).setParameter("taskId", (Object)this.taskId).getSingleResult();
            logger.debug("Found container id '{}' for task id {}", (Object)this.containerId, (Object)this.taskId);
            String string = this.containerId;
            return string;
        }
    }
}

