/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.locator;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.jbpm.locator.ByContextMappingInfoContainerLocator;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ByContextMappingInfoContainerLocatorTest {
    private static final String CONTAINER_ID_QUERY = "select cmi.ownerId from ContextMappingInfo cmi where cmi.contextId = :piId";
    private static final String CONTAINER_ID = "containerId";
    @Mock
    private EntityManagerFactory entityManagerFactory;
    @Mock
    private EntityManager entityManager;
    @Mock
    private Query query;

    @Before
    public void setUp() {
        Mockito.reset((Object[])new Object[]{this.entityManagerFactory, this.entityManager, this.query});
        Mockito.when((Object)this.entityManagerFactory.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.entityManagerFactory.createEntityManager()).thenReturn((Object)this.entityManager);
        Mockito.when((Object)this.entityManager.createQuery(CONTAINER_ID_QUERY)).thenReturn((Object)this.query);
        Mockito.when((Object)this.query.setParameter(ArgumentMatchers.anyString(), ArgumentMatchers.any())).thenReturn((Object)this.query);
        Mockito.when((Object)this.query.getSingleResult()).thenReturn((Object)CONTAINER_ID);
        EntityManagerFactoryManager.get().clear();
    }

    @Test
    public void testLocateContainer() {
        EntityManagerFactoryManager.get().addEntityManagerFactory("org.jbpm.domain", this.entityManagerFactory);
        ContainerLocator locator = ByContextMappingInfoContainerLocator.Factory.get().create((Number)1L);
        String containerId = locator.locateContainer("alias", null);
        Assert.assertEquals((Object)CONTAINER_ID, (Object)containerId);
        ((Query)Mockito.verify((Object)this.query, (VerificationMode)Mockito.times((int)1))).getSingleResult();
    }

    @Test
    public void testQueryShouldBeExecutedOnes() {
        EntityManagerFactoryManager.get().addEntityManagerFactory("org.jbpm.domain", this.entityManagerFactory);
        ContainerLocator locator = ByContextMappingInfoContainerLocator.Factory.get().create((Number)1L);
        String containerId = locator.locateContainer("alias", null);
        Assert.assertEquals((Object)CONTAINER_ID, (Object)containerId);
        containerId = locator.locateContainer("alias", null);
        Assert.assertEquals((Object)CONTAINER_ID, (Object)containerId);
        ((Query)Mockito.verify((Object)this.query, (VerificationMode)Mockito.times((int)1))).getSingleResult();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoResultException() {
        Mockito.when((Object)this.query.getSingleResult()).thenThrow(NoResultException.class);
        EntityManagerFactoryManager.get().addEntityManagerFactory("org.jbpm.domain", this.entityManagerFactory);
        ContainerLocator locator = ByContextMappingInfoContainerLocator.Factory.get().create((Number)1L);
        locator.locateContainer("alias", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonUniqueResultException() {
        Mockito.when((Object)this.query.getSingleResult()).thenThrow(NonUniqueResultException.class);
        EntityManagerFactoryManager.get().addEntityManagerFactory("org.jbpm.domain", this.entityManagerFactory);
        ContainerLocator locator = ByContextMappingInfoContainerLocator.Factory.get().create((Number)1L);
        locator.locateContainer("alias", null);
    }
}

