/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.security;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.services.jbpm.security.ElytronUserGroupAdapter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.AuthorizationFailureException;

@RunWith(value=MockitoJUnitRunner.class)
public class ElytronUserGroupAdapterTest {
    private static final String USER_ID = "user";
    private static final String WRONG_USER_ID = "anotherUser";
    private static final String ROLE_1 = "role1";
    private static final String ROLE_2 = "role2";
    private static final String ROLE_3 = "role3";
    @Mock
    private ElytronUserGroupAdapter adapter;

    @Test
    public void testNoSecurityContext() {
        this.setAuthorizationFailureExceptionClass();
        PowerMockito.when((Object)this.adapter.isActive()).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getGroupsForUser(Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn(null);
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isEmpty();
    }

    @Test
    public void testSecurityContextNoIdentity() {
        this.setAuthorizationFailureExceptionClass();
        PowerMockito.when((Object)this.adapter.isActive()).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getGroupsForUser(Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)USER_ID);
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isEmpty();
    }

    @Test
    public void testSecurityForWrongUser() throws RealmUnavailableException {
        this.setAuthorizationFailureExceptionClass();
        PowerMockito.when((Object)this.adapter.isActive()).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getGroupsForUser(Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)USER_ID);
        PowerMockito.when((Object)this.adapter.runAsPrincipalExists(WRONG_USER_ID)).thenReturn((Object)true);
        PowerMockito.when((Object)this.adapter.toRunAsPrincipalRoles(WRONG_USER_ID, true)).thenReturn(Arrays.asList(ROLE_1, ROLE_2));
        List roles = this.adapter.getGroupsForUser(WRONG_USER_ID);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)roles).isNotNull()).hasSize(2)).contains((Object[])new String[]{ROLE_1, ROLE_2});
    }

    @Test
    public void testSecurityForLoggedUser() {
        this.setAuthorizationFailureExceptionClass();
        PowerMockito.when((Object)this.adapter.isActive()).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getGroupsForUser(Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)USER_ID);
        PowerMockito.when((Object)this.adapter.toPrincipalRoles(Mockito.anyString())).thenReturn(Arrays.asList(ROLE_1, ROLE_2, ROLE_3));
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)roles).isNotNull()).hasSize(3)).contains((Object[])new String[]{ROLE_1, ROLE_2, ROLE_3});
    }

    @Test
    public void testSecurityOnRealmUnavailable() throws RealmUnavailableException {
        this.setAuthorizationFailureExceptionClass();
        PowerMockito.when((Object)this.adapter.isActive()).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getGroupsForUser(Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)WRONG_USER_ID);
        PowerMockito.when((Object)this.adapter.runAsPrincipalExists(USER_ID)).thenThrow(new Throwable[]{new RealmUnavailableException()});
        Mockito.lenient().when((Object)this.adapter.toPrincipalRoles(Mockito.anyString())).thenReturn(Arrays.asList(ROLE_1, ROLE_2, ROLE_3));
        Mockito.lenient().when((Object)this.adapter.toRunAsPrincipalRoles(Mockito.anyString(), Mockito.eq((boolean)false))).thenReturn(Arrays.asList(ROLE_1, ROLE_2, ROLE_3));
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isEmpty();
    }

    @Test
    public void testSecurityOnAuthorizationFailure() throws AuthorizationFailureException, RealmUnavailableException {
        this.setAuthorizationFailureExceptionClass();
        PowerMockito.when((Object)this.adapter.isActive()).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getGroupsForUser(Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)WRONG_USER_ID);
        PowerMockito.when((Object)this.adapter.runAsPrincipalExists(USER_ID)).thenThrow(AuthorizationFailureException.class);
        PowerMockito.when((Object)this.adapter.toRunAsPrincipalRoles(Mockito.anyString(), Mockito.eq((boolean)false))).thenReturn(Arrays.asList(ROLE_1, ROLE_2, ROLE_3));
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)roles).isNotNull()).hasSize(3)).contains((Object[])new String[]{ROLE_1, ROLE_2, ROLE_3});
    }

    @Test
    public void testSecurityElytronDisabled() throws RealmUnavailableException {
        PowerMockito.when((Object)this.adapter.isActive()).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getGroupsForUser(Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)USER_ID);
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isEmpty();
    }

    @Test
    public void testToRolesWithEmptySecurityIdentity() {
        List roles = this.adapter.toRoles(null);
        ((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isEmpty();
    }

    private void setAuthorizationFailureExceptionClass() {
        Whitebox.setInternalState((Object)this.adapter, Class.class, AuthorizationFailureException.class);
    }
}

