/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.services.api.AdvanceRuntimeDataService;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.VariableDesc;
import org.jbpm.services.api.query.model.QueryParam;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.internal.KieInternalServices;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.server.api.model.definition.CountDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.definition.SearchQueryFilterSpec;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceCustomVarsList;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.ProcessInstanceUserTaskWithVariablesList;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDataServiceBase {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeDataServiceBase.class);
    private AdvanceRuntimeDataService advanceRuntimeDataService;
    private RuntimeDataService runtimeDataService;
    private IdentityProvider identityProvider;
    private KieServerRegistry context;
    private boolean bypassAuthUser;
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private MarshallerHelper marshallerHelper;

    public RuntimeDataServiceBase(RuntimeDataService delegate, AdvanceRuntimeDataService advanceRuntimeDataService, KieServerRegistry context) {
        this.runtimeDataService = delegate;
        this.advanceRuntimeDataService = advanceRuntimeDataService;
        this.identityProvider = context.getIdentityProvider();
        this.context = context;
        this.marshallerHelper = new MarshallerHelper(context);
        this.bypassAuthUser = Boolean.parseBoolean(context.getConfig().getConfigItemValue("org.kie.server.bypass.auth.user", "false"));
    }

    protected String getUser(String queryParamUser) {
        if (this.bypassAuthUser) {
            if (queryParamUser == null || queryParamUser.isEmpty()) {
                return this.identityProvider.getName();
            }
            return queryParamUser;
        }
        return this.identityProvider.getName();
    }

    public ProcessInstanceList getProcessInstances(List<Integer> status, String initiator, String processName, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        if (sort == null || sort.isEmpty()) {
            sort = "ProcessInstanceId";
        }
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Integer>();
            status.add(1);
        }
        Collection instances = null;
        if (processName != null && !processName.isEmpty()) {
            logger.debug("About to search for process instances with process name '{}' with page {} and page size {}", new Object[]{processName, page, pageSize});
            instances = this.runtimeDataService.getProcessInstancesByProcessName(status, processName, ConvertUtils.nullEmpty(initiator), ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} process instances for process name '{}', statuses '{}'", new Object[]{instances.size(), processName, status});
        } else {
            logger.debug("About to search for process instances with page {} and page size {}", (Object)page, (Object)pageSize);
            instances = this.runtimeDataService.getProcessInstances(status, ConvertUtils.nullEmpty(initiator), ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} process instances , statuses '{}'", (Object)instances.size(), status);
        }
        ProcessInstanceList processInstanceList = ConvertUtils.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return processInstanceList;
    }

    public ProcessInstanceList getProcessInstancesByProcessId(String processId, List<Integer> status, String initiator, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        if (sort == null || sort.isEmpty()) {
            sort = "ProcessInstanceId";
        }
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Integer>();
            status.add(1);
        }
        logger.debug("About to search for process instances with process id '{}' with page {} and page size {}", new Object[]{processId, page, pageSize});
        Collection instances = this.runtimeDataService.getProcessInstancesByProcessId(status, processId, ConvertUtils.nullEmpty(initiator), ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        logger.debug("Found {} process instance for process id '{}', statuses '{}'", new Object[]{instances.size(), processId, status});
        ProcessInstanceList processInstanceList = ConvertUtils.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return processInstanceList;
    }

    public ProcessInstanceList getProcessInstancesByDeploymentId(String containerId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        if (sort == null || sort.isEmpty()) {
            sort = "ProcessInstanceId";
        }
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Integer>();
            status.add(1);
        }
        logger.debug("About to search for process instance belonging to container '{}' with page {} and page size {}", new Object[]{containerId, page, pageSize});
        Collection instances = this.runtimeDataService.getProcessInstancesByDeploymentId(containerId, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        logger.debug("Found {} process instance for container '{}', statuses '{}'", new Object[]{instances.size(), containerId, status});
        ProcessInstanceList processInstanceList = ConvertUtils.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return processInstanceList;
    }

    public CountDefinition countProcessInstancesByDeploymentId(String containerId, List<Integer> status) {
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Integer>();
            status.add(1);
        }
        logger.debug("About to search for process instance belonging to container '{}'", (Object)containerId);
        Long instances = this.runtimeDataService.countProcessInstancesByDeploymentId(containerId, status);
        logger.debug("Found {} process instance for container '{}', statuses '{}'", new Object[]{instances, containerId, status});
        return new CountDefinition(instances);
    }

    public ProcessInstanceList getProcessInstancesByCorrelationKey(String correlationKey, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        if (sort == null || sort.isEmpty()) {
            sort = "ProcessInstanceId";
        }
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        Collection instances = this.runtimeDataService.getProcessInstancesByCorrelationKey(actualCorrelationKey, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        ProcessInstanceList processInstanceList = ConvertUtils.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return processInstanceList;
    }

    public ProcessInstance getProcessInstanceByCorrelationKey(String correlationKey) {
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceByCorrelationKey(actualCorrelationKey);
        ProcessInstance processInstanceList = ConvertUtils.convertToProcessInstance(instance);
        logger.debug("Returning result of process instance search: {}", (Object)instance);
        return processInstanceList;
    }

    public ProcessInstanceList getProcessInstanceByVariables(String variableName, String variableValue, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        if (sort == null || sort.isEmpty()) {
            sort = "ProcessInstanceId";
        }
        Collection instances = null;
        if (variableValue != null && !variableValue.isEmpty()) {
            logger.debug("About to search for process instance that has variable '{}' with value '{}' with page {} and page size {}", new Object[]{variableName, variableValue, page, pageSize});
            instances = this.runtimeDataService.getProcessInstancesByVariableAndValue(variableName, variableValue, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} process instance with variable {} and variable value {}", new Object[]{instances.size(), variableName, variableValue});
        } else {
            logger.debug("About to search for process instance that has variable '{}' with page {} and page size {}", new Object[]{variableName, page, pageSize});
            instances = this.runtimeDataService.getProcessInstancesByVariable(variableName, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} process instance with variable {} ", (Object)instances.size(), (Object)variableName);
        }
        ProcessInstanceList processInstanceList = ConvertUtils.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return processInstanceList;
    }

    public ProcessInstance getProcessInstanceById(long processInstanceId) {
        return this.getProcessInstanceById(processInstanceId, false);
    }

    public ProcessInstance getProcessInstanceById(long processInstanceId, boolean withVars) {
        ProcessInstanceDesc processInstanceDesc = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (processInstanceDesc == null) {
            throw new ProcessInstanceNotFoundException("Could not find process instance with id " + processInstanceId);
        }
        ProcessInstance processInstance = ConvertUtils.convertToProcessInstance(processInstanceDesc);
        if (Boolean.TRUE.equals(withVars)) {
            Collection variableDescs = this.runtimeDataService.getVariablesCurrentState(processInstanceId);
            HashMap<String, String> vars = new HashMap<String, String>();
            for (VariableDesc var : variableDescs) {
                vars.put(var.getVariableId(), var.getNewValue());
            }
            processInstance.setVariables(vars);
        }
        return processInstance;
    }

    public NodeInstance getNodeInstanceForWorkItem(long processInstanceId, long workItemId) {
        NodeInstanceDesc nodeInstanceDesc = this.runtimeDataService.getNodeInstanceForWorkItem(Long.valueOf(workItemId));
        if (nodeInstanceDesc == null) {
            throw new IllegalArgumentException("Could not find node instance with id \"" + workItemId + "\" within process instance with id \"" + processInstanceId + "\"");
        }
        return ConvertUtils.convertToNodeInstance(nodeInstanceDesc);
    }

    public NodeInstanceList getProcessInstanceHistory(long processInstanceId, Boolean active, Boolean completed, Integer page, Integer pageSize) {
        logger.debug("About to search for node instances with page {} and page size {}", (Object)page, (Object)pageSize);
        Collection result = null;
        if (Boolean.TRUE.equals(active) && Boolean.TRUE.equals(completed) || active == null && completed == null) {
            logger.debug("Searching for active and completed node instances for process instance with id {}", (Object)processInstanceId);
            result = this.runtimeDataService.getProcessInstanceFullHistory(processInstanceId, ConvertUtils.buildQueryContext(page, pageSize));
        } else if (Boolean.TRUE.equals(active)) {
            logger.debug("Searching for active node instances for process instance with id {}", (Object)processInstanceId);
            result = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, ConvertUtils.buildQueryContext(page, pageSize));
        } else if (Boolean.TRUE.equals(completed)) {
            logger.debug("Searching for completed node instances for process instance with id {}", (Object)processInstanceId);
            result = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstanceId, ConvertUtils.buildQueryContext(page, pageSize));
        }
        NodeInstanceList nodeInstanceList = ConvertUtils.convertToNodeInstanceList(result);
        logger.debug("Returning result of node instances search: {}", (Object)nodeInstanceList);
        return nodeInstanceList;
    }

    public NodeInstanceList getProcessInstanceFullHistoryByType(long processInstanceId, String entryType, Integer page, Integer pageSize) {
        logger.debug("About to search for node instances with page {} and page size {}", (Object)page, (Object)pageSize);
        Collection result = null;
        result = this.runtimeDataService.getProcessInstanceFullHistoryByType(processInstanceId, RuntimeDataService.EntryType.valueOf((String)entryType), ConvertUtils.buildQueryContext(page, pageSize));
        return ConvertUtils.convertToNodeInstanceList(result);
    }

    public VariableInstanceList getVariablesCurrentState(long processInstanceId) {
        logger.debug("About to search for variables within process instance  '{}'", (Object)processInstanceId);
        Collection variableDescs = this.runtimeDataService.getVariablesCurrentState(processInstanceId);
        logger.debug("Found {} variables within process instance '{}'", (Object)variableDescs.size(), (Object)processInstanceId);
        VariableInstanceList variableInstanceList = ConvertUtils.convertToVariablesList(variableDescs);
        logger.debug("Returning result of variables search: {}", (Object)variableInstanceList);
        return variableInstanceList;
    }

    public VariableInstanceList getVariableHistory(long processInstanceId, String variableName, Integer page, Integer pageSize) {
        logger.debug("About to search for variable '{}; history within process instance '{}' with page {} and page size {}", new Object[]{variableName, processInstanceId, page, pageSize});
        Collection variableDescs = this.runtimeDataService.getVariableHistory(processInstanceId, variableName, ConvertUtils.buildQueryContext(page, pageSize));
        logger.debug("Found {} variable {} history entries within process instance '{}'", new Object[]{variableDescs.size(), variableName, processInstanceId});
        VariableInstanceList variableInstanceList = ConvertUtils.convertToVariablesList(variableDescs);
        logger.debug("Returning result of variable '{}; history search: {}", (Object)variableName, (Object)variableInstanceList);
        return variableInstanceList;
    }

    public ProcessDefinitionList getProcessesByDeploymentId(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        try {
            return this.getProcessesByDeploymentIdUncatch(containerId, page, pageSize, sort, sortOrder);
        }
        catch (IllegalArgumentException | DeploymentNotFoundException e) {
            return new ProcessDefinitionList();
        }
    }

    public ProcessDefinitionList getProcessesByDeploymentIdCheckContainer(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        try {
            return this.getProcessesByDeploymentIdUncatch(containerId, page, pageSize, sort, sortOrder);
        }
        catch (IllegalArgumentException e) {
            throw new DeploymentNotFoundException(containerId + " not found");
        }
    }

    private ProcessDefinitionList getProcessesByDeploymentIdUncatch(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        logger.debug("About to search for process definitions within container '{}' with page {} and page size {}", new Object[]{containerId, page, pageSize});
        if (sort == null || sort.isEmpty()) {
            sort = "ProcessName";
        }
        Collection definitions = this.runtimeDataService.getProcessesByDeploymentId(containerId, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        logger.debug("Found {} process definitions within container '{}'", (Object)definitions.size(), (Object)containerId);
        ProcessDefinitionList processDefinitionList = ConvertUtils.convertToProcessList(definitions);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return processDefinitionList;
    }

    public ProcessDefinitionList getProcessesByFilter(String filter, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection definitions;
        if (sort == null || sort.isEmpty()) {
            sort = "ProcessName";
        }
        if (filter != null && !filter.isEmpty()) {
            logger.debug("About to search for process definitions with filter '{}' with page {} and page size {}", new Object[]{filter, page, pageSize});
            definitions = this.runtimeDataService.getProcessesByFilter(filter, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} process definitions with filter '{}'", (Object)definitions.size(), (Object)filter);
        } else {
            logger.debug("About to search for process definitions with page {} and page size {}", (Object)page, (Object)pageSize);
            definitions = this.runtimeDataService.getProcesses(ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} process definitions", (Object)definitions.size(), (Object)filter);
        }
        ProcessDefinitionList processDefinitionList = ConvertUtils.convertToProcessList(definitions);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return processDefinitionList;
    }

    public ProcessDefinitionList getProcessesById(String processId) {
        Collection definitions = this.runtimeDataService.getProcessesById(processId);
        ProcessDefinitionList processDefinitionList = ConvertUtils.convertToProcessList(definitions);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return processDefinitionList;
    }

    public org.kie.server.api.model.definition.ProcessDefinition getProcessesByDeploymentIdProcessId(String containerId, String processId) {
        ProcessDefinition processDesc = this.runtimeDataService.getProcessesByDeploymentIdProcessId(containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator()), processId);
        if (processDesc == null) {
            throw new IllegalArgumentException("Could not find process definition \"" + processId + "\" in container \"" + containerId + "\"");
        }
        return ConvertUtils.convertToProcess(processDesc);
    }

    public TaskInstance getTaskByWorkItemId(long workItemId) {
        UserTaskInstanceDesc userTaskDesc = this.runtimeDataService.getTaskByWorkItemId(Long.valueOf(workItemId));
        if (userTaskDesc == null) {
            throw new TaskNotFoundException("No task found with work item id " + workItemId);
        }
        return ConvertUtils.convertToTask(userTaskDesc);
    }

    public TaskInstance getTaskById(long taskId) {
        return this.getTaskById(taskId, false);
    }

    public TaskInstance getTaskById(long taskId, boolean withSLA) {
        UserTaskInstanceDesc userTaskDesc = this.runtimeDataService.getTaskById(Long.valueOf(taskId), withSLA);
        if (userTaskDesc == null) {
            throw new TaskNotFoundException("No task found with id " + taskId);
        }
        return ConvertUtils.convertToTask(userTaskDesc);
    }

    public TaskSummaryList getTasksAssignedAsBusinessAdministratorByStatus(List<String> status, String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List tasks;
        userId = this.getUser(userId);
        logger.debug("About to search for task assigned as business admin for user '{}'", (Object)userId);
        if (status == null || status.isEmpty()) {
            tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator(userId, ConvertUtils.buildQueryFilter(page, pageSize, sort, sortOrder));
        } else {
            List<Status> taskStatuses = ConvertUtils.buildTaskStatuses(status);
            tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministratorByStatus(userId, taskStatuses, ConvertUtils.buildQueryFilter(page, pageSize, sort, sortOrder));
        }
        logger.debug("Found {} tasks for user '{}' assigned as business admin", (Object)tasks.size(), (Object)userId);
        TaskSummaryList result = ConvertUtils.convertToTaskSummaryList(tasks);
        return result;
    }

    public TaskSummaryList getTasksAssignedAsPotentialOwner(List<String> status, List<String> groupIds, String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        return this.getTasksAssignedAsPotentialOwner(status, groupIds, userId, page, pageSize, sort, sortOrder, null);
    }

    public TaskSummaryList getTasksAssignedAsPotentialOwner(List<String> status, List<String> groupIds, String userId, Integer page, Integer pageSize, String sort, boolean sortOrder, String filter) {
        List<Status> taskStatuses = ConvertUtils.buildTaskStatuses(status);
        userId = this.getUser(userId);
        logger.debug("About to search for task assigned as potential owner for user '{}'", (Object)userId);
        QueryFilter queryFilter = ConvertUtils.buildTaskByNameQueryFilter(page, pageSize, sort, sortOrder, filter);
        List tasks = groupIds != null && !groupIds.isEmpty() ? (taskStatuses == null ? this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, groupIds, queryFilter) : this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, groupIds, taskStatuses, queryFilter)) : (taskStatuses != null ? this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus(userId, taskStatuses, queryFilter) : this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, queryFilter));
        logger.debug("Found {} tasks for user '{}' assigned as potential owner", (Object)tasks.size(), (Object)userId);
        TaskSummaryList result = ConvertUtils.convertToTaskSummaryList(tasks);
        return result;
    }

    public TaskSummaryList getTasksOwnedByStatus(List<String> status, String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> taskStatuses = ConvertUtils.buildTaskStatuses(status);
        userId = this.getUser(userId);
        logger.debug("About to search for task owned user '{}'", (Object)userId);
        List tasks = taskStatuses != null ? this.runtimeDataService.getTasksOwnedByStatus(userId, taskStatuses, ConvertUtils.buildQueryFilter(page, pageSize, sort, sortOrder)) : this.runtimeDataService.getTasksOwned(userId, ConvertUtils.buildQueryFilter(page, pageSize, sort, sortOrder));
        logger.debug("Found {} tasks owned by user '{}'", (Object)tasks.size(), (Object)userId);
        TaskSummaryList result = ConvertUtils.convertToTaskSummaryList(tasks);
        return result;
    }

    public TaskSummaryList getTasksByStatusByProcessInstanceId(Number processInstanceId, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> taskStatuses = ConvertUtils.buildTaskStatuses(status);
        if (taskStatuses == null) {
            taskStatuses = new ArrayList<Status>();
            taskStatuses.add(Status.Ready);
            taskStatuses.add(Status.Reserved);
            taskStatuses.add(Status.InProgress);
        }
        logger.debug("About to search for tasks attached to process instance with id '{}'", (Object)processInstanceId);
        List tasks = this.runtimeDataService.getTasksByStatusByProcessInstanceId(Long.valueOf(processInstanceId.longValue()), taskStatuses, ConvertUtils.buildQueryFilter(page, pageSize, sort, sortOrder));
        logger.debug("Found {} tasks attached to process instance with id '{}'", (Object)tasks.size(), (Object)processInstanceId);
        TaskSummaryList result = ConvertUtils.convertToTaskSummaryList(tasks);
        return result;
    }

    public TaskSummaryList getAllAuditTask(String userId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        userId = this.getUser(userId);
        logger.debug("About to search for tasks available for user '{}'", (Object)userId);
        List tasks = this.runtimeDataService.getAllAuditTask(userId, ConvertUtils.buildQueryFilter(page, pageSize, sort, sortOrder));
        logger.debug("Found {} tasks available for user '{}'", (Object)tasks.size(), (Object)userId);
        TaskSummaryList result = null;
        if (tasks == null) {
            result = new TaskSummaryList(new TaskSummary[0]);
        } else {
            TaskSummary[] instances = new TaskSummary[tasks.size()];
            int counter = 0;
            for (AuditTask taskSummary : tasks) {
                TaskSummary task;
                instances[counter] = task = TaskSummary.builder().id(Long.valueOf(taskSummary.getTaskId())).name(taskSummary.getName()).description(taskSummary.getDescription()).taskParentId(Long.valueOf(taskSummary.getParentId())).activationTime(taskSummary.getActivationTime()).actualOwner(taskSummary.getActualOwner()).containerId(taskSummary.getDeploymentId()).createdBy(taskSummary.getCreatedBy()).createdOn(taskSummary.getCreatedOn()).expirationTime(taskSummary.getDueDate()).priority(Integer.valueOf(taskSummary.getPriority())).processId(taskSummary.getProcessId()).processInstanceId(Long.valueOf(taskSummary.getProcessInstanceId())).status(taskSummary.getStatus()).build();
                ++counter;
            }
            result = new TaskSummaryList(instances);
        }
        return result;
    }

    public TaskEventInstanceList getTaskEvents(long taskId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        if (sort == null || sort.isEmpty()) {
            sort = "Id";
        }
        logger.debug("About to search for task {} events", (Object)taskId);
        List tasks = this.runtimeDataService.getTaskEvents(taskId, ConvertUtils.buildQueryFilter(page, pageSize, sort, sortOrder));
        logger.debug("Found {} task events available for task '{}'", (Object)tasks.size(), (Object)taskId);
        TaskEventInstanceList result = null;
        if (tasks == null) {
            result = new TaskEventInstanceList(new TaskEventInstance[0]);
        } else {
            TaskEventInstance[] instances = new TaskEventInstance[tasks.size()];
            int counter = 0;
            for (TaskEvent taskSummary : tasks) {
                TaskEventInstance task;
                instances[counter] = task = TaskEventInstance.builder().id(Long.valueOf(taskSummary.getTaskId())).taskId(Long.valueOf(taskSummary.getTaskId())).date(taskSummary.getLogTime()).processInstanceId(taskSummary.getProcessInstanceId()).type(taskSummary.getType().toString()).user(taskSummary.getUserId()).workItemId(taskSummary.getWorkItemId()).message(taskSummary.getMessage()).correlationKey(taskSummary.getCorrelationKey()).processType(taskSummary.getProcessType()).assignedOwner(taskSummary.getCurrentOwner()).build();
                ++counter;
            }
            result = new TaskEventInstanceList(instances);
        }
        return result;
    }

    public TaskSummaryList getTasksByVariables(String userId, String variableName, String variableValue, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        userId = this.getUser(userId);
        List<Status> taskStatuses = ConvertUtils.buildTaskStatuses(status);
        if (taskStatuses == null) {
            taskStatuses = new ArrayList<Status>();
            taskStatuses.add(Status.Ready);
            taskStatuses.add(Status.Reserved);
            taskStatuses.add(Status.InProgress);
        }
        List instances = null;
        if (variableValue != null && !variableValue.isEmpty()) {
            logger.debug("About to search for tasks that has variable '{}' with value '{}' with page {} and page size {}", new Object[]{variableName, variableValue, page, pageSize});
            instances = this.runtimeDataService.getTasksByVariableAndValue(userId, variableName, variableValue, taskStatuses, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} tasks with variable {} and variable value {}", new Object[]{instances.size(), variableName, variableValue});
        } else {
            logger.debug("About to search for tasks that has variable '{}' with page {} and page size {}", new Object[]{variableName, page, pageSize});
            instances = this.runtimeDataService.getTasksByVariable(userId, variableName, taskStatuses, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            logger.debug("Found {} tasks with variable {} ", (Object)instances.size(), (Object)variableName);
        }
        TaskSummaryList taskSummaryList = ConvertUtils.convertToTaskSummaryList(instances);
        logger.debug("Returning result of task by variable search: {}", (Object)taskSummaryList);
        return taskSummaryList;
    }

    public ProcessInstanceCustomVarsList queryProcessesByVariables(String payload, String payloadType, QueryContext queryContext) {
        SearchQueryFilterSpec filter = new SearchQueryFilterSpec();
        if (payload != null) {
            filter = (SearchQueryFilterSpec)this.marshallerHelper.unmarshal(payload, payloadType, SearchQueryFilterSpec.class);
        }
        List params = filter.getAttributesQueryParams().stream().map(e -> e.getColumn()).collect(Collectors.toList());
        params.removeAll(Arrays.asList("TASK_NAME", "TASK_OWNER", "TASK_STATUS"));
        if (params.size() == filter.getAttributesQueryParams().size() && filter.getTaskVariablesQueryParams().isEmpty()) {
            return ConvertUtils.convertToProcessInstanceCustomVarsList(this.advanceRuntimeDataService.queryProcessByVariables(ConvertUtils.convertToServiceApiQueryParam(filter.getAttributesQueryParams()), ConvertUtils.convertToServiceApiQueryParam(filter.getProcessVariablesQueryParams()), queryContext));
        }
        return ConvertUtils.convertToProcessInstanceCustomVarsList(this.advanceRuntimeDataService.queryProcessByVariablesAndTask(ConvertUtils.convertToServiceApiQueryParam(filter.getAttributesQueryParams()), ConvertUtils.convertToServiceApiQueryParam(filter.getProcessVariablesQueryParams()), ConvertUtils.convertToServiceApiQueryParam(filter.getTaskVariablesQueryParams()), this.getOwnersQueryParam(filter), queryContext));
    }

    public ProcessInstanceUserTaskWithVariablesList queryUserTasksByVariables(String payload, String payloadType, QueryContext queryContext) {
        SearchQueryFilterSpec filter = new SearchQueryFilterSpec();
        if (payload != null) {
            filter = (SearchQueryFilterSpec)this.marshallerHelper.unmarshal(payload, payloadType, SearchQueryFilterSpec.class);
        }
        return ConvertUtils.convertToUserTaskWithVariablesList(this.advanceRuntimeDataService.queryUserTasksByVariables(ConvertUtils.convertToServiceApiQueryParam(filter.getAttributesQueryParams()), ConvertUtils.convertToServiceApiQueryParam(filter.getTaskVariablesQueryParams()), ConvertUtils.convertToServiceApiQueryParam(filter.getProcessVariablesQueryParams()), this.getOwnersQueryParam(filter), queryContext));
    }

    private QueryParam getOwnersQueryParam(SearchQueryFilterSpec filter) {
        if (filter.getOwnersQueryParam() != null) {
            return ConvertUtils.convertToServiceApiQueryParam(filter.getOwnersQueryParam());
        }
        if (filter.getOwners() == null || filter.getOwners().isEmpty()) {
            return null;
        }
        return QueryParam.all((List)filter.getOwners());
    }
}

