/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.drools.core.impl.InternalKieContainer;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.kie.services.impl.AbstractDeploymentService;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.FormManagerServiceImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.ProcessServiceImpl;
import org.jbpm.kie.services.impl.RuntimeDataServiceImpl;
import org.jbpm.kie.services.impl.UserTaskServiceImpl;
import org.jbpm.kie.services.impl.admin.ProcessInstanceAdminServiceImpl;
import org.jbpm.kie.services.impl.admin.ProcessInstanceMigrationServiceImpl;
import org.jbpm.kie.services.impl.admin.UserTaskAdminServiceImpl;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceImpl;
import org.jbpm.kie.services.impl.query.QueryServiceImpl;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.admin.UserTaskAdminService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.query.QueryMapperRegistry;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.TaskAuditServiceFactory;
import org.jbpm.services.task.identity.JAASUserGroupCallbackImpl;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.task.api.UserInfo;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieSessionLookupHandler;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.jbpm.DefinitionServiceBase;
import org.kie.server.services.jbpm.DocumentServiceBase;
import org.kie.server.services.jbpm.ExecutorServiceBase;
import org.kie.server.services.jbpm.JBPMKieContainerCommandServiceImpl;
import org.kie.server.services.jbpm.JBPMKieSessionLookupHandler;
import org.kie.server.services.jbpm.ProcessServiceBase;
import org.kie.server.services.jbpm.QueryDataServiceBase;
import org.kie.server.services.jbpm.QueryParamBuilderManager;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.kie.server.services.jbpm.UserTaskServiceBase;
import org.kie.server.services.jbpm.admin.ProcessAdminServiceBase;
import org.kie.server.services.jbpm.admin.UserTaskAdminServiceBase;
import org.kie.server.services.jbpm.jpa.PersistenceUnitInfoImpl;
import org.kie.server.services.jbpm.jpa.PersistenceUnitInfoLoader;
import org.kie.server.services.jbpm.security.JMSUserGroupAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "jBPM";
    private static final String PERSISTENCE_XML_LOCATION = "/jpa/META-INF/persistence.xml";
    private static final Logger logger = LoggerFactory.getLogger(JbpmKieServerExtension.class);
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.jbpm.server.ext.disabled", "false"));
    protected boolean isExecutorAvailable = false;
    protected String persistenceUnitName = "org.jbpm.domain";
    protected KieServerImpl kieServer;
    protected KieServerRegistry context;
    protected DeploymentService deploymentService;
    protected DefinitionService definitionService;
    protected ProcessService processService;
    protected UserTaskService userTaskService;
    protected RuntimeDataService runtimeDataService;
    protected FormManagerService formManagerService;
    protected ProcessInstanceMigrationService processInstanceMigrationService;
    protected ProcessInstanceAdminService processInstanceAdminService;
    protected UserTaskAdminService userTaskAdminService;
    protected ExecutorService executorService;
    protected QueryService queryService;
    protected KieContainerCommandService kieContainerCommandService;
    protected DeploymentDescriptorManager deploymentDescriptorManager = new DeploymentDescriptorManager(this.persistenceUnitName);
    protected DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
    protected List<Object> services = new ArrayList<Object>();
    protected boolean initialized = false;
    protected Map<String, List<String>> containerMappers = new ConcurrentHashMap<String, List<String>>();
    protected Map<String, List<String>> containerQueries = new ConcurrentHashMap<String, List<String>>();

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.kieServer = kieServer;
        this.context = registry;
        this.configureServices(kieServer, registry);
        if (registry.getKieSessionLookupManager() != null) {
            registry.getKieSessionLookupManager().addHandler((KieSessionLookupHandler)new JBPMKieSessionLookupHandler());
        }
        this.services.add(this.formManagerService);
        this.services.add(this.deploymentService);
        this.services.add(this.definitionService);
        this.services.add(this.processService);
        this.services.add(this.userTaskService);
        this.services.add(this.runtimeDataService);
        this.services.add(this.executorService);
        this.services.add(this.queryService);
        this.services.add(this.processInstanceMigrationService);
        this.services.add(this.processInstanceAdminService);
        this.services.add(this.userTaskAdminService);
        this.registerDefaultQueryDefinitions();
        this.initialized = true;
    }

    protected void configureServices(KieServerImpl kieServer, KieServerRegistry registry) {
        KieServerConfig config = registry.getConfig();
        String callbackConfig = System.getProperty("org.jbpm.ht.callback");
        if (callbackConfig == null || callbackConfig.isEmpty()) {
            System.setProperty("org.jbpm.ht.callback", "jaas");
            JAASUserGroupCallbackImpl.addExternalUserGroupAdapter((UserGroupAdapter)new JMSUserGroupAdapter());
        }
        this.isExecutorAvailable = this.isExecutorOnClasspath();
        EntityManagerFactory emf = this.build(this.getPersistenceProperties(config));
        EntityManagerFactoryManager.get().addEntityManagerFactory(this.persistenceUnitName, emf);
        this.formManagerService = new FormManagerServiceImpl();
        this.definitionService = new BPMN2DataServiceImpl();
        this.deploymentService = new KModuleDeploymentService();
        ((KModuleDeploymentService)this.deploymentService).setBpmn2Service(this.definitionService);
        ((KModuleDeploymentService)this.deploymentService).setEmf(emf);
        ((KModuleDeploymentService)this.deploymentService).setIdentityProvider(registry.getIdentityProvider());
        ((KModuleDeploymentService)this.deploymentService).setManagerFactory((RuntimeManagerFactory)new RuntimeManagerFactoryImpl());
        ((KModuleDeploymentService)this.deploymentService).setFormManagerService(this.formManagerService);
        UserGroupCallback userGroupCallback = UserDataServiceProvider.getUserGroupCallback();
        UserInfo userInfo = UserDataServiceProvider.getUserInfo();
        TaskService taskService = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(emf).userGroupCallback(userGroupCallback).userInfo(userInfo).getTaskService();
        this.runtimeDataService = new RuntimeDataServiceImpl();
        ((RuntimeDataServiceImpl)this.runtimeDataService).setCommandService(new TransactionalCommandService(emf));
        ((RuntimeDataServiceImpl)this.runtimeDataService).setIdentityProvider(registry.getIdentityProvider());
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskService(taskService);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskAuditService(TaskAuditServiceFactory.newTaskAuditServiceConfigurator().setTaskService(taskService).getTaskAuditService());
        ((KModuleDeploymentService)this.deploymentService).setRuntimeDataService(this.runtimeDataService);
        this.processService = new ProcessServiceImpl();
        ((ProcessServiceImpl)this.processService).setDataService(this.runtimeDataService);
        ((ProcessServiceImpl)this.processService).setDeploymentService(this.deploymentService);
        this.userTaskService = new UserTaskServiceImpl();
        ((UserTaskServiceImpl)this.userTaskService).setDataService(this.runtimeDataService);
        ((UserTaskServiceImpl)this.userTaskService).setDeploymentService(this.deploymentService);
        this.queryService = new QueryServiceImpl();
        ((QueryServiceImpl)this.queryService).setIdentityProvider(registry.getIdentityProvider());
        ((QueryServiceImpl)this.queryService).setCommandService(new TransactionalCommandService(emf));
        ((QueryServiceImpl)this.queryService).init();
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((RuntimeDataServiceImpl)this.runtimeDataService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((BPMN2DataServiceImpl)this.definitionService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((QueryServiceImpl)this.queryService));
        if (config.getConfigItemValue("org.kie.executor.disabled", "false").equalsIgnoreCase("false")) {
            String executorQueueName = config.getConfigItemValue("org.kie.executor.jms.queue", "queue/KIE.SERVER.EXECUTOR");
            this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)emf);
            this.executorService.setInterval(Integer.parseInt(config.getConfigItemValue("org.kie.executor.interval", "0")));
            this.executorService.setRetries(Integer.parseInt(config.getConfigItemValue("org.kie.executor.retry.count", "3")));
            this.executorService.setThreadPoolSize(Integer.parseInt(config.getConfigItemValue("org.kie.executor.pool.size", "1")));
            this.executorService.setTimeunit(TimeUnit.valueOf(config.getConfigItemValue("org.kie.executor.timeunit", "SECONDS")));
            ((ExecutorImpl)((ExecutorServiceImpl)this.executorService).getExecutor()).setQueueName(executorQueueName);
            ((KModuleDeploymentService)this.deploymentService).setExecutorService(this.executorService);
        }
        this.processInstanceMigrationService = new ProcessInstanceMigrationServiceImpl();
        this.processInstanceAdminService = new ProcessInstanceAdminServiceImpl();
        ((ProcessInstanceAdminServiceImpl)this.processInstanceAdminService).setProcessService(this.processService);
        ((ProcessInstanceAdminServiceImpl)this.processInstanceAdminService).setRuntimeDataService(this.runtimeDataService);
        ((ProcessInstanceAdminServiceImpl)this.processInstanceAdminService).setCommandService(new TransactionalCommandService(emf));
        ((ProcessInstanceAdminServiceImpl)this.processInstanceAdminService).setIdentityProvider(registry.getIdentityProvider());
        this.userTaskAdminService = new UserTaskAdminServiceImpl();
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setRuntimeDataService(this.runtimeDataService);
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setUserTaskService(this.userTaskService);
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setIdentityProvider(this.context.getIdentityProvider());
        ((UserTaskAdminServiceImpl)this.userTaskAdminService).setCommandService(new TransactionalCommandService(emf));
        this.kieContainerCommandService = new JBPMKieContainerCommandServiceImpl(this.context, this.deploymentService, new DefinitionServiceBase(this.definitionService, this.context), new ProcessServiceBase(this.processService, this.definitionService, this.runtimeDataService, this.context), new UserTaskServiceBase(this.userTaskService, this.context), new RuntimeDataServiceBase(this.runtimeDataService, this.context), new ExecutorServiceBase(this.executorService, this.context), new QueryDataServiceBase(this.queryService, this.context), new DocumentServiceBase(this.context), new ProcessAdminServiceBase(this.processInstanceMigrationService, this.processInstanceAdminService, this.context), new UserTaskAdminServiceBase(this.userTaskAdminService, this.context));
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        EntityManagerFactory emf;
        ((AbstractDeploymentService)this.deploymentService).shutdown();
        if (this.executorService != null) {
            this.executorService.destroy();
        }
        if ((emf = EntityManagerFactoryManager.get().remove(this.persistenceUnitName)) != null && emf.isOpen()) {
            emf.close();
        }
    }

    public void serverStarted() {
        if (this.executorService != null) {
            this.executorService.init();
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        List messages = (List)parameters.get("ContainerMessages");
        try {
            String mergeMode;
            KieServerConfig config;
            String runtimeStrategy;
            KieModuleMetaData metaData = (KieModuleMetaData)parameters.get("KieModuleMetaData");
            if (metaData.getProcesses() == null || metaData.getProcesses().isEmpty()) {
                logger.info("Container {} does not include processes, {} skipped", (Object)id, (Object)this);
                return;
            }
            boolean hasStatefulSession = false;
            boolean hasDefaultSession = false;
            InternalKieContainer kieContainer = (InternalKieContainer)kieContainerInstance.getKieContainer();
            Collection kbaseNames = kieContainer.getKieBaseNames();
            Collection ksessionNames = new ArrayList();
            for (String kbaseName : kbaseNames) {
                ksessionNames = kieContainer.getKieSessionNamesInKieBase(kbaseName);
                for (String ksessionName : ksessionNames) {
                    KieSessionModel model = kieContainer.getKieSessionModel(ksessionName);
                    if (model.getType().equals((Object)KieSessionModel.KieSessionType.STATEFUL)) {
                        hasStatefulSession = true;
                    }
                    if (!model.isDefault()) continue;
                    hasDefaultSession = true;
                }
            }
            if (!hasStatefulSession) {
                logger.info("Container {} does not define stateful ksession thus cannot be handled by extension {}", (Object)id, (Object)this);
                return;
            }
            ReleaseId releaseId = kieContainerInstance.getKieContainer().getReleaseId();
            CustomIdKmoduleDeploymentUnit unit = new CustomIdKmoduleDeploymentUnit(id, releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion());
            if (!hasDefaultSession) {
                unit.setKbaseName((String)kbaseNames.iterator().next());
                unit.setKsessionName((String)ksessionNames.iterator().next());
            }
            if ((runtimeStrategy = (config = new KieServerConfig(kieContainerInstance.getResource().getConfigItems())).getConfigItemValue("RuntimeStrategy")) != null && !runtimeStrategy.isEmpty()) {
                unit.setStrategy(RuntimeStrategy.valueOf((String)runtimeStrategy));
            }
            if ((mergeMode = config.getConfigItemValue("MergeMode")) != null && !mergeMode.isEmpty()) {
                unit.setMergeMode(MergeMode.valueOf((String)mergeMode));
            }
            String ksession = config.getConfigItemValue("KSession");
            unit.setKsessionName(ksession);
            String kbase = config.getConfigItemValue("KBase");
            unit.setKbaseName(kbase);
            unit.setKieContainer((KieContainer)kieContainer);
            this.addAsyncHandler(unit, kieContainer);
            if (System.getProperty("org.jbpm.task.cleanup.enabled", "true").equalsIgnoreCase("true")) {
                logger.debug("Registering TaskCleanUpProcessEventListener");
                this.addTaskCleanUpProcessListener(unit, kieContainer);
            }
            if (System.getProperty("org.jbpm.task.bam.enabled", "true").equalsIgnoreCase("true")) {
                logger.debug("Registering BAMTaskEventListener");
                this.addTaskBAMEventListener(unit, kieContainer);
            }
            if (System.getProperty("org.jbpm.process.identity.enabled", "true").equalsIgnoreCase("true")) {
                logger.debug("Registering IdentityProviderAwareProcessListener");
                this.addProcessIdentityProcessListener(unit, kieContainer);
            }
            this.deploymentService.deploy((DeploymentUnit)unit);
            DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(unit.getIdentifier());
            HashSet<Class<DocumentImpl>> customClasses = new HashSet<Class<DocumentImpl>>(deployedUnit.getDeployedClasses());
            customClasses.add(DocumentImpl.class);
            kieContainerInstance.addExtraClasses(customClasses);
            List addedMappers = QueryMapperRegistry.get().discoverAndAddMappers(kieContainer.getClassLoader());
            if (addedMappers != null && !addedMappers.isEmpty()) {
                this.containerMappers.put(id, addedMappers);
            }
            QueryParamBuilderManager.get().discoverAndAddQueryFactories(id, kieContainer.getClassLoader());
            Enumeration<URL> queryDefinitionsFiles = kieContainer.getClassLoader().getResources("query-definitions.json");
            while (queryDefinitionsFiles.hasMoreElements()) {
                URL definitionsURL = queryDefinitionsFiles.nextElement();
                InputStream qdStream = definitionsURL.openStream();
                this.loadAndRegisterQueryDefinitions(qdStream, kieContainerInstance.getMarshaller(MarshallingFormat.JSON), id);
            }
            logger.debug("Container {} created successfully by extension {}", (Object)id, (Object)this);
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            if (root == null) {
                root = e;
            }
            messages.add(new Message(Severity.ERROR, "Error when creating container " + id + " by extension " + this + " due to " + root.getMessage()));
            logger.error("Error when creating container {} by extension {}", new Object[]{id, this, e});
        }
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        states.add(0);
        states.add(4);
        Collection activeProcesses = this.runtimeDataService.getProcessInstancesByDeploymentId(id, states, new QueryContext());
        if (!activeProcesses.isEmpty()) {
            parameters.put("failure-reason", "Update of container forbidden - there are active process instances for container " + id);
            return false;
        }
        return true;
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.disposeContainer(id, kieContainerInstance, parameters);
        this.createContainer(id, kieContainerInstance, parameters);
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.deploymentService.isDeployed(id)) {
            logger.info("No container with id {} found", (Object)id);
            return;
        }
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        states.add(0);
        states.add(4);
        KModuleDeploymentUnit unit = (KModuleDeploymentUnit)this.deploymentService.getDeployedUnit(id).getDeploymentUnit();
        this.deploymentService.undeploy((DeploymentUnit)new CustomIdKmoduleDeploymentUnit(id, unit.getGroupId(), unit.getArtifactId(), unit.getVersion()));
        List<String> addedMappers = this.containerMappers.get(id);
        if (addedMappers != null && !addedMappers.isEmpty()) {
            for (String mapper : addedMappers) {
                QueryMapperRegistry.get().removeMapper(mapper);
            }
        }
        QueryParamBuilderManager.get().removeQueryFactories(id);
        logger.debug("Container {} disposed successfully by extension {}", (Object)id, (Object)this);
        List<String> queries = this.containerQueries.remove(id);
        if (queries != null) {
            logger.debug("Removing queries {} that comes from container {} that is being disposed", queries, (Object)id);
            queries.forEach(q -> {
                try {
                    this.queryService.unregisterQuery(q);
                }
                catch (QueryNotFoundException e) {
                    logger.debug("Query {} not found when being removed on container dispose", q);
                }
            });
        }
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.deploymentService, this.definitionService, this.processService, this.userTaskService, this.runtimeDataService, this.executorService, this.formManagerService, this.queryService, this.processInstanceMigrationService, this.processInstanceAdminService, this.userTaskAdminService, this.context};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        Object[] services;
        if (serviceType.isAssignableFrom(this.kieContainerCommandService.getClass())) {
            return (T)this.kieContainerCommandService;
        }
        for (Object service : services = new Object[]{this.deploymentService, this.definitionService, this.processService, this.userTaskService, this.runtimeDataService, this.executorService, this.formManagerService, this.queryService, this.processInstanceMigrationService, this.processInstanceAdminService, this.userTaskAdminService, this.context}) {
            if (service == null || !serviceType.isAssignableFrom(service.getClass())) continue;
            return (T)service;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BPM";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 0;
    }

    public String toString() {
        return "jBPM KIE Server extension";
    }

    protected void addAsyncHandler(KModuleDeploymentUnit unit, InternalKieContainer kieContainer) {
        if (this.isExecutorAvailable && this.executorService != null) {
            DeploymentDescriptor descriptor = this.getDeploymentDescriptor(unit, kieContainer);
            descriptor.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "async", "new org.jbpm.executor.impl.wih.AsyncWorkItemHandler(org.jbpm.executor.ExecutorServiceFactory.newExecutorService(null),\"org.jbpm.executor.commands.PrintOutCommand\")", new Object[0]));
            unit.setDeploymentDescriptor(descriptor);
        }
    }

    protected void addTaskBAMEventListener(KModuleDeploymentUnit unit, InternalKieContainer kieContainer) {
        DeploymentDescriptor descriptor = this.getDeploymentDescriptor(unit, kieContainer);
        descriptor.getBuilder().addTaskEventListener(new ObjectModel("mvel", "new org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener(false)", new Object[0]));
        unit.setDeploymentDescriptor(descriptor);
    }

    protected void addTaskCleanUpProcessListener(KModuleDeploymentUnit unit, InternalKieContainer kieContainer) {
        DeploymentDescriptor descriptor = this.getDeploymentDescriptor(unit, kieContainer);
        descriptor.getBuilder().addEventListener(new ObjectModel("mvel", "new org.jbpm.services.task.admin.listener.TaskCleanUpProcessEventListener(taskService)", new Object[0]));
        unit.setDeploymentDescriptor(descriptor);
    }

    protected void addProcessIdentityProcessListener(KModuleDeploymentUnit unit, InternalKieContainer kieContainer) {
        DeploymentDescriptor descriptor = this.getDeploymentDescriptor(unit, kieContainer);
        descriptor.getBuilder().addEventListener(new ObjectModel("mvel", "new org.jbpm.kie.services.impl.IdentityProviderAwareProcessListener(ksession)", new Object[0]));
        unit.setDeploymentDescriptor(descriptor);
    }

    protected DeploymentDescriptor getDeploymentDescriptor(KModuleDeploymentUnit unit, InternalKieContainer kieContainer) {
        DeploymentDescriptor descriptor = unit.getDeploymentDescriptor();
        if (descriptor == null) {
            List descriptorHierarchy = this.deploymentDescriptorManager.getDeploymentDescriptorHierarchy((KieContainer)kieContainer);
            descriptor = this.merger.merge(descriptorHierarchy, MergeMode.MERGE_COLLECTIONS);
        }
        return descriptor;
    }

    protected boolean isExecutorOnClasspath() {
        try {
            Class.forName("org.jbpm.executor.impl.wih.AsyncWorkItemHandler");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected Map<String, String> getPersistenceProperties(KieServerConfig config) {
        HashMap<String, String> persistenceProperties = new HashMap<String, String>();
        persistenceProperties.put("hibernate.dialect", config.getConfigItemValue("org.kie.server.persistence.dialect", "org.hibernate.dialect.H2Dialect"));
        persistenceProperties.put("hibernate.default_schema", config.getConfigItemValue("org.kie.server.persistence.schema"));
        persistenceProperties.put("hibernate.transaction.jta.platform", config.getConfigItemValue("org.kie.server.persistence.tm", "org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform"));
        persistenceProperties.put("javax.persistence.jtaDataSource", config.getConfigItemValue("org.kie.server.persistence.ds", "java:jboss/datasources/ExampleDS"));
        System.getProperties().stringPropertyNames().stream().filter(PersistenceUnitInfoLoader::isValidPersistenceKey).forEach(name -> persistenceProperties.put((String)name, System.getProperty(name)));
        return persistenceProperties;
    }

    protected EntityManagerFactory build(Map<String, String> properties) {
        try {
            InitialContext ctx = new InitialContext();
            InputStream inputStream = PersistenceUnitInfoLoader.class.getResourceAsStream(PERSISTENCE_XML_LOCATION);
            PersistenceUnitInfo info = PersistenceUnitInfoLoader.load(inputStream, ctx, this.getClass().getClassLoader());
            URL root = PersistenceUnitInfoLoader.class.getResource(PERSISTENCE_XML_LOCATION);
            String jarLocation = root.toExternalForm().split("!")[0].replace(PERSISTENCE_XML_LOCATION, "");
            try {
                ((PersistenceUnitInfoImpl)info).setPersistenceUnitRootUrl(new URL(jarLocation));
            }
            catch (Exception e) {
                ((PersistenceUnitInfoImpl)info).setPersistenceUnitRootUrl(root);
            }
            ((PersistenceUnitInfoImpl)info).setJtaDataSource(properties.get("javax.persistence.jtaDataSource"));
            List persistenceProviders = PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();
            PersistenceProvider selectedProvider = null;
            if (persistenceProviders != null) {
                for (PersistenceProvider provider : persistenceProviders) {
                    if (!provider.getClass().getName().equals(info.getPersistenceProviderClassName())) continue;
                    selectedProvider = provider;
                    break;
                }
            }
            return selectedProvider.createContainerEntityManagerFactory(info, properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create EntityManagerFactory due to " + e.getMessage(), e);
        }
    }

    protected void loadAndRegisterQueryDefinitions(InputStream qdStream, Marshaller marshaller, String containerId) throws IOException {
        if (qdStream != null) {
            String qdString = IOUtils.toString((InputStream)qdStream, (Charset)Charset.forName("UTF-8"));
            try {
                org.kie.server.api.model.definition.QueryDefinition[] queryDefinitionList = (org.kie.server.api.model.definition.QueryDefinition[])marshaller.unmarshall(qdString, org.kie.server.api.model.definition.QueryDefinition[].class);
                ArrayList queries = new ArrayList();
                Arrays.asList(queryDefinitionList).forEach(qd -> {
                    this.queryService.replaceQuery((QueryDefinition)QueryDataServiceBase.build(this.context, qd));
                    queries.add(qd.getName());
                    logger.debug("Registered '{}' query from container '{}' successfully", (Object)qd.getName(), (Object)containerId);
                });
                if (containerId != null) {
                    this.containerQueries.put(containerId, queries);
                }
            }
            catch (MarshallingException e) {
                logger.error("Error when unmarshalling query definitions from stream.", (Throwable)e);
            }
        }
    }

    protected void registerDefaultQueryDefinitions() {
        try {
            String externalLocationQueryDefinitions;
            InputStream qdStream = this.getClass().getResourceAsStream("/default-query-definitions.json");
            if (qdStream == null && (externalLocationQueryDefinitions = System.getProperty("org.jbpm.query.definitions.location")) != null) {
                qdStream = new FileInputStream(externalLocationQueryDefinitions);
            }
            this.loadAndRegisterQueryDefinitions(qdStream, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()), null);
            if (qdStream != null) {
                qdStream.close();
            }
        }
        catch (Exception e) {
            logger.error("Error when loading default query definitions from default-query-definitions.json", (Throwable)e);
        }
    }

    void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    void setContext(KieServerRegistry context) {
        this.context = context;
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        try {
            this.runtimeDataService.getProcessInstanceById(-99999L);
            if (report) {
                messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
            }
        }
        catch (Exception e) {
            messages.add(new Message(Severity.ERROR, this.getExtensionName() + " failed due to " + e.getMessage()));
        }
        return messages;
    }

    private static class CustomIdKmoduleDeploymentUnit
    extends KModuleDeploymentUnit {
        private String id;

        public CustomIdKmoduleDeploymentUnit(String id, String groupId, String artifactId, String version) {
            super(groupId, artifactId, version);
            this.id = id;
        }

        public String getIdentifier() {
            return this.id;
        }
    }
}

