/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.security;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.services.jbpm.security.ElytronUserGroupAdapter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;
import org.wildfly.security.auth.server.RealmUnavailableException;

@RunWith(value=MockitoJUnitRunner.class)
public class ElytronUserGroupAdapterTest {
    private static final String USER_ID = "user";
    private static final String WRONG_USER_ID = "anotherUser";
    private static final String ROLE_1 = "role1";
    private static final String ROLE_2 = "role2";
    private static final String ROLE_3 = "role3";
    @Mock
    private ElytronUserGroupAdapter adapter;

    @Test
    public void testNoSecurityContext() {
        PowerMockito.when((Object)this.adapter.getGroupsForUser((String)Mockito.anyObject())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn(null);
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isEmpty();
    }

    @Test
    public void testSecurityContextNoIdentity() {
        PowerMockito.when((Object)this.adapter.getGroupsForUser((String)Mockito.anyObject())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)USER_ID);
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)Assertions.assertThat((List)roles).isNotNull()).isEmpty();
    }

    @Test
    public void testSecurityForWrongUser() throws RealmUnavailableException {
        PowerMockito.when((Object)this.adapter.getGroupsForUser((String)Mockito.anyObject())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)USER_ID);
        PowerMockito.when((Object)this.adapter.runAsPrincipalExists(WRONG_USER_ID)).thenReturn((Object)true);
        PowerMockito.when((Object)this.adapter.toRunAsPrincipalRoles(WRONG_USER_ID, true)).thenReturn(Arrays.asList(ROLE_1, ROLE_2));
        List roles = this.adapter.getGroupsForUser(WRONG_USER_ID);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)roles).isNotNull()).hasSize(2)).contains((Object[])new String[]{ROLE_1, ROLE_2});
    }

    @Test
    public void testSecurityForLoggedUser() {
        PowerMockito.when((Object)this.adapter.getGroupsForUser((String)Mockito.anyObject())).thenCallRealMethod();
        PowerMockito.when((Object)this.adapter.getUserName()).thenReturn((Object)USER_ID);
        PowerMockito.when((Object)this.adapter.toPrincipalRoles((String)Mockito.anyObject())).thenReturn(Arrays.asList(ROLE_1, ROLE_2, ROLE_3));
        List roles = this.adapter.getGroupsForUser(USER_ID);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)roles).isNotNull()).hasSize(3)).contains((Object[])new String[]{ROLE_1, ROLE_2, ROLE_3});
    }
}

