/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.api;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.openshift.api.model.DeploymentCondition;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.Optional;
import org.kie.server.services.impl.KieServerLocator;

public interface KieServerOpenShift {
    default public boolean isKieServerReady() {
        return KieServerLocator.getInstance().isKieServerReady();
    }

    default public boolean isDCStable(DeploymentConfig dc) {
        return "True".equalsIgnoreCase(((DeploymentCondition)dc.getStatus().getConditions().get(0)).getStatus()) && dc.getStatus().getUnavailableReplicas() == 0;
    }

    default public Optional<DeploymentConfig> getKieServerDC(OpenShiftClient client, String serverId) {
        List deployments = ((DeploymentConfigList)((FilterWatchListDeletable)client.deploymentConfigs().withLabel("services.server.kie.org/kie-server-id", serverId)).list()).getItems();
        if (deployments.isEmpty()) {
            return Optional.empty();
        }
        if (deployments.size() == 1) {
            return Optional.ofNullable(deployments.get(0));
        }
        throw new IllegalStateException("Ambiguous KIE server id: [" + serverId + "]; more than one KIE server DeploymentConfig exists.");
    }

    default public Optional<ConfigMap> getKieServerCM(OpenShiftClient client, String serverId) {
        List configMaps = ((ConfigMapList)((FilterWatchListDeletable)client.configMaps().withLabel("services.server.kie.org/kie-server-id", serverId)).list()).getItems();
        if (configMaps.isEmpty()) {
            return Optional.empty();
        }
        if (configMaps.size() == 1) {
            return Optional.ofNullable(configMaps.get(0));
        }
        throw new IllegalStateException("Ambiguous KIE server id: [" + serverId + "]; more than one KIE server ConfigMaps exists.");
    }
}

